<?php $__env->startSection('content'); ?>

    <!--   Content -->
    <?php
        use Carbon\Carbon;
    ?>
    <div class="container-fluid">
        <!-- header banner -->
        <div class="row">
            <div class="col-xl-12 col-lg-12">
                <div class="card bg-secondary position-relative body-overflow">
                    <div class="card-header top-title-vuelve">
                        <h4 class="white-color font-weight-bold">Servicios Vuelve Compostario Conductor</h4>
                    </div>
                    <div class="card-body">
                        <h3 class="font-weight-bold white-color"><?php echo e($conductor->nombre_conductor); ?></h3>
                        <div class="row">
                            <div class="col-xl-10 col-lg-11 col-md-12">
                                <div class="row">
                                    <div class="col-lg-3 col-md-3 col-sm-3 px-2">
                                        <div class="item-plus d-flex align-items-center">
                                            <h2 class="font-weight-bold white-color">120</h2>
                                            <span class="white-color">Servicios completos</span>
                                        </div>
                                    </div>
                                    <div class="col-lg-3 col-md-3 col-sm-3 px-2">
                                        <div class="item-plus d-flex align-items-center ms-2">
                                            <h2 class="font-weight-bold white-color">24</h2>
                                            <span class="white-color">Mascotas recogidas</span>
                                        </div>
                                    </div>
                                    <div class="col-lg-3 col-md-3 col-sm-3 px-2">
                                        <div class="item-plus d-flex align-items-center">
                                            <h2 class="font-weight-bold white-color">12</h2>
                                            <span class="white-color">Macetas entregadas</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="image-footer">
                        <div class="image-absolute">
                            <img src="../assets/img/oval-vector.svg" alt="">
                            <img src="../assets/img/car-vuelve.svg" alt="">
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- content -->
        <div class="row">
            <div class="col-xl-9 col-lg-9 col-md-12 g-4">
                <div class="row">
                    <!-- Active recojo -->
                    <div class="col-xl-4 col-lg-4 col-md-6">
                        <div class="card">
                            <div class="card-body">
                                <p class="f-weight black-main d-flex f-weight-50 title-md">Servicios en curso
                                </p>
                                <?php $__currentLoopData = $recojos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $recojo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                    <?php if($recojo->estado == 2): ?>
                                        <a href="/conductor/actividades/<?php echo e($recojo->id_recojo); ?>">
                                            <div class="mb-3 border border-radius-md p-2">
                                                <div class="card-body p-0">
                                                    <div class="bg-eden-60 text-white d-inline-flex border-radius-md p-1 px-2 font-weight-bold text-xs mb-1">
                                                        <?php if($recojo->nombre_mascota == 1): ?>
                                                            Recojo
                                                        <?php else: ?>
                                                            Entrega
                                                        <?php endif; ?>
                                                    </div>
                                                    <h5 class="f-weight-70 black-main headline-h6 f-weight mb-1"><?php echo e($recojo->nombre_mascota); ?></h5>
                                                    <div class="progress bg-g-30" style="height: 1.74vh;">
                                                        <div class="progress-bar bg-surface-primary" role="progressbar" aria-valuenow="15"
                                                             aria-valuemin="0" aria-valuemax="100" data-bs-toggle="tooltip"
                                                             data-bs-placement="top" aria-label="Gross value"
                                                             data-bs-original-title="Gross value" style="width: 50%">
                                                        </div>
                                                    </div>

                                                </div>
                                                <div class="card-footer p-0 mt-2">
                                                    
                                                    <div class="d-flex align-items-center">
                                                        <i class="ri-time-line t-verde me-2 pt-0" style="font-size: 20px;"></i>
                                                        <p class="m-0 font-weight-bold text-xs"><?php echo e($recojo->horario); ?></p>
                                                    </div>
                                                    <div class="d-flex align-items-center">
                                                        <i class="ri-calendar-line t-verde me-2" style="font-size: 20px;"></i>
                                                        <p class="m-0 font-weight-bold text-xs"><?php echo e($recojo->fecha_recojo); ?></p>
                                                    </div>

                                                </div>
                                            </div>
                                        </a>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    </div>
                    <!-- chart -->
                    <div class="col-md-8">
                        <div class="card z-index-2">
                            <div class="card-header p-3 pb-0 d-flex justify-content-between align-items-center">
                                <p class="f-weight m-0">Análisis de Servicios</p>
                                <select name="" id="" class="form-select form-select-chart" aria-label="Default select example"
                                        style="width: 40%;">
                                    <option selected data-chart="barchart-sem" class="labeltext font-weight-bold">Esta Semana</option>
                                    <option value="1" data-chart="barchart-15dias" class="labeltext font-weight-bold">Últimos 15 dias</option>
                                    <option value="2" data-chart="barchart-1mes" class="labeltext font-weight-bold">Este mes</option>
                                </select>
                            </div>
                            <div class="card-body p-3">
                                <div id="barchart-sem" class="chart">
                                    <canvas id="bar-chart-sem" class="chart-canvas" height="261"></canvas>
                                </div>
                                <div id="barchart-15dias" class="chart d-none">
                                    <canvas id="bar-chart-15dias" class="chart-canvas" height="261"></canvas>
                                </div>
                                <div id="barchart-1mes" class="chart d-none">
                                    <canvas id="bar-chart-1mes" class="chart-canvas" height="261"></canvas>
                                </div>
                            </div>

                        </div>
                    </div>

                    <!-- Table -->
                    <div class="col-xl-12 col-lg-12 col-md-12 g-4">
                        <div class="card border-radius-lg">
                            <div class="card-header tabla-top pb-2">
                                <div class="d-flex tabla-servicio align-items-center justify-content-between">
                                    <p class="f-weight black-main m-0">Lista de servicios</p>
                                    <div class="tabs-list-service w-auto">
                                        <select name="" id="" class="form-select form-select-sem" aria-label="Default select example">
                                            <option selected data-semana="table-7dias" class="labeltext font-weight-bold">Esta Semana</option>
                                            <option value="1" data-semana="table-15dias" class="labeltext font-weight-bold">Últimos 15 dias</option>
                                            <option value="2" data-semana="table-1mes" class="labeltext font-weight-bold">Este mes</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="card-body">
                                <div class="semanaselect d-none" id="table-1mes">
                                    <div class="table-responsive">
                                        <table class="table table-flush" id="datatable-basic">
                                            <thead class="bg-grey-10">
                                            <tr>
                                                <th data-sortable="" class="px-0 ps-2 c-princi text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                    <a href="" class="dataTable-sorter">Cliente</a></th>
                                                <th data-sortable="" class="px-0 ps-2 c-princi text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                    <a href="" class="dataTable-sorter">Nombre de mascota</a></th>
                                                <th data-sortable="" class="px-0 ps-2 c-princi text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                    <a href="" class="dataTable-sorter">Tipo</a></th>
                                                <th data-sortable="" class="px-0 ps-2 c-princi text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                    <a href="" class="dataTable-sorter">Fecha</a></th>
                                                <th data-sortable="" class="px-0 ps-2 c-princi text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                    <a href="" class="dataTable-sorter">Horario</a></th>
                                                <th data-sortable="" class="px-0 ps-2 c-princi text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                    <a href="" class="dataTable-sorter">Distrito</a></th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            <?php $__currentLoopData = $recojos1mes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $recojo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <td class="text-sm font-weight-bold text-sm black-main"><?php echo e($recojo->nombres); ?> <?php echo e($recojo->apellidos); ?></td>
                                                    <td class="text-sm font-weight-bold text-sm black-main"><?php echo e($recojo->nombre_mascota); ?></td>
                                                    <td class="text-sm font-weight-bold text-sm black-main"><?php echo e($recojo->tipo_mascota); ?></td>
                                                    <td class="text-sm font-weight-bold text-sm black-main"><?php echo e($recojo->fecha_recojo); ?></td>
                                                    <td class="text-sm font-weight-bold text-sm black-main"><?php echo e($recojo->horario); ?></td>
                                                    <td class="text-sm font-weight-bold text-sm black-main"><?php echo e($recojo->distrito); ?></td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                                <div class="semanaselect d-none" id="table-15dias">
                                    <div class="table-responsive">
                                        <table class="table table-flush" id="datatable-basic">
                                            <thead class="bg-grey-10">
                                            <tr>
                                                <th data-sortable="" class="px-0 ps-2 c-princi text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                    <a href="" class="dataTable-sorter">Cliente</a></th>
                                                <th data-sortable="" class="px-0 ps-2 c-princi text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                    <a href="" class="dataTable-sorter">Nombre de mascota</a></th>
                                                <th data-sortable="" class="px-0 ps-2 c-princi text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                    <a href="" class="dataTable-sorter">Tipo</a></th>
                                                <th data-sortable="" class="px-0 ps-2 c-princi text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                    <a href="" class="dataTable-sorter">Fecha</a></th>
                                                <th data-sortable="" class="px-0 ps-2 c-princi text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                    <a href="" class="dataTable-sorter">Horario</a></th>
                                                <th data-sortable="" class="px-0 ps-2 c-princi text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                    <a href="" class="dataTable-sorter">Distrito</a></th>
                                            </tr>
                                            </thead>
                                            <tbody>

                                            <?php $__currentLoopData = $recojos15dias; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $recojo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                                <tr>
                                                    <td class="text-sm font-weight-bold text-sm black-main"><?php echo e($recojo->nombres); ?> <?php echo e($recojo->apellidos); ?></td>
                                                    <td class="text-sm font-weight-bold text-sm black-main"><?php echo e($recojo->nombre_mascota); ?></td>
                                                    <td class="text-sm font-weight-bold text-sm black-main"><?php echo e($recojo->tipo_mascota); ?></td>
                                                    <td class="text-sm font-weight-bold text-sm black-main"><?php echo e($recojo->fecha_recojo); ?></td>
                                                    <td class="text-sm font-weight-bold text-sm black-main"><?php echo e($recojo->horario); ?></td>
                                                    <td class="text-sm font-weight-bold text-sm black-main"><?php echo e($recojo->distrito); ?></td>
                                                </tr>

                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                                <div class="semanaselect" id="table-7dias">
                                    <div class="table-responsive">
                                        <table class="table table-flush" id="datatable-basic">
                                            <thead class="bg-grey-10">
                                            <tr>
                                                <th data-sortable="" class="px-0 ps-2 c-princi text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                    <a href="" class="dataTable-sorter">Cliente</a></th>
                                                <th data-sortable="" class="px-0 ps-2 c-princi text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                    <a href="" class="dataTable-sorter">Nombre de mascota</a></th>
                                                <th data-sortable="" class="px-0 ps-2 c-princi text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                    <a href="" class="dataTable-sorter">Tipo</a></th>
                                                <th data-sortable="" class="px-0 ps-2 c-princi text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                    <a href="" class="dataTable-sorter">Fecha</a></th>
                                                <th data-sortable="" class="px-0 ps-2 c-princi text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                    <a href="" class="dataTable-sorter">Horario</a></th>
                                                <th data-sortable="" class="px-0 ps-2 c-princi text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                    <a href="" class="dataTable-sorter">Distrito</a></th>
                                            </tr>
                                            </thead>
                                            <tbody>

                                            <?php $__currentLoopData = $recojos7dias; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $recojo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                                <tr>
                                                    <td class="text-sm font-weight-bold text-sm black-main"><?php echo e($recojo->nombres); ?> <?php echo e($recojo->apellidos); ?></td>
                                                    <td class="text-sm font-weight-bold text-sm black-main"><?php echo e($recojo->nombre_mascota); ?></td>
                                                    <td class="text-sm font-weight-bold text-sm black-main"><?php echo e($recojo->tipo_mascota); ?></td>
                                                    <td class="text-sm font-weight-bold text-sm black-main"><?php echo e($recojo->fecha_recojo); ?></td>
                                                    <td class="text-sm font-weight-bold text-sm black-main"><?php echo e($recojo->horario); ?></td>
                                                    <td class="text-sm font-weight-bold text-sm black-main"><?php echo e($recojo->distrito); ?></td>
                                                </tr>

                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- end content -->
            <!-- list -->
            <div class="col-xl-3 col-lg-3 col-12 g-4">
                <div class="card bg-success d-flex flex-column justify-content-center pb-3">
                    <div class="card-header pb-0">
                        <p class="f-weight-50 white-color title-md">Mascotas por recoger</p>
                    </div>
                    <div class="row">
                        <?php $__currentLoopData = $recojos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $recojo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                            <?php if($recojo->estado == 1): ?>
                                <div class="col-xl-12 col-lg-12 col-md-6 col-sm-6 col-xs-12 border-l">
                                    <div class="card list-recojo bg-eden-60 por-recoger mb-3">
                                        <a class="card-body border-radius-md d-flex" href="/conductor/actividades/<?php echo e($recojo->id_recojo); ?>">
                                            <div class="info-pending">
                                                <div class="d-flex align-items-center">
                                                    <img src="../assets/img/icon_car-c-a.svg" alt="" height="40">
                                                    <?php if($recojo->etapa == 1): ?>
                                                        <p class="ms-2 white-color headline-h6 f-weight mb-0" style="line-height: 1.27;">Recoger a <span><?php echo e($recojo->nombre_mascota); ?></span></p>
                                                    <?php elseif($recojo->etapa == 2): ?>
                                                        <p class="ms-2 white-color headline-h6 f-weight mb-0" style="line-height: 1.27;">Entregar a <span><?php echo e($recojo->nombre_mascota); ?></span></p>
                                                    <?php endif; ?>
                                                </div>
                                                <div class="ps-2">
                                                    <div class="d-flex align-items-center">
                                                        <i class="ri-time-line t-verde me-2 pt-0" style="font-size: 20px;"></i>
                                                        <p class="m-0 font-weight-bold text-sm white-color"><?php echo e($recojo->horario); ?></p>
                                                    </div>
                                                    <div class="d-flex align-items-center">
                                                        <i class="ri-calendar-line t-verde me-2" style="font-size: 20px;"></i>
                                                        <p class="m-0 font-weight-bold text-sm white-color"><?php echo e($recojo->fecha_recojo); ?></p>
                                                    </div>
                                                </div>
                                            </div>
                                        </a>
                                    </div>
                                </div>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <script src="<?php echo e(asset('assets/js/plugins/chartjs.min.js?v=').time()); ?>"></script>
    <script>
        console.log('rdd')
        // Bar chart
        var barchartsem = document.getElementById("bar-chart-sem").getContext("2d");
        var barchart15dias = document.getElementById("bar-chart-15dias").getContext("2d");
        var barchart1mes = document.getElementById("bar-chart-1mes").getContext("2d");


        new Chart(barchartsem, {
            type: "bar",
            data: {
                labels: ['Lunes', 'Martes', 'Miercoles', 'Jueves', 'Viernes', 'Sabado', 'Domingo'],
                datasets: [{
                    label: "Traslados",
                    weight: 5,
                    borderWidth: 0,
                    borderRadius: 4,
                    backgroundColor: '#3A416F',
                    data: [15, 20, 12, 60, 20, 15, 8],
                    fill: false,
                    maxBarThickness: 35
                }],
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    legend: {
                        display: false,
                    }
                },
                scales: {
                    y: {
                        grid: {
                            drawBorder: false,
                            display: true,
                            drawOnChartArea: true,
                            drawTicks: false,
                            borderDash: [5, 5]
                        },
                        ticks: {
                            display: true,
                            padding: 10,
                            color: '#9ca2b7'
                        }
                    },
                    x: {
                        grid: {
                            drawBorder: false,
                            display: false,
                            drawOnChartArea: true,
                            drawTicks: true,
                        },
                        ticks: {
                            display: true,
                            color: '#9ca2b7',
                            padding: 10
                        }
                    },
                },
            },
        });

        new Chart(barchart15dias, {
            type: "bar",
            data: {
                labels: ['Lunes', 'Martes', 'Miercoles', 'Jueves', 'Viernes', 'Sabado', 'Domingo', 'Lunes', 'Martes', 'Miercoles', 'Jueves', 'Viernes', 'Sabado', 'Domingo'],
                datasets: [{
                    label: "Traslados",
                    weight: 5,
                    borderWidth: 0,
                    borderRadius: 4,
                    backgroundColor: '#3A416F',
                    data: [15, 20, 12, 60, 20, 15, 8, 20, 12, 2, 51, 60, 15, 8],
                    fill: false,
                    maxBarThickness: 35
                }],
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    legend: {
                        display: false,
                    }
                },
                scales: {
                    y: {
                        grid: {
                            drawBorder: false,
                            display: true,
                            drawOnChartArea: true,
                            drawTicks: false,
                            borderDash: [5, 5]
                        },
                        ticks: {
                            display: true,
                            padding: 10,
                            color: '#9ca2b7'
                        }
                    },
                    x: {
                        grid: {
                            drawBorder: false,
                            display: false,
                            drawOnChartArea: true,
                            drawTicks: true,
                        },
                        ticks: {
                            display: true,
                            color: '#9ca2b7',
                            padding: 10
                        }
                    },
                },
            },
        });

        new Chart(barchart1mes, {
            type: "bar",
            data: {
                labels: ['SEM 1', 'SEM 2', 'SEM 3', 'SEM 4'],
                datasets: [{
                    label: "Traslados",
                    weight: 5,
                    borderWidth: 0,
                    borderRadius: 4,
                    backgroundColor: '#3A416F',
                    data: [15, 20, 12, 60],
                    fill: false,
                    maxBarThickness: 35
                }],
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    legend: {
                        display: false,
                    }
                },
                scales: {
                    y: {
                        grid: {
                            drawBorder: false,
                            display: true,
                            drawOnChartArea: true,
                            drawTicks: false,
                            borderDash: [5, 5]
                        },
                        ticks: {
                            display: true,
                            padding: 10,
                            color: '#9ca2b7'
                        }
                    },
                    x: {
                        grid: {
                            drawBorder: false,
                            display: false,
                            drawOnChartArea: true,
                            drawTicks: true,
                        },
                        ticks: {
                            display: true,
                            color: '#9ca2b7',
                            padding: 10
                        }
                    },
                },
            },
        });

    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('front.layouts.userconductor', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /opt/homebrew/var/www/cliente_vuelvecompostario/web-vuelvecompostario/vuelve/resources/views/front/conductor/inicio.blade.php ENDPATH**/ ?>