<div class="card card-plain">
    <div class="card-header pt-0 px-0 pb-0 text-start">
        <h2 class="fs-4 f-weight text-dark">Datos para el recojo</h2>
    </div>

    <div class="card-body px-0">
        <div class="row justify-content-between">
            <div class="col-md-12 mb-3">
                <p class="mb-0 text-xs">Por favor, indícanos si deseas el servicio de manera inmediata o si tienes un horario específico en el que deseas que estemos ahí :</p>
                <div class="d-flex align-items-center pt-4 pb-2 flex-column flex-sm-row" id="serviciotraslado-true">
                    <div class="mb-2 mb-sm-0 w-100 w-sm-50 mx-2 d-flex align-items-center p-2 border bg-success-bj">
                        <input class="form-check-input servicio-recojo position-absolute opacity-0" checked value="inmediato" type="radio" name="servicio-recojo" id="serviciotraslado-inmediato">
                        <label class="form-check-label d-flex align-items-center m-0" for="serviciotraslado-inmediato">
                            <i class="fs-5 normal fa-regular fa-circle-check t-verde m-2"></i>
                            <p class="text-xs m-0"><strong>Necesito el servicio lo más pronto posible</strong></p>
                        </label>
                    </div>
                    <div class="w-100 w-sm-50 mx-2 d-flex align-items-center p-2 border">
                        <input class="form-check-input servicio-recojo position-absolute opacity-0" value="programado" type="radio" name="servicio-recojo" id="serviciotraslado-programado">
                        <label class="form-check-label d-flex align-items-center m-0" for="serviciotraslado-programado">
                            <i class="fs-5 normal fa-regular fa-circle-check t-verde m-2 opacity-0"></i>
                            <p class="text-xs m-0"><strong>Tengo un horario programado</strong></p>
                        </label>
                    </div>
                </div>
                <div id="servicio-recojo-inmediato-info" class="px-2">
                    <p class="text-xs mb-0">
                        Entendemos la urgencia de la situación, te enviaremos un correo confirmando el horario más cercano para recoger a tu mascota, estaremos ahí lo más pronto posible.
                    </p>
                </div>
                <div id="servicio-recojo-programado-info" class="px-2 d-none">
                    <div class="row">
                        <div class="col-md-12 col-lg-6 mb-2">
                            <?php
                                use Carbon\Carbon;

                                $fechaActual = Carbon::now()->format('Y-m-d');;

                            ?>

                            <div class="d-md-flex row justify-content-between">
                                <div class="d-block  col-md-7 pe-0">
                                    <label for="fecha_recojo" class="text-dark form-label mb-1">Día</label>
                                    <input type="hidden" name="dia-innmediato" value="<?php echo e($fechaActual); ?>">
                                    <input type="date" class="form-control" id="fecha_recojo" name="fecha_recojo" placeholder="Placeholder" value="">


                                </div>
                                <div class="col-md-5">
                                    <label for="recojo" class="text-dark form-label mb-1">Costo extra</label>
                                    <input type="hidden" placeholder="S/." id="fechascostoform_recojo" class="form-control form-control-alternative" disabled/>
                                    <input type="text" placeholder="S/." id="fechascosto_recojo" class="form-control form-control-alternative" disabled/>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-12 col-lg-6 mb-2">


                            <div class="d-md-flex row justify-content-between">
                                <div class="d-block col-md-7 pe-0">
                                    <label for="hora_recojo" class="text-dark form-label mb-1">Hora</label>
                                    <input type="hidden" name="horario-innmediato" value="<?php echo e($horario_first->id_horario); ?>">
                                    <select class="form-select" id="hora_recojo" name="hora_recojo" aria-label="Default select example">
                                        <option selected disabled>Seleccionar</option>

                                        <?php if($horarios): ?>
                                            <?php $__currentLoopData = $horarios; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $horario): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($horario->id_horario); ?>" data-costo="<?php echo e($horario->costo); ?>" class="text-dark"><?php echo e($horario->horario); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php endif; ?>
                                    </select>
                                </div>

                                <div class="col-md-5">
                                    <label for="recojo" class="text-dark form-label mb-1">Costo extra</label>
                                    <input type="text" placeholder="S/." id="costo_recojo" class="form-control form-control-alternative" disabled/>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-12 mb-0">
                            <p class="mt-2 text-xs normal mb-0">Atención disponible los 365 días del año, incluyendo domingos y feriados, con cargos
                                adicionales según horario y día laboral.</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php
            $distritos = DB::table('distritos')->get();

        ?>

        <?php if(empty(!$recojo)): ?>
            <div class="row">
                <div class="col-12">
                    <h6 class="f-weight">¿La dirección de entrega es ultima registrada para el recojo?</h6>
                    <p class="text-sm my-3"><strong>Dirección de recojo: </strong><?php echo e($recojo->direccion_recojo); ?></p>
                    <div class="d-sm-flex mt-4">
                        <div class="rounded-pill bg-success-bj border mb-3 me-3" id="cambiarDireccionBtn">
                            <div class="form-check m-2 mx-3">
                                <input class="form-check-input nueva_direccion_r" value="true" type="radio" checked name="nuevaDireccion" id="nuevaDireccion2">
                                <label class="form-check-label" for="nuevaDireccion2">
                                    Cambiar dirección
                                </label>
                            </div>
                        </div>
                        <div class="rounded-pill bg-success-bj border mb-3" id="cambiarDireccionBtn2">
                            <div class="form-check m-2 mx-3">
                                <input class="form-check-input nueva_direccion_r" data-iddistrito="<?php echo e($recojo->id_distrito); ?>" data-direccion="<?php echo e($recojo->direccion_recojo); ?>" value="false" type="radio" name="nuevaDireccion" id="nuevaDireccion1">
                                <label class="form-check-label" for="nuevaDireccion1">
                                    Mantener dirección
                                </label>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        <?php endif; ?>


        <div class="row justify-content-between">
            <div class="col-md-8 mb-2">
                <label for="distrito_recojo" class="text-dark form-label mb-1">Distrito</label>
                <select class="form-select" id="distrito_recojo" name="distrito_recojo" aria-label="Default select example">
                    <option value="" selected disabled>Seleccionar</option>
                    <?php if($distritos): ?>
                        <?php $__currentLoopData = $distritos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $distrito): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            
                            
                            
                            <option value="<?php echo e($distrito->id_distrito); ?>" data-costo="<?php echo e($distrito->costo); ?>" class="text-dark"><?php echo e($distrito->distrito); ?></option>
                            
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>
                </select>
            </div>

            <div class="col-md-4 mb-2">
                <label for="recojo" class="text-dark form-label mb-1">Costo extra</label>
                <input type="text" placeholder="S/." id="costo_distrito" class="form-control form-control-alternative" disabled/>
            </div>
            <div class="col-12">
                <p class="mt-2 text-xs normal">El recojo está incluido para los distritos aledaños a nuestro compostario. Para otras zonas, se aplicarán cargos extras.</p>
            </div>

        </div>

        <div class="row justify-content-between">
            <div class="col-md-12 mb-2">
                <label for="direccion_recojo" class="text-dark form-label mb-1">Dirección exacta para el recojo</label>
                
                
                
                <input type="text" class="form-control" id="direccion_recojo" name="direccion_recojo" placeholder="Escriba la dirección exacta">
                
            </div>
        </div>

        <div class="row justify-content-between">
            <div class="col-md-12 mt-2 mb-1">
                <p class="fs-5 mb-2 1234
                f-weight text-dark">Información para la entrega</p>
                <div class="mt-2">
                    <p class="mb-0 text-sm">Luego que recojamos a tu mascota, en esta plataforma podrás:</p>
                    <div class="mt-2 d-flex align-items-center">
                        <i class="fs-5 normal fa-regular fa-circle-check t-verde m-2"></i>
                        <p class="text-sm mt-1 mb-1">Confirmar dirección de entrega.</p>
                    </div>
                    <div class="mt-0 d-flex align-items-center">
                        <i class="fs-5 normal fa-regular fa-circle-check t-verde m-2"></i>
                        <p class="text-sm mt-1 mb-1">Escoger las opciones de maceta y planta que más te guste.</p>
                    </div>
                </div>
            </div>
        </div>

    </div>

    <div class="card-header px-0 pb-0">
        <div class="text-md-end text-sm-center  d-flex justify-content-between">
            <a href="#" data-steap="2" class="mx-1 btn btn-outline-dark btn-lg btn-volver-form fs-6  semibold">Volver</a>
            <a type="button" id="paso-3" data-steap="4" href="#" class="mx-1 btn btn-success btn-lg  fs-6 semibold">Continuar</a>

        </div>
    </div>
    <hr>
    <div class="">
        <div class="d-flex justify-content-between align-items-center">
            <div class="text-center rounded-circle orden border border-success border-2 text-xs normal"><i
                    class="t-verde fa-solid fa-check"></i></div>
            <hr class="flex-grow-1 hr-v">
            <div class="text-center rounded-circle orden border border-success border-2 text-xs normal"><i
                    class="t-verde fa-solid fa-check"></i></div>
            <hr class="flex-grow-1 hr-v">
            <div class="text-center rounded-circle orden border border-success border-2 bg-success text-white text-xs normal">3
            </div>
            <hr class="flex-grow-1 hr-v">
            <div class="text-center rounded-circle orden border text-xs normal">4</div>
            <hr class="flex-grow-1 hr-o">
            <div class="text-center rounded-circle orden border text-xs normal">5</div>
            <hr class="flex-grow-1 hr-o">
            <div class="text-center rounded-circle orden border text-xs normal">6</div>
            
        </div>
        <div class="d-flex justify-content-between align-items-center">
            <h6 class="f-weight text-xs">Datos</h6>
            <hr class="flex-grow-1 hr-t">
            <h6 class="f-weight text-xs">Mascota</h6>
            <hr class="flex-grow-1 hr-t">
            <h6 class="f-weight text-xs">Recojo</h6>
            
            <hr class="flex-grow-1 hr-t">
            <h6 class="semibold text-xs text-secondary">Extras</h6>
            <hr class="flex-grow-1 hr-t">
            <h6 class="semibold text-xs text-secondary">Cuotas</h6>
            <hr class="flex-grow-1 hr-t">
            <h6 class="semibold text-xs text-secondary">Pago</h6>
        </div>
        </divv>
    </div>
<?php /**PATH /opt/homebrew/var/www/cliente_vuelvecompostario/web-vuelvecompostario/vuelve/resources/views/front/servicionuevo/paso-3.blade.php ENDPATH**/ ?>