<!DOCTYPE html>
<html lang="es">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
    <title>Notificación de Compostario</title>
    <style type="text/css">
        /* Reset styles for email clients */
        body {
            margin: 0;
            padding: 0;
            background-color: #dfe4e7;
        }

        table {
            border-collapse: collapse;
        }

        img {
            border: 0;
            outline: none;
            text-decoration: none;
        }

        a {
            text-decoration: none;
        }

        /* Responsive styles */
        @media  screen and (max-width: 600px) {
            .container {
                width: 100% !important;
            }

            .content {
                padding: 20px !important;
            }

            .header {
                padding: 20px !important;
            }

            .header h1 {
                font-size: 20px !important;
            }
        }
    </style>
</head>
<body style="margin: 0; padding: 0; background-color: #dfe4e7; font-family: 'Helvetica Neue', Helvetica, Roboto, Arial, sans-serif;">
<center style="width: 100%; background-color: #ecf2fd;">
    <table border="0" cellpadding="0" cellspacing="0" width="100%" style="max-width: 600px; margin: 0 auto;">
        <tbody>
        <tr>
            <td align="center" valign="top">
                <table border="0" cellpadding="0" cellspacing="0" width="100%" style="background-color: #ffffff; border-radius: 8px; box-shadow: 0 2px 4px rgba(0,0,0,0.1);">
                    <!-- Header -->
                    <tbody>
                    <tr>
                        <td style="background-color: #A2B260; color: #ffffff; border-radius: 8px 8px 0 0; padding: 30px; text-align: center;">
                            <img src="<?php echo e(asset('assets/img/logo__brand-vuelve.svg')); ?>" alt="Compostario Logo" style="max-width: 150px; margin-bottom: 20px;">
                            <h1 style="font-size: 24px; font-weight: 400; line-height: 1.4; margin: 0; color: #ffffff;">
                                ¿Cómo está la planta de <?php echo e($data['nombre_mascota']); ?>?
                            </h1>
                        </td>
                    </tr>
                    <!-- Content -->
                    <tr>
                        <td style="background-color: #ffffff; padding: 40px 30px;">
                            <table border="0" cellpadding="0" cellspacing="0" width="100%">
                                <tbody>
                                <tr>
                                    <td style="color: #4a4a4a; font-size: 16px; line-height: 1.5; font-weight: 300;">
                                        <p style="margin: 0 0 20px;">Hola, <?php echo e($data['nombre_usuario']); ?>,</p>
                                        <p style="margin: 0 0 20px;">
                                            Ahora que ya tienes a <strong><?php echo e($data['nombre_mascota']); ?></strong> en su nueva forma de vida 💚, nos gustaría saber cómo está su planta. 🌱 ¿Has podido seguir los tips de cuidado? Esperamos que vaya todo bien. 🌿💚
                                        </p>
                                        <p style="margin: 0 0 20px;">
                                            Si tienes alguna consulta o duda sobre su cuidado, por favor, escríbenos, estamos felices de ayudarte.
                                        </p>
                                        <p style="margin: 0 0 20px;">
                                            Además, queríamos decirte que valoramos mucho tu opinión y nos gustaría seguir mejorando nuestro servicio para brindar la mejor atención a futuras familias. Por favor, si puedes tomarte unos minutos para completar nuestra encuesta, nos ayudarás a entender
                                            mejor tu experiencia e identificar áreas de mejora.
                                        </p>
                                        <p style="text-align: center; margin: 30px 0;">
                                            <a href="#" style="background-color: #A2B260; color: #ffffff; padding: 12px 24px; border-radius: 5px; text-decoration: none; font-weight: 500; display: inline-block;">
                                                Completa la encuesta
                                            </a>
                                        </p>
                                        <p style="margin: 0 0 20px;">
                                            Gracias de antemano por tu tiempo. ☺️
                                        </p>
                                        <p style="margin: 0 0 20px;">
                                            ¡Muchas gracias!
                                        </p>
                                    </td>
                                </tr>
                                </tbody>
                            </table>
                        </td>
                    </tr>
                    <!-- Footer -->
                    <tr>
                        <td style="background-color: #f8f8f8; padding: 20px; text-align: center; color: #7a7a7a; font-size: 14px; border-radius: 0 0 8px 8px;">
                            <p style="margin: 0;">© 2025 Compostario. Todos los derechos reservados.</p>
                            <p style="margin: 10px 0 0;">
                                <a href="#" style="color: #A2B260; text-decoration: none;">Contáctanos</a> |
                                <a href="#" style="color: #A2B260; text-decoration: none;">Política de Privacidad</a>
                            </p>
                        </td>
                    </tr>
                    </tbody>
                </table>
            </td>
        </tr>
        </tbody>
    </table>
</center>
</body>
</html>
<?php /**PATH /opt/homebrew/var/www/cliente_vuelvecompostario/web-vuelvecompostario/vuelve/resources/views/emails/usuario/seguimiento_etapa_8.blade.php ENDPATH**/ ?>