<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\WebController;
use App\Http\Controllers\UsuariosController;
use App\Http\Controllers\OperarioController;
use App\Http\Controllers\ConductorController;
use App\Http\Controllers\AdminController;
use App\Http\Controllers\AjaxController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

// USUARIO

Route::get('/test-email', [App\Http\Controllers\TestEmailController::class, 'sendTestEmail']);

Route::get('/phpinfo', function () {
    phpinfo();
});

Route::get('/', function () {
    return view('front.home');
});

Route::get('/elegir-servicio', function () {
    return view('front.elegir_servicio');
});

// Route::get('/registro-exitoso', function () {
//     return view('front.registro-exitoso');
// })->name('registro-exitoso');

//Registro Vuelve a Casa
Route::match(['get', 'post'], '/registro-vuelve-a-casa', [\App\Http\Controllers\RegistroVuelveaCasa::class, 'registroVuelveaCasa'])->name('registro_vuelve_acasa');
Route::match(['get', 'post'], '/registro-vuelve-a-casa/extras', [\App\Http\Controllers\RegistroVuelveaCasa::class, 'registroVuelveaCasaExtras'])->name('registrovuelveacasa_extras');
Route::match(['get', 'post'], '/registro-vuelve-a-casa/pedido-realizado', [\App\Http\Controllers\RegistroVuelveaCasa::class, 'registroVuelveaCasaPedidoRealizado'])->name('registrovuelveacasa_pedido_realizado');
Route::post('/registro-vuelve-a-casa/process-payment-deposito', [\App\Http\Controllers\RegistroVuelveaCasa::class, 'registroVuelveaCasaPaymentDeposito'])->name('registrovuelveacasa_paymentdeposito');
Route::post('/registro-vuelve-a-casa/process-payment-subscription', [\App\Http\Controllers\RegistroVuelveaCasa::class, 'registroVuelveaCasaPaymentSubscription'])->name('registrovuelveacasa_paymentsubscription');
Route::post('/registro-vuelve-a-casa/process-payment', [\App\Http\Controllers\RegistroVuelveaCasa::class, 'registroVuelveaCasaPayment'])->name('registrovuelveacasa_payment');

Route::middleware(['bloquear-pagos', 'prevent-back-history'])->group(function () {
    Route::get('/registro-vuelve-a-casa/cuotas', [\App\Http\Controllers\RegistroVuelveaCasa::class, 'registroVuelveaCasaCuotas'])->name('registrovuelveacasa_cuotas');
    Route::get('/registro-vuelve-a-casa/pago', [\App\Http\Controllers\RegistroVuelveaCasa::class, 'registroVuelveaCasaPago'])->name('registrovuelveacasa_pago');
});


//Registro Siempre a Juntas
Route::match(['get', 'post'], '/registro-siempre-juntos', [\App\Http\Controllers\RegistroSiempreJuntos::class, 'registroSiemprejuntos'])->name('registro_siempre_juntos');
Route::match(['get', 'post'], '/registro-siempre-juntos/cuotas', [\App\Http\Controllers\RegistroSiempreJuntos::class, 'registroSiemprejuntosCuotas'])->name('registrosiemprejuntos_cuotas');
Route::get('/registro-siempre-juntos/pago', [\App\Http\Controllers\RegistroSiempreJuntos::class, 'registroSiemprejuntosPago'])->name('registrosiemprejuntos_pago');
Route::post('/registro-siempre-juntos/process-payment-subscription', [\App\Http\Controllers\RegistroSiempreJuntos::class, 'registroSiemprejuntosPaymentSubscription'])->name('registrosiemprejuntos_processpaymentsubscription');
Route::post('/registro-siempre-juntos/process-payment', [\App\Http\Controllers\RegistroSiempreJuntos::class, 'registroSiemprejuntosPayment'])->name('registrosiemprejuntos_processpayment');

// Registro Exitoso
Route::get('/registro-exitoso', [WebController::class, 'registro_exitoso'])->name('registro_exitoso');
Route::match(['get', 'post'], '/encuestas', [WebController::class, 'encuestas'])->name('encuestas');

//Mercado Pago
Route::post('/webhook/mercadopago', [App\Http\Controllers\MercadoPagoWebhookController::class, 'handle']);
Route::post('/webhook/mercadopagoconsulta', [App\Http\Controllers\MercadoPagoWebhookConsultaController::class, 'handle'])->name('mp.webhook');


//Usuario
Route::match(['get', 'post'], '/pedidos-extras', [WebController::class, 'pedidos_productos'])->name('pedidos-extras');
Route::get('/iniciar-sesion', [WebController::class, 'iniciar_sesion'])->name('iniciar_sesion');
Route::get('/mis-servicios', [UsuariosController::class, 'mis_servicios'])->name('mis_servicios');
Route::match(['get', 'post'], '/mis-servicios/{id}', [UsuariosController::class, 'mis_servicios_id'])->name('mis_servicios_id');
Route::match(['get', 'post'], '/mis-servicios/{id}/pedidos-extras', [UsuariosController::class, 'pedidos_productos'])->name('mis_servicios_id_pedidos_productos');
Route::get('/seguimientos', [UsuariosController::class, 'seguimientos'])->name('seguimientos');
Route::get('/seguimientos/{id}', [UsuariosController::class, 'seguimientos_id'])->name('seguimientos_id');
Route::get('/editar-perfil', [UsuariosController::class, 'editar_perfil'])->name('editar_perfil');
Route::get('/inicio', [UsuariosController::class, 'inicio'])->name('inicio');
Route::post('/descargar-pdf', [UsuariosController::class, 'descargarPdf'])->name('descargar.pdf');
Route::get('/ver-pdf', [UsuariosController::class, 'verPdf'])->name('ver.pdf');
Route::get('/ver-cuna', [UsuariosController::class, 'verCuna'])->name('ver.cuna');
Route::get('/seleccionar-horario', [UsuariosController::class, 'seleccionar_horario'])->name('seleccionar_horario');
Route::post('/process_payment_extras', [UsuariosController::class, 'process_payment_extras'])->name('process_payment_extras');

//ServicioNuevo
Route::match(['get', 'post'], '/servicio-nuevo', [\App\Http\Controllers\ServicioNuevo::class, 'registroServicioNuevo'])->name('servicio_nuevo');
Route::match(['get', 'post'], '/servicio-nuevo/extras', [\App\Http\Controllers\ServicioNuevo::class, 'registroServicioNuevoExtras'])->name('registroservicionuevo_extras');
Route::get('/servicio-nuevo/cuotas', [\App\Http\Controllers\ServicioNuevo::class, 'registroServicioNuevoCuotas'])->name('registroservicionuevo_cuotas');
Route::get('/servicio-nuevo/pago', [\App\Http\Controllers\ServicioNuevo::class, 'registroServicioNuevoPago'])->name('registroservicionuevo_pago');
Route::match(['get', 'post'], '/servicio-nuevo/pedido-realizado', [\App\Http\Controllers\ServicioNuevo::class, 'registroServicioNuevoPedidoRealizado'])->name('registroservicionuevo_pedido_realizado');
Route::post('/servicio-nuevo/process-payment-deposito', [\App\Http\Controllers\ServicioNuevo::class, 'registroServicioNuevoPaymentDeposito'])->name('registroservicionuevo_paymentdeposito');
Route::post('/servicio-nuevo/process-payment-subscription', [\App\Http\Controllers\ServicioNuevo::class, 'registroServicioNuevoPaymentSubscription'])->name('registroservicionuevo_paymentsubscription');
Route::post('/servicio-nuevo/process-payment', [\App\Http\Controllers\ServicioNuevo::class, 'registroServicioNuevoPayment'])->name('registroservicionuevo_payment');


Route::match(['get', 'post'], '/registrar-encuesta', [WebController::class, 'registrar_encuesta'])->name('registrar_encuesta');


Route::match(['get', 'post'], '/pago-cuotas', [WebController::class, 'pago_cuota'])->name('pago-cuotas');

Route::get('/pago', [WebController::class, 'pago'])->name('pago');
Route::get('/recuperar-contrasena', [WebController::class, 'recuperar-contrasena'])->name('recuperar-contrasena');


Route::post('/loginaction', [WebController::class, 'loginaction'])->name('loginaction');


// Route::match(['get', 'post'], '/registro', [WebController::class, 'registro'])->name('registro-freemium');


//Route::post('/process_payment', [WebController::class, 'process_payment'])->name('process_payment');
//Route::post('/process_payment_deposito', [WebController::class, 'process_payment_deposito'])->name('process_payment_deposito');
//Route::post('/process_payment_subscription', [WebController::class, 'process_payment_subscription'])->name('process_payment_subscription');

Route::get('/cerrar-sesion', [WebController::class, 'cerrar_sesion'])->name('cerrar-sesion');

Route::match(['GET', 'POST'], '/cambiar-contrasena', [WebController::class, 'cambiar_contrasena'])->name('cambiar-contrasena');
// Route::match(['GET', 'POST'], '/cambiar-contrasenas', [WebController::class, 'cambiar_contrasenas'])->name('cambiar-contrasenas');


//Route::post('/webhook/mercadopago', [UsuariosController::class, 'handle']);


// AJAX
Route::get('/ajax/validar_email', [AjaxController::class, 'validar_email'])->name('ajax.validar_email');

Route::get('/ajax/registro_usuario', [AjaxController::class, 'registro_usuario'])->name('registro_usuario');
Route::get('/ajax/registro_mascota', [AjaxController::class, 'registro_mascota'])->name('registro_mascota');
Route::get('/ajax/registro_recojo', [AjaxController::class, 'registro_recojo'])->name('registro_recojo');
Route::get('/ajax/agregar_carrito', [AjaxController::class, 'agregar_carrito'])->name('agregar_carrito');
Route::get('/ajax/confirmacion_datos', [AjaxController::class, 'confirmacion_datos'])->name('confirmacion_datos');
Route::get('/ajax/pagar', [AjaxController::class, 'pagar'])->name('pagar');

Route::get('/ajax/registro_usuario_admin', [AjaxController::class, 'registro_usuario_admin'])->name('registro_usuario_admin');

// CONDUCTOR

Route::get('/conductor', function () {
    return redirect()->route('conductor_iniciar_sesion');
});
Route::get('/conductor/iniciar-sesion', [ConductorController::class, 'iniciar_sesion'])->name('conductor_iniciar_sesion');
Route::post('/conductor/loginaction', [ConductorController::class, 'loginaction'])->name('conductor_loginaction');
Route::get('/conductor/inicio', [ConductorController::class, 'inicio'])->name('conductor_inicio');
Route::get('/conductor/recojo-de-mascotas', [ConductorController::class, 'recojo_de_mascotas'])->name('recojo_de_mascotas');
Route::get('/conductor/entrega-de-mascotas', [ConductorController::class, 'entrega_de_mascotas'])->name('entrega_de_mascotas');
Route::get('/conductor/recojo-de-mascotas/{id}', [ConductorController::class, 'actividades_recojo_id'])->name('conductor_actividades_recojo_id');
Route::get('/conductor/entrega-de-mascotas/{id}', [ConductorController::class, 'actividades_entrega_id'])->name('conductor_actividades_entrega_id');
Route::post('/conductor/confirmar-ida', [ConductorController::class, 'confirmar_recojo_ida'])->name('conductor_confirmar_ida');
Route::post('/conductor/confirmar-regreso', [ConductorController::class, 'confirmar_recojo_regreso'])->name('conductor_confirmar_regreso');
Route::post('/conductor/confirmar-acompanamiento', [ConductorController::class, 'confirmar_acompanamiento'])->name('confirmar_acompanamiento');
Route::post('/conductor/registro-actividad-recojo-ida-paso1', [ConductorController::class, 'registro_actividad_recojo_ida_paso1'])->name('registro_actividad_recojo_ida_paso1');
Route::post('/conductor/registro-actividad-recojo-ida-paso2', [ConductorController::class, 'registro_actividad_recojo_ida_paso2'])->name('registro_actividad_recojo_ida_paso2');
Route::post('/conductor/registro-actividad-recojo-ida-paso3', [ConductorController::class, 'registro_actividad_recojo_ida_paso3'])->name('registro_actividad_recojo_ida_paso3');
Route::post('/conductor/registro-actividad-recojo-ida-paso4', [ConductorController::class, 'registro_actividad_recojo_ida_paso4'])->name('registro_actividad_recojo_ida_paso4');
Route::post('/conductor/registro-actividad-entrega-ida-paso1', [ConductorController::class, 'registro_actividad_entrega_paso1'])->name('registro_actividad_entrega_paso1');
Route::post('/conductor/registro-actividad-entrega-ida-paso2', [ConductorController::class, 'registro_actividad_entrega_paso2'])->name('registro_actividad_entrega_paso2');
Route::post('/conductor/registro-actividad-entrega-ida-paso3', [ConductorController::class, 'registro_actividad_entrega_paso3'])->name('registro_actividad_entrega_paso3');
Route::post('/conductor/registro-actividad-entrega-ida-paso4', [ConductorController::class, 'registro_actividad_entrega_paso4'])->name('registro_actividad_entrega_paso4');
Route::get('/cerrar-sesion-conductor', [ConductorController::class, 'cerrar_sesion_conductor'])->name('cerrar-sesion-conductor');


// OPERARIO
Route::get('/operario', function () {
    return redirect()->route('operario_iniciar_sesion');
});
Route::get('/operario/iniciar-sesion', [OperarioController::class, 'iniciar_sesion'])->name('operario_iniciar_sesion');
Route::post('/operario/loginaction', [OperarioController::class, 'loginaction'])->name('operario_loginaction');
Route::get('/operario/inicio', [OperarioController::class, 'inicio'])->name('operario_inicio');
Route::get('/operario/actividades', [OperarioController::class, 'actividades'])->name('operario_actividades');
Route::get('/operario/actividades/{id}', [OperarioController::class, 'actividades_id'])->name('operario_actividades_id');
Route::post('/operario/confirmar', [OperarioController::class, 'confirmar_operario'])->name('confirmar_operario');
Route::post('/operario/registro-actividad-operario-paso1', [OperarioController::class, 'registro_actividad_operario_paso1'])->name('registro_actividad_operario_paso1');
Route::post('/operario/registro-actividad-operario-paso2', [OperarioController::class, 'registro_actividad_operario_paso2'])->name('registro_actividad_operario_paso2');
Route::post('/operario/subir-foto', [OperarioController::class, 'subir_foto'])->name('subir_foto');
Route::post('/operario/registro-actividad-operario-paso3', [OperarioController::class, 'registro_actividad_operario_paso3'])->name('registro_actividad_operario_paso3');
Route::post('/operario/registro-monitoreo', [OperarioController::class, 'registro_monitoreo'])->name('registro_monitoreo');
Route::post('/operario/registro-actividad-operario-paso4', [OperarioController::class, 'registro_actividad_operario_paso4'])->name('registro_actividad_operario_paso4');
Route::post('/operario/registro-actividad-operario-paso5', [OperarioController::class, 'registro_actividad_operario_paso5'])->name('registro_actividad_operario_paso5');
Route::post('/operario/subir_fotografia', [OperarioController::class, 'subir_fotografia'])->name('subir_fotografia');


Route::get('/get-monitoreo-form', [OperarioController::class, 'getMonitoreoForm'])->name('get.monitoreo.form');

Route::get('/cerrar-sesion-operario', [OperarioController::class, 'cerrar_sesion_operario'])->name('cerrar-sesion-operario');


// ADMIN
Route::get('/admin', function () {
    return redirect()->route('admin_iniciar_sesion');
});
Route::get('/admin/iniciar-sesion', [AdminController::class, 'iniciar_sesion'])->name('admin_iniciar_sesion');
Route::post('/admin/loginaction', [AdminController::class, 'loginaction'])->name('admin_loginaction');
Route::get('/admin/inicio', [AdminController::class, 'inicio'])->name('admin_inicio');
Route::get('/admin/usuarios', [AdminController::class, 'usuarios'])->name('admin_usuarios');
Route::match(['get', 'post'], '/admin/productos', [AdminController::class, 'productos'])->name('productos');
// Route::get('/admin/base-de-datos/', [AdminController::class, 'usuarios'])->name('admin_usuarios');
Route::match(['get', 'post'], '/admin/base-de-datos/vuelve-a-casa', [AdminController::class, 'bd_vuelve_a_casa'])->name('admin_bd_vuelve_a_casa');
Route::get('/admin/base-de-datos/vuelve-ceniza', [AdminController::class, 'bd_vuelve_ceniza'])->name('admin_bd_vuelve_ceniza');
Route::get('/admin/base-de-datos/vuelve-solidario', [AdminController::class, 'bd_vuelve_solidario'])->name('admin_bd_vuelve_solidario');
Route::get('/admin/base-de-datos/plan-siempre-juntos', [AdminController::class, 'bd_plan_siempre_juntos'])->name('admin_bd_plan_siempre_juntos');
Route::get('/admin/pedido', [AdminController::class, 'pedido'])->name('admin_pedido');
Route::match(['get', 'post'], '/admin/pedido/{id}', [AdminController::class, 'pedido_id'])->name('admin_pedido_id');

Route::post('/admin/subir-boleta', [AdminController::class, 'subir_boleta'])->name('subir_boleta');
Route::post('/admin/registro-actividad', [AdminController::class, 'registro_actividadlogistica'])->name('registro_actividadlogistica');


Route::get('/administrador/usuario/{id}', [AdminController::class, 'admin_usuarios_id'])->name('admin_usuarios_id');
Route::get('/operario/usuario/{id}', [AdminController::class, 'operario_usuarios_id'])->name('operario_usuarios_id');
Route::get('/conductor/usuario/{id}', [AdminController::class, 'conductor_usuarios_id'])->name('conductor_usuarios_id');
Route::get('/cerrar-sesion-administrador', [AdminController::class, 'cerrar_sesion_administrador'])->name('cerrar-sesion-administrador');
Route::post('/enviar-constancia', [AdminController::class, 'enviar_constancia'])->name('enviar_constancia');



