@extends('front.layouts.user')
@section('content')
    <div class="container-fluid py-4">
        @if(isset($pedido->pedido_activo) && $pedido->pedido_activo == 0)
            <div class="modal modal-lg show" id="prom-1" tabindex="-1" aria-hidden="true" style="
        background: #0d0e0fb0;
        z-index: 99999;
    ">
                <div class="modal-dialog">
                    <div class="modal-content p-4">
                        <p><strong>Estamos validando tu pago</strong></p>
                        <p>Nuestro equipo está revisando la información del pago, una vez esté lista estaremos notificando y activando su cuenta.</p>
                    </div>
                </div>
            </div>
        @endif
        <a href="/seguimientos" class="text-dark d-flex align-items-center">
            <i class="fa-solid fa-arrow-left"></i>
            <div class="semibold ms-2 fs-6">Volver</div>
        </a>
        <h4 class="f-weight mt-3">Seguimiento de {{ $pedido->nombre_mascota }}</h4>
        <hr>
        <div class="card border border-radius-lg mt-2 mb-2 ">
            <div class="tabsNavtop my-4 seguimiento-{{ $pedido->seguimiento}}">
                <ul class="nav nav-tabs nav border-bottom-0 ul-nav justify-content-center" id="tab1Tabs" role="tablist">
                    @php

                        $etapas = [
                            1 => 'Hoy inicia el proceso de biotransformación de tu mascota.',
                            2 => "{$pedido->nombre_mascota}, siempre contigo",
                            3 => "{$pedido->nombre_mascota} lleva 15 días en su proceso de biotransformación.",
                            4 => "{$pedido->nombre_mascota} lleva 1 mes transformándose en más vida.",
                            5 => "{$pedido->nombre_mascota} Cada vez más cerca de casa.",
                            6 => "¡{$pedido->nombre_mascota} vuelve a casa!",
                            7 => "{$pedido->nombre_mascota}, contigo otra vez 💚",
                            8 => "Gracias por confiar en nosotros"
                        ];
                    @endphp
                    @foreach ($etapas as $numero => $texto)
                        @php
                            $etapaId = "tab{$numero}";
                            $tabTarget = "#tab-{$numero}";
                            $estaLiberado = $numero <= $pedido->seguimiento;
                            $etapaActiva = $numero === $pedido->seguimiento; // activa la más reciente liberada
                        @endphp

                        <li class="nav-item" role="presentation">
                            <div class="nav-link border-0 {{ $etapaActiva ? 'active' : '' }} {{ !$estaLiberado ? 'disabled text-muted' : '' }}"
                                 id="{{ $etapaId }}"
                                 @if($estaLiberado)
                                     data-bs-toggle="tab"
                                 data-bs-target="{{ $tabTarget }}"
                                 type="button"
                                 @endif
                                 role="tab"
                                 aria-controls="tab-{{ $numero }}"
                                 aria-selected="{{ $etapaActiva ? 'true' : 'false' }}">
                                <span class="d-block item-etapa text-center text-sm">Etapa</span>
                                <div class="numero-etapa text-center">{{ $numero }}</div>
                                <p class="text- text-sm text-center mb-0">{{ $texto }}</p>
                            </div>
                        </li>
                    @endforeach


                </ul>

            </div>
        </div>
        <div class="card border border-radius-lg">

            <div class="tab-content" id="tab1TabsContent">
                @foreach (range(1, 8) as $numero)
                    @php
                        $tabId = "tab-{$numero}";
                        $ariaLabelledby = "tab{$numero}";
                        $isActive = $numero === $pedido->seguimiento;
                    @endphp

                    <div class="tab-pane fade {{ $isActive ? 'show active' : '' }}"
                         id="{{ $tabId }}"
                         role="tabpanel"
                         aria-labelledby="{{ $ariaLabelledby }}">
                        @include("front.seguimiento.etapa-{$numero}")
                    </div>
                @endforeach
            </div>
        </div>


    </div>
@endsection
