@extends('front.layouts.user')
@section('content')

    <div class="container-fluid py-4">
        <h4 class="f-weight mb-3">Mis Servicios</h4>
        <hr>

        <!-- Subtitle -->
        <div class="d-flex justify-content-between mb-2">
            <div>
                <h5 class="font-weight-bold">Servicios recientes</h5>
            </div>
            <div class="d-none">
                <a href="#"><img src="../../assets/img/fila.svg" alt="" class="mx-2"></a>
                <a href="#"><img src="../../assets/img/cuadrado.svg" alt="" class=""></a>
            </div>
        </div>

        <!-- Cards -->
        <div class="row mb-2">
            <!-- card 1 -->
            @foreach($pedidosRecientes as $pedido)
                <div class="col-lg-6 mb-4">
                    <!-- card orejas -->
                    <div class="card z-index-2 h-100">
                        <div class="my-5 mx-4 row">
                            <div class="col-sm-6">
                                <!-- image -->
                                <div class="d-flex justify-content-center bg-success-serv rounded-3 ">
                                    <div class="d-flex justify-content-center">
                                        <!-- image photo -->
                                        <div class="pt-4 d-flex justify-content-center flex-column img-mascota">
                                            @if ($pedido->tipo_mascota == 'Gat@')
                                                <img src="{{ asset('assets/img/mascotas/gato.svg')}}" width="170" alt="gato">
                                            @elseif ($pedido->tipo_mascota == 'Perr@')
                                                <img src="{{ asset('assets/img/mascotas/perro.png')}}" width="170" alt="perro">
                                            @elseif ($pedido->tipo_mascota == 'Conej@')
                                                <img src="{{ asset('assets/img/mascotas/conejo.png')}}" width="170" alt="conejo">
                                            @elseif ($pedido->tipo_mascota == 'Pajarito')
                                                <img src="{{ asset('assets/img/mascotas/pajarito.png')}}" width="170" alt="pajarito">
                                            @else
                                                <img src="{{ asset('assets/img/mascotas/gato.svg')}}" width="170" alt="gato">
                                            @endif
                                            <div class="d-flex justify-content-center">
                                                <div class="my-3 t-verde semibold bg-white rounded-pill estado2 text-center">
                                                    <div class="p-2 px-4 fs-7">
                                                        @if($pedido->estado_pedido === 0)
                                                            <span>En Proceso</span>
                                                            <img src="../../assets/img/radio_asiento.svg">
                                                        @elseif($pedido->estado_pedido === 1)
                                                            <span>Recojo de Mascota</span>
                                                            <img src="../../assets/img/radio_asiento.svg">
                                                        @elseif($pedido->estado_pedido === 2)
                                                            <span>Compostaje</span>
                                                            <img src="../../assets/img/radio_asiento.svg">
                                                        @elseif($pedido->estado_pedido === 3)
                                                            <span>Logística</span>
                                                            <img src="../../assets/img/radio_asiento.svg">
                                                        @elseif($pedido->estado_pedido === 4)
                                                            <span>Entrega de Maceta</span>
                                                            <img src="../../assets/img/radio_asiento.svg">
                                                        @elseif($pedido->estado_pedido === 5)
                                                            <span class="text-white">Finalizado</span>
                                                            <img src="../../assets/img/icon_check-white.svg">
                                                        @endif
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!-- end image -->
                            </div>
                            <div class="col-sm-6">
                                <div class="bg-success-serv text-dark mb-3 t-verde semibold bg-white rounded-3 estado3 mt-4 mt-sm-0">
                                    <div class="px-3 py-1">
                                        <h7 class="fs-6 normal">Servicio:</h7>
                                        <h4 class="t-verde font-weight-bold">{{ $pedido->nombre_servicio}}</h4>
                                    </div>
                                </div>
                                <p class="normal">Nombre:</p>
                                <h1 class="caps">{{ $pedido->nombre_mascota }}</h1>
                                <p style="color: #6E6E6F;" class="semibold fs-8"><i class="fa-regular fa-calendar-days me-2"
                                                                                    style="color: #9E9F9F;"></i> {{ $pedido->fecha_creacion }}</p>
                                <a type="button" href="/mis-servicios/{{ $pedido->id_pedido }}"
                                   class="btn btn-success fs-6 semibold col-12 col-md-9 col-lg-10 col-xl-11">
                                    Ver servicio
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            @endforeach


        </div>

        @if ($pedidosCompletados->count() > 0)
            <!-- complete service title  -->
            <div class="d-flex justify-content-between mb-2">

                <h4 class="font-weight-bold">De vuelta en casa</h4>
            </div>

            <!-- complete service title  -->
            <div class="row mb-2">
                @foreach($pedidosCompletados as $pedido)
                    <div class="col-lg-6 mb-4">
                        <div class="card z-index-2 h-100">
                            <div class="my-5 mx-4 row">
                                <!-- img  -->
                                <div class="col-sm-6">
                                    <div class="d-flex justify-content-center bg-blue-s rounded-3 ">
                                        <div class="d-flex justify-content-center">
                                            <div class="pt-4 img-mascota">
                                                @if ($pedido->tipo_mascota == 'Gat@')
                                                    <img src="{{ asset('assets/img/mascotas/gato.svg')}}" width="170" alt="gato">
                                                @elseif ($pedido->tipo_mascota == 'Perr@')
                                                    <img src="{{ asset('assets/img/mascotas/perro.png')}}" width="170" alt="perro">
                                                @elseif ($pedido->tipo_mascota == 'Conej@')
                                                    <img src="{{ asset('assets/img/mascotas/conejo.png')}}" width="170" alt="conejo">
                                                @elseif ($pedido->tipo_mascota == 'Pajarito')
                                                    <img src="{{ asset('assets/img/mascotas/pajarito.png')}}" width="170" alt="pajarito">
                                                @else
                                                    <img src="{{ asset('assets/img/mascotas/gato.svg')}}" width="170" alt="gato">
                                                @endif
                                                <div class="d-flex justify-content-center">
                                                    <div class="my-3 text-white semibold bg-blue-o rounded-pill estado2 text-center">
                                                        <div class="p-2 fs-7 px-4 d-flex align-items-center justify-content-center">
                                                            <span>Finalizado</span>
                                                            <img src="../../assets/img/icon_check-white.svg" class="ms-1">
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- complete service title  -->
                                <div class="col-sm-6 d-flex justify-content-center justify-content-sm-start">
                                    <div
                                        class="bg-blue-s text-dark mb-3 t-blue-o semibold bg-white rounded-3 estado3 mt-4 mt-sm-0">
                                        <div class="px-3 py-1">
                                            <h7 class="fs-6 normal">Servicio:</h7>
                                            <h4 class="t-blue-o font-weight-bold">{{ $pedido->nombre_servicio}}</h4>
                                        </div>
                                    </div>
                                    <p class="normal">Nombre:</p>
                                    <h1 class="caps">{{ $pedido->nombre_mascota }}</h1>
                                    <p style="color: #6E6E6F;" class="semibold fs-8"><i class="fa-regular fa-calendar-days me-2"
                                                                                        style="color: #9E9F9F;"></i> {{ $pedido->fecha_creacion }}</p>
                                    <a type="button" href="/mis-servicios/{{ $pedido->id_pedido }}"
                                       class="btn btn-success fs-6 semibold col-12 col-md-9 col-lg-10 col-xl-11">
                                        Ver servicio
                                    </a>
                                </div>

                            </div>
                        </div>
                    </div>
                @endforeach

            </div>
        @endif

    </div>

@endsection
