@extends('front.layouts.web')
@section('content')

    <section>
        <div class="container position-relative">
            <div class="row d-flex justify-content-center py-4">
                <div class="col-xl-6">
                    <div class="card p-4 p-lg-6 shadow-signin">
                        @if (session('error'))
                            <div class="alert alert-danger white-color" role="alert">{{ session('error') }}</div>
                        @endif
                        <h3 class="f-weight mb-4">Iniciar Sesión</h3>
                        <!-- <form action=""> -->
                        <form id="signin-form" method="POST" action="{{ route('loginaction') }}">
                            @csrf
                            <div class="mb-3">
                                <label for="email" class="text-dark form-label mb-1">Email</label>
                                <input type="text" class="form-control" id="email" name="email"
                                       placeholder="Escriba su email" value="{{ old('email') }}">
                            </div>

                            <div class="mb-3">
                                <label for="contrasena" class="text-dark form-label mb-1">Contraseña</label>
                                <input type="password" class="form-control" id="password" name="password"
                                       placeholder="Escriba su contraseña">
                            </div>

                            {{--                        <div class="d-flex justify-content-between">--}}
                            {{--                            <div class="form-check mb-4">--}}
                            {{--                                <input type="checkbox" class="form-check-input" id="exampleCheck1">--}}
                            {{--                                <label class="form-check-label text-dark" for="exampleCheck1">Recordar--}}
                            {{--                                    Contraseña</label>--}}
                            {{--                            </div>--}}

                            {{--                            <a href="#" class="color-primary f-weight">¿Olvidaste la contraseña?</p>--}}
                            {{--                        </div>--}}
                            @if (isset($_GET['redirect']))
                                <input type="hidden" name="redirect" value="{{ $_GET['redirect'] }}">
                            @endif
                            <button role="button" type="submit" class="mt-3 btn btn-success
                            labeltext  col-xl-12">Iniciar Sesión
                            </button>
                        </form>
                    </div>
                </div>
            </div>
        </div>

        <!-- images absolute -->
        <div class="images-absolute">
            <img src="../assets/img/dog_signin.svg" alt="">
            <img src="../assets/img/vector-line-d.svg" alt="">
            <img src="../assets/img/circle-s-d.svg" alt="">
            <img src="../assets/img/cat_signin.svg" alt="">
            <img src="../assets/img/vector-line-c.svg" alt="">
            <img src="../assets/img/vector_s-cat.svg" alt="">
        </div>
    </section>

@endsection
