@extends('front.layouts.web')
@section('content')
    <section>
        <div class="modal modal-sm fade" id="prom-1" tabindex="-1" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content p-4">
                    <form id="enviar-constancia-huella" class="mt-4" method="POST" enctype="multipart/form-data" action="{{ route('registroservicionuevo_pedido_realizado') }}">
                        @csrf
                        <input type="hidden" id="id_pedido" name="id_pedido" value="{{ $pedido->id_pedido }}">
                        <input type="hidden" id="id_usuario" name="id_usuario" value="{{ $pedido->id_usuario }}">
                        <input type="hidden" id="id_pago" name="id_pago" value="{{ $pago->id }}">
                        <p class="text-center"><strong>ENVIAR COMPROBANTE</strong></p>
                        <p class="text-sm m-0">Pedido <span class="text-sm font-weight-bold">Nº
                                {{ $pedido->id_pedido }}</span></p>
                        <p class="text-sm ">Monto total a pagar: <span class="text-sm font-weight-bold">S/
                                {{ $pago->total_pagar }}</span></p>
                        <div style="height: 130px"
                             class="d-flex flex-column justify-content-center rounded-3 border align-items-center p-2 mb-3 cursor-pointer text-center position-relative">
                            <label for="foto_entrega"
                                   class="w-full h-full cursor-pointer top-0 start-0 position-absolute m-0">
                                <input id="foto_entrega" multiple accept="image/*" name="foto_entrega[]" type="file"
                                       class="visually-hidden">
                            </label>
                            <i style="font-size: 110px" class="ri-screenshot-2-line"></i>
                        </div>
                        <p class="text-xs f-weight-50 color-grey">Imagen JPG, PNG y con un peso máximo 1MB</p>
                        <p class=" text-xs text-center">Tambien puedes enviar tu constancia al correo <a
                                href="mailito:logistica@vuelvecompostario.com"
                                class="font-weight-bold">logistica@vuelvecompostario.com</a> para que nuestro equipo
                            pueda
                            validar el pago.</p>
                        <p class="text-center">
                            <button type="submit" class="btn btn-success btn-sm fs-6 mx-auto mb-3"
                                    data-bs-toggle="modal" data-bs-target="#prom-1">Enviar
                            </button>
                        </p>
                    </form>
                </div>
            </div>
        </div>
        <div class="page-header py-3">
            <div class="container">

                <div class="row">
                    <div class="col-xl-6 col-lg-7 col-md-12">
                        <div class="my-4 card-header p-0 text-start">
                            <h1 class="font-weight-bold  t-verde fs-4 mb-2">GRACIAS POR TU COMPRA</h1>

                        </div>
                        <div class="card card-plain metodos-pagos ">
                            <div class="card-dheader pb-0  ps-0 text-start">
                                <div class="row">
                                    <div class="col-12">
                                        <div
                                            class="select-pasarela d-flex rounded-3 border align-items-center p-4 mb-3 cursor-pointer"
                                            data-id="cardPayment_yape">
                                            <div class="me-3">
                                                <h5 class="font-weight-bold">Realiza tu pago directamente mediante Yape,
                                                    Plin u otra billetera digital.</h5>
                                                <div class="">
                                                    <p class="my-3 text-center"><img src="../../../assets/img/yape.png" alt="" class="me-3"><img src="../../../assets/img/plin.png" alt=""></p>
                                                    <p class="font-weight-bold text-md text-center mb-0">Yape o Plin:</p>
                                                    <p class="font-weight-bold text-center fs-4">967 335 876</p>
                                                    <h2 class="font-weight-bold  text-center text-dark fs-4">Monto a pagar: S/ {{ $pago->total_pagar }}</h2>
                                                    <p class="mt-2 text-sm text-center font-weight-bold">Pedido Nº {{ $pedido->id_pedido }}</p>
                                                    <p class="text-center"><img src="https://upload.wikimedia.org/wikipedia/commons/d/d7/Commons_QR_code.png" alt=""></p>
                                                    <p class="mb-0 text-sm text-center">A nombre de:</p>
                                                    <p class="mb-0 font-weight-bold text-sm text-center">Vuelve Compostario Ambiental SAC</p>
                                                    <p class="font-weight-bold text-md text-center">RUC: 20612298727</p>
                                                    <div
                                                        class="d-flex justify-content-center flex-column align-items-center">
                                                        <p class="m-0 text-xs mb-2 text-center">!Si ya realizaste el pago!</p>
                                                        <button type="button" class="btn btn-success btn-lg fs-6 m-auto mb-3" data-bs-toggle="modal" data-bs-target="#prom-1">Envía tu constancia aquí
                                                        </button>
                                                        <p class=" text-xs text-center">Tambien puedes enviar tu
                                                            constancia
                                                            al correo <a href="mailito:logistica@vuelvecompostario.com"
                                                                         class="font-weight-bold">logistica@vuelvecompostario.com</a>
                                                            para que nuestro equipo pueda validar el pago.</p>
                                                        <p class=" text-xs text-center font-weight-bold">De no realizar
                                                            el
                                                            pago dentro de las 2 horas procederemos a cancelar tu
                                                            pedido.
                                                        </p>
                                                    </div>
                                                </div>

                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <hr>
                        <div class="">
                            <div class="d-flex justify-content-between align-items-center">
                                <div
                                    class="text-center rounded-circle orden border border-success border-2 text-xs normal">
                                    <i class="t-verde fa-solid fa-check"></i></div>
                                <hr class="flex-grow-1 hr-v">
                                <div
                                    class="text-center rounded-circle orden border border-success border-2 text-xs normal">
                                    <i class="t-verde fa-solid fa-check"></i></div>
                                <hr class="flex-grow-1 hr-v">
                                <div
                                    class="text-center rounded-circle orden border border-success border-2 text-xs normal">
                                    <i class="t-verde fa-solid fa-check"></i></div>
                                <hr class="flex-grow-1 hr-v">
                                <div
                                    class="text-center rounded-circle orden border border-success border-2 text-xs normal">
                                    <i class="t-verde fa-solid fa-check"></i></div>
                                <hr class="flex-grow-1 hr-v">
                                <div
                                    class="text-center rounded-circle orden border border-success border-2 text-xs normal">
                                    <i class="t-verde fa-solid fa-check"></i></div>
                                <hr class="flex-grow-1 hr-v">
                                <div
                                    class="text-center rounded-circle orden border border-success border-2 bg-success text-white text-xs normal">
                                    6
                                </div>
                            </div>
                            <div class="d-flex justify-content-between align-items-center">
                                <h6 class="f-weight text-xs">Datos</h6>
                                <hr class="flex-grow-1 hr-t">
                                <h6 class="f-weight text-xs">Mascota</h6>
                                <hr class="flex-grow-1 hr-t">
                                <h6 class="f-weight text-xs">Recojo</h6>
                                <hr class="flex-grow-1 hr-t">
                                <h6 class="f-weight text-xs">Extras</h6>
                                <hr class="flex-grow-1 hr-t">
                                <h6 class="f-weight text-xs">Cuotas</h6>
                                <hr class="flex-grow-1 hr-t">
                                <h6 class="f-weight text-xs">Pago</h6>
                            </div>
                        </div>

                    </div>
                    <div class="col-1"></div>
                    <div class="col-xl-5 col-lg-7 col-md-12 h-100 ">
                        <div class="img-fluid position-relative border-radius  overflow-hidden">
                            <img class="w-100" src="{{ asset('assets/img/form_banner.svg') }}" alt="">
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection
