@extends('front.layouts.web')
@section('content')
    <section>
        <div class="page-header py-3">
            <div class="container">
                @if (isset($_GET))
                    @foreach ($_GET as $key => $value)
                        @if ($key != '_token' && is_array($value))
                            @foreach ($value as $key2 => $value2)
                                <input type="hidden" name="{{ $key }}[{{ $key2 }}]" value="{{ $value2 }}">
                            @endforeach
                        @elseif ($key != '_token')
                            <input type="hidden" name="{{ $key }}" value="{{ $value }}">
                        @endif
                    @endforeach
                @endif
                @csrf
                <div class="row">
                    <div class="col-xl-6 col-lg-7 col-md-12">
                        <div class="my-4 card-header p-0 text-start">
                            <h1 class="semibold t-verde fs-4">Creando más vida con Vuelve</h1>
                        </div>
                        <div class="card card-plain metodos-pagos ">
                            <div class="card-header p-0 text-start" style="min-height: 400px">
                                <h2 class="f-weight text-dark fs-4">Detalle de pago</h2>
                                <p class="mt-4 text-sm">Selecciona como quieres hacer tu pago</p>
                                <div class="row mt-4">
                                    <div class="col-3 col-sm-5 col-md-4 col-lg-3 col-xl-2">
                                        <div
                                            class="rounded-3 border mt-3 h-75 d-flex align-items-center justify-content-center disabled">
                                            <div class="m-3">
                                                <img src="../../../assets/img/yape.png" alt="">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-3 col-sm-5 col-md-4 col-lg-3 col-xl-2">
                                        <div
                                            class="rounded-3 border mt-3 h-75 d-flex align-items-center justify-content-center disabled">
                                            <div class="m-3">
                                                <img src="../../../assets/img/plin.png" alt="">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-3 col-sm-5 col-md-4 col-lg-3 col-xl-2">
                                        <label
                                            class="rounded-3 border mt-3 h-75 d-flex align-items-center justify-content-center">
                                            <div class="m-2 my-3">
                                                <img src="../../../assets/img/master.png" alt="">
                                                <input type="radio" name="payment" required class="hide"
                                                       value="mercadopago">
                                            </div>
                                        </label>
                                    </div>
                                    <div class="col-3 col-sm-5 col-md-4 col-lg-3 col-xl-2">
                                        <label
                                            class="rounded-3 border mt-3 h-75 d-flex align-items-center justify-content-center disabled">
                                            <div class="m-2 my-3">
                                                <img src="../../../assets/img/efectivo.png" alt="">
                                                <input type="radio" name="payment" required class="hide"
                                                       value="mercadopago">
                                            </div>
                                        </label>
                                    </div>
                                    <div class="col-3 col-sm-5 col-md-4 col-lg-3 col-xl-2">
                                        <label
                                            class="rounded-3 border mt-3 h-75 d-flex align-items-center justify-content-center">
                                            <div class="m-1 my-3">
                                                <img src="../../../assets/img/visa.png" alt="">
                                                <input type="radio" name="payment" required class="hide"
                                                       value="mercadopago">
                                            </div>
                                        </label>
                                    </div>
                                    <div class="col-3 col-sm-5 col-md-4 col-lg-3 col-xl-2">
                                        <div
                                            class="rounded-3 border mt-3 h-75 d-flex align-items-center justify-content-center disabled">
                                            <div class="m-1 my-3">
                                                <img src="../../../assets/img/paypal.png" alt="">
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div id="mercadopago">
                                    <h5 class="my-4 font-weight-bold">Pago con tarjeta</h5>
                                    <div id="wallet_container"></div>

                                    <div id="cardPaymentBrick_container"></div>

                                </div>
                            </div>

                            <div class="text-md-end mt-4">
                                {{-- mis-servicios/5 --}}


                                <a href="{{'/mis-servicios/'. $pageId }}" class="mx-1 btn btn-outline-dark btn-lg fs-6 semibold">Volver</a>
                            </div>
                        </div>

                    </div>
                    <div class="col-1"></div>
                    <div class="col-xl-5 col-lg-7 col-md-12 h-100">
                        <div id="imgloquiero" class=" pe-0 text-center justify-content-center flex-column">
                            <div
                                class="position-relative bg-success h-100 p-5 border-radius-lg d-flex flex-column justify-content-center overflow-hidden">
                                <div class="rounded-top bg-white-transparent">
                                    <div class="m-4">
                                        <div class="row justify-content-between">
                                            <div class="col-12">
                                                <h4 class="semibold text-start text-white">Resumen</h4>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="my-2">
                                    <img src="../../assets/img//mi-servicio.png" alt="">
                                </div>
                                <div class="mb-3 mx-4">
                                    <h4 class="semibold text-start text-white">Servicio <br>Vuelve a Casa</h4>
                                </div>


                                <div class="bg-white-transparent-2">
                                    <div class="p-4">
                                        <div class="row justify-content-between">
                                            <div class="col-6">
                                                <h6 class="normal text-start text-white">Extra</h6>
                                            </div>
                                            <div class="col-4">
                                                <h6 class="normal text-start text-white text-end">
                                                    S/.{{ $precioExtras }}</h6>
                                            </div>
                                        </div>

                                    </div>
                                </div>
                                <div class="rounded-bottom bg-white-transparent">
                                    <div class="p-4">
                                        <div class="row justify-content-between">
                                            <div class="col-6">
                                                <h4 class="semibold text-start text-white" id="texto-total">Total</h4>
                                            </div>
                                            <div class="col-4">
                                                <h4 class="semibold text-start text-white text-end ">
                                                    S/.{{ $precioTotal }}</h4>
                                            </div>
                                        </div>
                                    </div>
                                </div>


                                <div class="rounded border border-light-subtle mt-7">
                                    <p class="normal m-3 fs-6 text-white">Muchas gracias por confiar en nosotros y ser parte
                                        de esta familia sostenible. 🌍♻</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection
@section('scripts')
    <script src="https://sdk.mercadopago.com/js/v2"></script>
    <script>
        $(function () {
            $('input[type="radio"]').click(function () {
                $(".metodos-pagos label").removeClass('active');
                $(this).parent().parent().addClass('active');
                let id = $(this).val();
                $("#" + id).removeClass('hide');
            });


            const data = JSON.parse('<?php echo str_replace('&quot;', '"', $data); ?>');

            const precioTotal = {{$precioTotal}};

            console.log('data', data);


            // const precioTotal = {
            //     {
            //         $precioTotal
            //     }
            // };


            const mp = new MercadoPago('{{ config('services.mercadopago.public_key') }}', {
                locale: 'es-PE'
            });
            const bricksBuilder = mp.bricks();

            // mp.bricks().create("wallet", "wallet_container", {
            //   initialization: {
            //       preferenceId: "{{ $preference_id }}",
            //   },
            // customization: {
            // texts: {
            //   valueProp: 'smart_option',
            // },
            // },
            // });

            const renderCardPaymentBrick = async (bricksBuilder) => {
                const settings = {
                    initialization: {
                        amount: precioTotal, // monto total a pagar
                    },
                    callbacks: {
                        onReady: () => {
                            /*
                              Callback llamado cuando Brick está listo.
                              Aquí puedes ocultar cargamentos de su sitio, por ejemplo.
                            */
                        },
                        onSubmit: (cardFormData) => {
                            cardFormData.data = data;
                            cardFormData.monto = precioTotal;
                            console.log('cardFormData', cardFormData);
                            $.ajax({
                                method: "POST",
                                headers: {
                                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                                },
                                url: "{{ route('process_payment_extras') }}",
                                data: cardFormData,
                                success: function (result) {
                                    console.log('result', result);
                                    if (isValidJSON(result)) {
                                        let data = JSON.parse(result);
                                        console.log(data);
                                        if (data.status == 'approved' && data
                                            .status_detail == 'accredited') {
                                            alert('Se realizó el pago correctamente');
                                            // $('.pagar2').addClass('hide');
                                            // $('.pagar3').removeClass('hide');
                                            window.location.href =
                                                "{{'/mis-servicios/'. $pageId }}";
                                        } else if (['error', 'rejected'].includes(data
                                            .status)) {
                                            alert(data.message);
                                            // location.reload();
                                        } else {
                                            alert('Hubo un error. Vuelve a intentarlo.');
                                        }
                                    } else {
                                        alert(result);
                                        // location.reload();
                                    }
                                },
                                error: function (e) {
                                    console.log('error', e);
                                }
                            });
                        },
                        onError: (error) => {
                            // callback llamado para todos los casos de error de Brick
                            console.error(error);
                        },
                    },
                };
                window.cardPaymentBrickController = await bricksBuilder.create(
                    'cardPayment',
                    'cardPaymentBrick_container',
                    settings,
                );
            };
            renderCardPaymentBrick(bricksBuilder);

        });
    </script>
@endsection
