<div class="seguimiento-etapa-1">
    <div class="p-sm-5 p-3">
        <h4 class="f-weight m-0">Tu mascota inició su proceso de biotransformación</h4>
    </div>
    <hr class="m-0">
    <div class="p-sm-5 p-3">
        <div class="card border border-radius-lg p-3 p-sm-5 mb-3 mb-sm-5">
            <div class="row">
                <div class="col-12">
                    <h5 class="mb-2 f-weight">Confirmación de movilidad.</h5>

                    @php
                        use Carbon\Carbon;
                        $fecha = Carbon::parse($recojo_ida->fecha_recojo);
                    @endphp

                    @if ($fecha->isFriday())
                        <p>Queremos informarte que estaremos llegando a recoger a tu mascota entre las 9:00 a.m. y las 3:00 p.m. a la dirección que nos proporcionaste.</p>
                    @else
                        <p>Queremos informarte que estaremos llegando a recoger a tu mascota entre las 9:00 a.m. y las 12:00 p.m. a la dirección que nos proporcionaste.</p>
                    @endif


                </div>
            </div>
        </div>
        <div class="card border border-radius-lg p-3 p-sm-5 mb-3 mb-sm-5">
            <div class="row">
                <div class="col-12 col-sm-8">
                    <h5 class="mb-2 f-weight">Instrucciones de recojo.</h5>
                    <p>Te explicamos cómo será el proceso de recojo: nuestro conductor, llevará consigo un cajón acolchado en el cual tu mascota será colocada con mucho cuidado 💚. No te preocupes por proporcionar una manta, contamos con una
                        especialmente diseñada para envolverla.</p>
                    <p>Además, sabemos que este es un momento significativo en la despedida de tu mascota así que queremos que sepas que puedes ser parte del proceso ya sea colocándola en su cajón o ayudando al conductor a cargar el cajón
                        hasta nuestro vehículo 🐶🐱💚.</p>
                </div>
                <div class="col-12 col-sm-4">
                    <div class="d-flex">
                        <div class="position-relative border p-4 border-radius-lg">
                            {{-- <i class="fa-solid fa-magnifying-glass-plus"></i> --}}
                            <p class="text-center mb-0">
                                <img src="{{ asset('assets/img/conductor.jpeg') }}" alt="" width="150" class="d-block mx-auto">
                            </p>
                            <button type="button" class="btn btn-success btn-md mb-0 w-100 mt-2" data-bs-toggle="modal" data-bs-target="#conductor-imagen">
                                Ver
                            </button>
                            <div class="modal modal-lg fade" id="conductor-imagen" tabindex="-1" aria-hidden="true">
                                <div class="modal-dialog">
                                    <div class="modal-content p-4">
                                        {{-- <img src="{{$pedido->foto_cunatapar}}" alt="" width="350" class="d-block mx-auto"> --}}
                                        <img src="{{ asset('assets/img/conductor.jpeg') }}" alt="Foto Huella" width="450" class="d-block mx-auto">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="card border border-radius-lg p-3 p-sm-5 mb-3 mb-sm-5">
            <div class="row">
                <div class="col-12">
                    <h5 class="mb-2 f-weight">Nota de despedida</h5>
                    <p>Además, sabemos que cada uno tiene su propia forma de despedirse, por eso queremos darte la posibilidad de hacerlo de la manera que más te acomode.</p>
                    <p>Si gustas, una linda opción es escribirle una nota en una hoja de papel que nosotros podemos colocar junto a tu mascota en su cuna. De esta manera, tus palabras acompañarán a tu mascota en este proceso🌱💚.</p>
                </div>
            </div>
        </div>
        @if ($recojo_ida->estado_etapa > 1)
            {{-- 3 --}}
            <div class="card border border-radius-lg p-3 p-sm-5 mb-3 mb-sm-5">
                <div class="row">
                    <div class="col-12">
                        <h5 class="mb-2 f-weight">Se hizo el recojo de tu mascota</h5>
                        <p>Queremos informarte que {{ $pedido->nombre_mascota }} se encuentra en camino a nuestro compostario 💚. Tan pronto como llegue a su destino, te avisaremos.</p>
                    </div>
                </div>
            </div>
            <div class="card border border-radius-lg p-3 p-sm-5 mb-3 mb-sm-5">
                <div class="row">
                    <div class="col-12 col-sm-8">
                        <h5 class="mb-2 f-weight"> Tips para afrontar la pérdida de tu peludito.</h5>
                        <p>Nos gustaría brindarte algunos consejos para ayudarte en este momento. Recuerda que aunque tu mascota se haya ido, pronto la tendrás de vuelta en casa en una nueva forma de vida 🌱💚.</p>
                    </div>
                    <div class="col-12 col-sm-4">
                        <div class="d-flex">
                            <div class="position-relative border p-4 border-radius-lg">
                                {{-- <i class="fa-solid fa-magnifying-glass-plus"></i> --}}
                                <p class="text-center mb-0">
                                    <img src="{{ asset('assets/img/tips_para_duelo.png') }}" alt="" width="150" class="d-block mx-auto">
                                </p>
                                <a href="{{ asset('assets/img/tips_para_duelo.png') }}" download class="btn btn-success btn-sm w-100 mt-2">Descargar</a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        @endif
        @if ($recojo_ida->estado_etapa > 1)
            {{-- 4 --}}
            <div class="card border border-radius-lg p-3 p-sm-5 mb-3 mb-sm-5">
                <div class="row">
                    <div class="col-12">
                        <h5 class="mb-2 f-weight">Tu mascota acaba de llegar a nuestro compostario</h5>
                        <p>{{ $pedido->nombres }}, {{ $pedido->nombre_mascota }} acaba de llegar a nuestro compostario y pronto comenzará su proceso de transformación. Una vez que finalice este proceso inicial, te enviaremos fotos de su
                            cuna compostera 💚.</p>

                    </div>
                </div>
            </div>
            <div class="card border border-radius-lg p-3 p-sm-5 mb-3 mb-sm-5">
                <div class="row">
                    <div class="col-12 col-sm-8">
                        <h5 class="mb-2 f-weight">Constancia del proceso de tu mascota</h5>
                        <p>Te enviamos la constancia del proceso por el cual pasará tu mascota. Nos avisas si tienes alguna duda 🌱.</p>
                    </div>
                    <div class="col-12 col-sm-4">
                        <div class="d-flex">
                            <div class="position-relative border p-4 border-radius-lg">
                                {{-- <i class="fa-solid fa-magnifying-glass-plus"></i> --}}
                                <p class="text-center mb-0">
                                    <img src="{{ asset('assets/img/constancia_vuelve.jpg') }}" alt="" width="150" class="d-block mx-auto">
                                </p>
                                @php
                                    $pesoMascota = number_format($pedido->peso_mascota*400/80.7,2);
                                @endphp
                                <a href="{{ url('/ver-pdf?nombre=' . urlencode($pedido->nombre_mascota) . '&peso=' . $pesoMascota) }}" class="btn btn-success btn-sm w-100 mt-2" target="_blank">Descargar</a>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        @endif
        @if (isset($compostaje->estado_etapa) && $compostaje->estado_etapa > 1)
            {{-- 5 --}}
            <div class="card border border-radius-lg p-6 ">
                <div class="row">
                    <div class="col-12 col-sm-8">
                        <h5 class="mb-2 f-weight">La cuna de tu mascota está lista.</h5>
                        <p>Hemos terminado con el proceso de {{ $pedido->nombre_mascota }} y ya está en su cuna donde descansará para comenzar con su proceso de transformarse en más vida 💚🌱. Aquí es donde descansará tu mascota durante su
                            proceso de transformación el cual dura entre 1.5 a 2
                            meses.</p>
                        <p>Este tiempo puede variar ligeramente, ya que cada proceso es único y respetuoso con la esencia de cada mascota. La entrega de la maceta puede tomar un poco más, pero estaremos contigo en cada paso, acompañándote
                            con sensibilidad en este momento especial 🌱.</p>
                        <p>Además, hemos tomado una foto para que puedas constatar que acomodamos cuidadosamente a tu mascota en su cuna. Sabemos que para algunos la imagen puede ser impactante, por eso te damos la opción de ver la foto
                            solo si así lo deseas, para ver la foto puedes dar click en la
                            imagen y esta se revelará 🙏💚.</p>

                        <p>{{ $pedido->nombres }} queremos agradecerte de todo corazón por la confianza puesta en nosotros 💚🌱</p>
                        <p>No dudes en contactarnos si tienes preguntas. Estamos aquí para ayudarte en todo momento 🙏.</p>

                    </div>
                    <div class="col-12 col-sm-4">
                        <div class="row">
                            <div class="col-6">
                                <div class="position-relative border p-4 border-radius-lg">
                                    {{-- <i class="fa-solid fa-magnifying-glass-plus"></i> --}}
                                    <p class="text-center mb-0">
                                        <img src="{{ asset('assets/img/constancia.png') }}" alt="" width="150" class="d-block mx-auto">
                                    </p>
                                    @php
                                        $imagenMascota = $pedido->foto_cunalista;
                                    @endphp
                                    <a href="{{ url('/ver-cuna?nombre=' . urlencode($pedido->nombre_mascota) . '&foto=' . $imagenMascota) }}" class="btn btn-success btn-sm w-100 mt-2" target="_blank">Descargar</a>
                                </div>
                            </div>
                            <div class="col-6">
                                <div class="position-relative border p-4 border-radius-lg">
                                    {{-- <i class="fa-solid fa-magnifying-glass-plus"></i> --}}
                                    <p class="text-center mb-0">
                                        <img src="{{ asset('assets/img/contancia-off.png') }}" alt="" width="150" class="d-block mx-auto">
                                    </p>
                                    <button type="button" class="btn btn-success btn-md mb-0 w-100 mt-2" data-bs-toggle="modal" data-bs-target="#mascota-imagen">
                                        Ver
                                    </button>
                                    <div class="modal modal-lg fade" id="mascota-imagen" tabindex="-1" aria-hidden="true">
                                        <div class="modal-dialog">
                                            <div class="modal-content p-4">
                                                {{-- <img src="{{$pedido->foto_cunatapar}}" alt="" width="350" class="d-block mx-auto"> --}}
                                                <img src="{{ asset('storage/' . $pedido->foto_cunatapar) }}" alt="Foto Huella" width="350" class="d-block mx-auto">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>

                    </div>
                </div>
            </div>
        @endif
    </div>
</div>
