@extends('front.layouts.web')
@section('content')
    <section class="container mt-5 mb-6">
        @if (session('exito'))
            <div class="container">
                <div class="alert alert-success text-white" role="alert">
                    {{ session('exito') }}
                </div>
            </div>
        @elseif (session('error'))
            <div class="container">
                <div class="alert alert-danger text-white white-color" role="alert">
                    {{ session('error') }}
                </div>
            </div>
        @endif
        @if (empty($_GET['token']))
            <div class="text-center">
                <h4 class="fw700 m-2 mt-3">Olvidaste tu contraseña</h4>
            </div>
            <div class="mt-5">
                <div>
                    <div class="text-center">
                        <h6 class="fw600">¡Queremos mantener tu cuenta segura! </h6>
                    </div>
                    <div class="d-flex justify-content-center text-center">
                        <h6 class="fw400 col-md-4">Enviaremos un enlace a tu correo electrónico donde podrás cambiar tu
                            contraseña.</h6>
                    </div>
                </div>
            </div>
            <form method="POST">
                @csrf
                <div class="d-flex justify-content-center mt-4">
                    <div class="col-lg-4 col-md-6 col-sm-8 col-12">
                        <input type="email" name="email" placeholder="Correo electrónico"
                               class="border-mora form-control sombra rounded-4"/>
                    </div>
                </div>
                <div class="mt-3 d-flex justify-content-center">
                    <button type="submit" class="btn btn-outline-primary4 me-3 m-2 sombra">
                        <h6 class="m-2 fw400">Enviar enlace</h6>
                    </button>
                </div>
            </form>
            <div class="mt-5 d-flex justify-content-center"><a class="btn btn-outline-primary4 me-3 m-2 sombra"
                                                               href="">
                    <h6 class="m-2 fw400">Volver a inicio</h6>
                </a>
            </div>
        @else
            <div class="text-center">
                <h4 class="fw700 m-2 mt-3">Crea tu nueva contraseña</h4>
            </div>
            <form method="POST">
                @csrf
                <div class="d-flex justify-content-center p-3">
                    <div class="mt-5 col-lg-4 col-md-5 col-12">
                        <div class="mb-4">
                            <label for="fieldPassword1" class="form-label fw400 h6">Nueva contraseña</label>
                            @if (session('exito'))
                                <input type="password" disabled class="form-control rounded-4 sombra" id="fieldPassword1" minlength="8"
                                       name="password1" placeholder="Escribe aquí">
                            @else
                                <input type="password" class="form-control rounded-4 sombra" id="fieldPassword1" minlength="8"
                                       name="password1" placeholder="Escribe aquí">
                            @endif
                            <div>
                                <h6 class="letra3 m-3">Por tu seguridad, considera un mínimo de 8 caracteres.</h6>
                            </div>
                        </div>
                        <div class="mb-3">
                            <label for="fieldPassword2" class="form-label fw400 h6">Confirma tu nueva contraseña</label>
                            @if (session('exito'))
                                <input disabled type="password" class="form-control rounded-4 sombra" id="fieldPassword2" name="password2"
                                       placeholder="Escribe aquí">
                            @else
                                <input type="password" class="form-control rounded-4 sombra" id="fieldPassword2" name="password2"
                                       placeholder="Escribe aquí">
                            @endif
                        </div>
                    </div>
                </div>
                <div class="d-flex justify-content-center">
                    {{-- <button type="submit" class="my-4 btn btn-secondary d-flex justify-content-center col-md-2 col-sm-4 col-5">
                        <h6 class="m-1 fw700">Ingresar</h6>
                    </button> --}}
                    @if (session('exito'))
                        <a href="/iniciar-sesion" class="my-4 btn btn-secondary d-flex justify-content-center col-md-2 col-sm-4 col-5">
                            <h6 class="m-1 fw700">Iniciar sesion</h6>
                        </a>
                    @else
                        <button type="submit" class="my-4 btn btn-secondary d-flex justify-content-center col-md-2 col-sm-4 col-5">
                            <h6 class="m-1 fw700">Crear Contraseña</h6>
                        </button>
                    @endif
                </div>
            </form>
        @endif
    </section>
@endsection
