<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Vuelve Compostario</title>
    <link href="{{ asset('assets/img/favicon.png')}}" rel="icon" type="image/png">
    <!-- Font remix Icons -->
    <link rel="stylesheet" href="{{ asset('assets/css/remixicon.css?v=').time() }}">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:ital,wght@0,200..800;1,200..800&display=swap"
          rel="stylesheet">
    <!-- Nucleo Icons -->
    <link href="{{ asset('assets/css/nucleo-icons.css?v=').time() }}" rel="stylesheet"/>
    <link href="{{ asset('assets/css/nucleo-svg.css?v=').time() }}" rel="stylesheet"/>
    <!-- <link href="{{ asset('assets/css/main.min.csscss?v=').time() }}" rel="stylesheet" width="5" height="3"> -->

    <!-- Font Awesome Icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css"
          integrity="sha512-DTOQO9RWCH3ppGqcWaEA1BIZOC6xxalwEsw9c2QQeAIftl+Vegovlnee1c9QX4TctnWMn13TZye+giMm8e2LwA=="
          crossorigin="anonymous" referrerpolicy="no-referrer"/>
    <link href="{{ asset('assets/css/nucleo-svg.css?v=').time() }}" rel="stylesheet"/>

    <!-- CSS Files -->
    <link rel="stylesheet" href="{{ asset('assets/css/argon-dashboard.css?v=').time() }}" rel="stylesheet">
    <link rel="stylesheet" href="{{ asset('assets/css/estilos.css?v=').time() }}"/>
    <link rel="stylesheet" href="{{ asset('assets/css/main.css?v=').time() }}"/>
</head>


<body>
<!-- side bar -->
<aside class="sidenav c-princi navbar navbar-vertical navbar-expand-xs border-end fixed-start" id="sidenav-main">
    <div class="sidenav-header">
        <i class="fas fa-times p-3 cursor-pointer text-secondary opacity-5 position-absolute end-0 top-0 d-none d-xl-none"
           aria-hidden="true" id="iconSidenav"></i>
        <a class="navbar-brand m-0" href="">
            <img src="../assets/img/logo__brand-vuelve.svg" class="navbar-brand-img h-100" alt="">
        </a>
    </div>

    <div class="collapse navbar-collapse w-auto h-auto" id="sidenav-collapse-main">
        <ul class="navbar-nav mt-2">
            <li class="nav-item">
                <a href="{{ url('/admin/inicio') }}" class="{{ request()->routeIs('inicio') ? 'active' : '' }}" class="nav-link text-white" role="button">
                    <div
                        class="icon icon-shape icon-sm text-center d-flex align-items-center justify-content-center">
                        <img src="../assets/img/icon_home.svg" alt="">
                    </div>
                    <span class="nav-link-text ms-1">Inicio</span>
                </a>
            </li>
            <li class="nav-item">
                <a data-bs-toggle="collapse" href="#applicationsExamples"
                   class="text-dark nav-link mb-2 border-start border-3 border-success bg-success-serv"
                   aria-controls="applicationsExamples" role="button" aria-expanded="false">
                    <div
                        class="icon icon-shape icon-sm text-center d-flex align-items-center justify-content-center">
                        <img src="../assets/img/icon__BBDD.svg" alt="">
                    </div>
                    <span class="nav-link-text ms-1">Base de datos</span>
                </a>
                <div class="collapse show" id="applicationsExamples">
                    <ul class="nav ms-4">
                        <li class="nav-item">
                            <a class="{{ request()->routeIs('inicio') ? 'active' : '' }}" class="nav-link text-dark" href="{{ url('/admin/bd-vuelve-a-casa') }}">
                                <!-- <span class="sidenav-mini-icon"> VC </span> -->
                                <span class="sidenav-normal"> Vuelve a Casa </span>
                            </a>
                        </li>
                        <li class="nav-item ">
                            <a class="nav-link text-dark" href="{{ url('/admin/bd-vuelve-ceniza') }}">
                                <!-- <span class="sidenav-mini-icon"> VCZ </span> -->
                                <span class="sidenav-normal"> Vuelve Ceniza </span>
                            </a>
                        </li>
                        <li class="nav-item ">
                            <a class="nav-link text-dark" href="{{ url('/admin/bd-vuelve-solidadmin/ario') }}">
                                <!-- <span class="sidenav-mini-icon"> VS </span> -->
                                <span class="sidenav-normal"> Vuelve Solidario </span>
                            </a>
                        </li>
                        <li class="nav-item ">
                            <a class="nav-link text-dark" href="{{ url('/admin/bd-plan-siempre-juntos') }}">
                                <!-- <span class="sidenav-mini-icon"> PSJ </span> -->
                                <span class="sidenav-normal"> Siempre Juntos </span>
                            </a>
                        </li>
                    </ul>
                </div>
            </li>
            <li class="nav-item">
                <a href="{{ url('/admin/pedido') }}" class="nav-link " role="button">
                    <div
                        class="icon icon-shape icon-sm text-center d-flex align-items-center justify-content-center">
                        <img src="../assets/img/icon_compost.svg" alt="">
                    </div>
                    <span class="nav-link-text ms-1 text-dark">Pedido</span>
                </a>
            </li>
            <li class="nav-item ">
                <a href="{{ url('/admin/usuarios') }}" class="nav-link " role="button">
                    <div
                        class="icon icon-shape icon-sm text-center d-flex align-items-center justify-content-center">
                        <img src="./app/assets/img/icon_user.svg" alt="" class="">
                    </div>
                    <span class="nav-link-text ms-1 text-dark">Usuarios</span>
                </a>
            </li>
            <li class="nav-item ">
                <a href="{{ url('/admin/productos') }}" class="nav-link " role="button">
                    <div
                        class="icon icon-shape icon-sm text-center d-flex align-items-center justify-content-center">
                        <img src="./app/assets/img/icon_user.svg" alt="" class="">
                    </div>
                    <span class="nav-link-text ms-1 text-dark">Productos</span>
                </a>
            </li>
            <li class="nav-item mb-7">
                <a href="{{ route('cerrar-sesion') }}" class="nav-link border rounded" role="button">
                    <div
                        class="icon icon-shape icon-sm text-center d-flex align-items-center justify-content-center">
                        <img src="../assets/img/icon_setting.svg" alt="">
                    </div>
                    <span class="nav-link-text ms-1 text-dark">Cerrar Sesión</span>
                </a>
            </li>
        </ul>
    </div>

</aside>

<main class="main-content position-relative">
    <!--   Nav bar  -->
    <nav class="navbar navbar-main navbar-expand-lg px-0 shadow-none border-bottom z-index-sticky " id="navbarBlur"
         data-scroll="false">
        <div class="container-fluid py-1">
            {{-- <div class="sidenav-toggler sidenav-toggler-inner d-xl-block d-none" style="width: 26px;">
                <div class="border text-center rounded">
                    <a href="javascript:;" class="nav-link p-0">
                        <div class="sidenav-toggler-inner">
                            <i class="ri-arrow-left-s-line text-dark"></i>
                        </div>
                    </a>
                </div>
            </div> --}}
            {{-- <div class="order-2 order-sm-0 col-md-7 col-12 ms-xl-4 ms-0 mt-md-0 mt-4 mb-md-0 mb-3">
                <div class="input-group">
                    <input type="text" class="form-control" placeholder="Buscar aquí...."
                        aria-label="Buscar aquí...." aria-describedby="basic-addon2">
                    <span class="input-group-text bg-success text-white" id="basic-addon2"><i
                            class="ri-search-2-line"></i></span>
                </div>
            </div> --}}
            <div class="order-1 order-sm-0 collapse navbar-collapse mt-sm-0 mt-2 me-md-0 me-sm-4" id="navbar">
                <div class="ms-md-auto pe-md-3 d-flex align-items-center">
                </div>
                <ul class="navbar-nav justify-content-end">
                    <li class="nav-item d-xl-none ps-3 d-flex align-items-center">
                        <a href="javascript:;" class="nav-link me-3" id="iconNavbarSidenav">
                            <div class="sidenav-toggler-inner">
                                <i class="fa-solid fa-bars"></i>
                            </div>
                        </a>
                    </li>
                    <li class="nav-item dropdown pe-2 d-flex align-items-center">
                        <a href="javascript:;" class="nav-link border p-2 rounded d-flex align-items-center"
                           id="dropdownMenuButton" data-bs-toggle="dropdown" aria-expanded="false">
                            <i class="ri-notification-4-line cursor-pointer text-dark px-2"></i>
                            <!-- <i class="ri-notification-4-line cursor-pointer text-dark px-2"></i>-->
                            <div class="rounded-circle bg-success-s notifi d-flex justify-content-center">
                                <p class="t-verde font-weight-bold fs-7 mt-not">0</p>
                            </div>
                        </a>
                        <ul class="dropdown-menu dropdown-menu-end px-2 py-3 me-sm-n2"
                            aria-labelledby="dropdownMenuButton">
                            <li class="mb-2">
                                <a class="dropdown-item border-radius-md" href="javascript:;">
                                    <div class="d-flex py-1">
                                        <div class="my-auto">
                                            <img src=".././assets/img/team-2.jpg" class="avatar avatar-sm  me-3 "
                                                 alt="">
                                        </div>
                                        <div class="d-flex flex-column justify-content-center">
                                            <h6 class="text-sm font-weight-normal mb-1">
                                                <span class="font-weight-bold">Nuevo mensaje</span> de Laura
                                            </h6>
                                            <p class="text-xs text-secondary mb-0">
                                                <i class="fa fa-clock me-1"></i>
                                                hace 13 minutos
                                            </p>
                                        </div>
                                    </div>
                                </a>
                            </li>
                            <li class="mb-2">
                                <a class="dropdown-item border-radius-md" href="javascript:;">
                                    <div class="d-flex py-1">
                                        <div class="my-auto">
                                            <img src=".././assets/img/team-2.jpg"
                                                 class="avatar avatar-sm bg-gradient-dark  me-3 " alt="">
                                        </div>
                                        <div class="d-flex flex-column justify-content-center">
                                            <h6 class="text-sm font-weight-normal mb-1">
                                                <span class="font-weight-bold">Nuevo mensaje</span> de Scott
                                            </h6>
                                            <p class="text-xs text-secondary mb-0">
                                                <i class="fa fa-clock me-1"></i>
                                                hace 13 minutos
                                            </p>
                                        </div>
                                    </div>
                                </a>
                            </li>
                            <li>
                                <a class="dropdown-item border-radius-md" href="javascript:;">
                                    <div class="d-flex py-1">
                                        <img src=".././assets/img/team-2.jpg"
                                             class="avatar avatar-sm bg-gradient-dark  me-3 " alt="">
                                        <div class="d-flex flex-column justify-content-center">
                                            <h6 class="text-sm font-weight-normal mb-1">
                                                <span class="font-weight-bold">Nuevo mensaje</span> de Scott
                                            </h6>
                                            <p class="text-xs text-secondary mb-0">
                                                <i class="fa fa-clock me-1"></i>
                                                hace 13 minutos
                                            </p>
                                        </div>
                                    </div>
                                </a>
                            </li>
                        </ul>
                    </li>
                    <li class="nav-item d-flex align-items-center ps-3 pe-2 ">
                        <a
                            class="d-flex align-items-center justify-content-center option border rounded-circle nav-link px-0">
                            <i class="ri-user-3-line text-dark p-5"></i>
                        </a>
                    </li>
                    <li class="dropdown nav-item d-flex align-items-center">
                        <a href="javascript:;" class="nav-link text-dark  px-0" id="dropdownMenuButton"
                           data-bs-toggle="dropdown" aria-expanded="false">
                            <i class="ri-arrow-down-s-line"></i>
                        </a>
                        <ul class="dropdown-menu dropdown-menu-end px-2 py-3 me-2"
                            aria-labelledby="dropdownMenuButton" style="margin-right: 5px !important;">
                            <li><a class="text-dark dropdown-item border-radius-md" href="javascript:;">Mi
                                    Perfil</a></li>
                            <li><a class="text-dark dropdown-item border-radius-md" href="javascript:;">Ajustes</a>
                            </li>
                            <li><a class="text-dark dropdown-item border-radius-md" href="javascript:;">Cerrar
                                    Sesión</a></li>
                        </ul>
                    </li>
                </ul>
            </div>
        </div>
    </nav>

    <!--   Content -->
    <div>
        @yield('content')

        @include('front.layouts.footeradmin')

    </div>
</main>


<!-- Core -->
<script src="{{ asset('assets/js/core/popper.min.js?v=') . time() }}"></script>
<script src="{{ asset('assets/js/core/bootstrap.min.js?v=') . time() }}"></script>
<script src="{{ asset('assets/js/core/datatables.js?v=') . time() }}"></script>

<!-- //cdn.datatables.net/2.3.1/css/dataTables.dataTables.min.css -->
<!-- Theme JS -->
<script src="{{ asset('assets/js/argon-dashboard.min.js?v=') . time() }}"></script>
<script src="https://code.jquery.com/jquery-2.2.4.min.js"></script>
<script src="{{ asset('assets/js/custom.js?v=') . time() }}"></script>


</body>

</html>
