@extends('front.layouts.userconductor')
@section('content')

    <div class="container-fluid">
        <a href="/conductor/inicio/" class="text-dark d-flex align-items-center mt-3">
            <i class="fa-solid fa-arrow-left"></i>
            <div class="semibold ms-2 fs-6">Volver</div>
        </a>


        <!-- TItel general -->
        <div class="headline-main mb-4">
            <h4 class="font-weight-bolder mt-4">Servicio de {{ $recojo->nombre_mascota }}</h4>
        </div>
        <!-- Line separator -->
        <div class="position-relative d-flex justify-content-center">
            <svg xmlns="http://www.w3.org/2000/svg" width="" height="18" viewBox="0 0 1105 18" fill="none">
                <path
                    d="M0 17H539.182C547.993 17 556.738 15.4676 565.025 12.4713L584.225 5.52866C592.512 2.53238 601.257 1 610.068 1H1105"
                    stroke="#CFCFCF" stroke-width="1.5"/>
            </svg>
        </div>

        <!-- Timeline compost -->
        <div class="row">
            <div class="col-xl-12 col-lg-12 col-md-12">
                <!-- card general -->
                <div class="card my-4 py-5">
                    <div class="row justify-content-center">
                        <div class="col-11">
                            <!-- description  -->
                            <div class="card">
                                <div class="description border-radius-lg">
                                    <h5 class="f-weight pb-3">Datos </h5>
                                    <div class="card-body border border-radius-md">
                                        <div class="row">

                                            <!-- info -->
                                            <div class="col-lg-8">
                                                <div class="mb-3 row dates-pets">
                                                    <label class="ms-0 mb-2 col-12 col-sm-auto">Nombres :</label>
                                                    <div class="col-auto"><span class="black-main labeltext f-weight-40">{{ $recojo->nombres }} {{ $recojo->apellidos }}</span></div>
                                                </div>

                                                <div class="mb-3 row">
                                                    <label class="ms-0 mb-2 col-12 col-sm-auto">Celular :</label>
                                                    <div class="col-auto">
                                                        <span class="black-main labeltext f-weight-40">{{ $recojo->celular }}</span>
                                                    </div>
                                                </div>

                                                <div class="mb-3 row">
                                                    <label class="ms-0 mb-2 col-12 col-sm-auto">Nombre de Mascota :</label>
                                                    <div class="col-auto">
                                                        <span class="black-main labeltext f-weight-40">{{ $recojo->nombre_mascota }}</span>
                                                    </div>
                                                </div>

                                                <div class="mb-3 row">
                                                    <label class="ms-0 mb-2 col-12 col-sm-auto">Tipo :</label>
                                                    <div class="col-auto">
                                                        <span
                                                            class="black-main labeltext f-weight-40">{{ $recojo->tipo_mascota }}</span>
                                                    </div>
                                                </div>

                                                <div class="mb-3 row">
                                                    <label class="ms-0 mb-2 col-12 col-sm-auto">Peso :</label>
                                                    <div class="col-auto">
                                                        <span class="black-main labeltext f-weight-40">{{ $recojo->peso_mascota }}kg.</span>
                                                    </div>
                                                </div>

                                                <div class="mb-3 row">
                                                    <label class="ms-0 mb-2 col-12 col-sm-auto">Hora de recojo :</label>
                                                    <div class="col-auto">
                                                        <span class="black-main labeltext f-weight-40">{{ $recojo->horario }}</span>
                                                    </div>
                                                </div>

                                                <div class="mb-3 row">
                                                    <label class="ms-0 mb-2 col-12 col-sm-auto">Dirección de recojo :</label>
                                                    <div class="col-auto">
                                                        <span class="black-main labeltext f-weight-40">{{ $recojo->direccion_recojo }}</span>
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- image -->
                                            <div class="col-lg-4 d-flex justify-content-center align-items-center">
                                                <div class="imagePets w-full h-full border-radius-md shadow-czi">
                                                    @if ($recojo->tipo_mascota == 'Gat@')
                                                        <img src="{{ asset('assets/img/mascotas/gato.svg')}}" width="170" alt="gato">
                                                    @elseif ($recojo->tipo_mascota == 'Perr@')
                                                        <img src="{{ asset('assets/img/mascotas/perro.png')}}" width="170" alt="perro">
                                                    @elseif ($recojo->tipo_mascota == 'Conej@')
                                                        <img src="{{ asset('assets/img/mascotas/conejo.png')}}" width="170" alt="conejo">
                                                    @elseif ($recojo->tipo_mascota == 'Pajarito')
                                                        <img src="{{ asset('assets/img/mascotas/pajarito.png')}}" width="170" alt="pajarito">
                                                    @else
                                                        <img src="{{ asset('assets/img/mascotas/gato.svg')}}" width="170" alt="gato">
                                                    @endif
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="card border border-radius-lg">
                                <!-- recojo -->
                                <div class="timeline-kanban">
                                    <h5 class="f-weight px-4 py-4">Timeline del conductor para el recojo de la mascota</h5>
                                    <hr>
                                    <!-- oper asigned -->
                                    <div class="asignado position-relative mx-4 my-4">
                                        <p class="f-weight labeltext color-grey">Conductor Asignado</p>


                                        <form method="POST" class="d-flex flex-column" action="{{ route('conductor_confirmar_ida') }}"
                                              class="col-lg-4 col-md-6 col-12 conductor-asignado">
                                            @csrf
                                            <div class="border input-name">
                                                <span class="text-dark">{{ $conductor->nombre_conductor }}</span>
                                            </div>
                                            <input type="hidden" id="id_recojo" name="id_recojo"
                                                   value="{{ $recojo->id_recojo }}">
                                            <input type="hidden" id="confirmacion" name="confirmacion" value="1">
                                            @if ($recojo->conductor_confirmado === 1)
                                                <button role="button" disabled type="submit"
                                                        class="btn-lg btn btn-success labeltext w-full">Confirmado
                                                </button>
                                            @else
                                                <button role="button" type="submit"
                                                        class="btn-lg btn btn-success labeltext w-full">Confirmar
                                                </button>
                                            @endif
                                        </form>
                                    </div>
                                    {{-- @if ($recojo->conductor_confirmado === 1) --}}
                                    <!-- timeline -->
                                    <hr>
                                    <div class="timeline-label">
                                        <div class="recojo-mascota">
                                            <!-- begin::Item 0  -->
                                            @if (!empty($pedido_id->acompaniar_mascota) && $pedido_id->acompaniar_mascota == 'true' && $pedido_id->traslado_mascota == 'servicio')

                                                <div class="timeline-item item-border pt-3 pt-sm-5 border-bottom">
                                                    <!--begin::Date-->

                                                    <!--begin::Badge-->
                                                    <div class="timeline-badge">
                                                        <div class="text-center rounded-circle badge-circle border labeltext black-main c-princi"></div>
                                                    </div>
                                                    <div class="w-100">
                                                        <form method="POST" class="d-flex flex-column flex-sm-row" action="{{ route('confirmar_acompanamiento') }}" class="d-flex">
                                                            @csrf
                                                            <input type="hidden" id="id_recojo" name="id_recojo" value="{{ $recojo->id_recojo }}">
                                                            <input type="hidden" id="nombre_usuario" name="nombre_usuario" value="{{ $recojo->nombres }} {{ $recojo->apellidos }}">
                                                            <input type="hidden" id="nombre_mascota" name="nombre_mascota" value="{{ $recojo->nombre_mascota }}">
                                                            <input type="hidden" id="email" name="email" value="{{$recojo->email}}">

                                                            <div class="timeline-content w-100">
                                                                <div class="timeline-activity card-body p-0">
                                                                    <h5 class="f-weight">Confirmas disponibilidad de traslado para los acompañantes</h5>
                                                                    <p class="labeltext">Hasta 3 acompañantes junto con su mascota</p>
                                                                    <div>
                                                                        @if (empty($recojo->acompaniamento_confirmado))
                                                                            <select class="form-select" id="disponibilidad" name="disponibilidad" aria-label="Default select example">
                                                                                <option selected disabled>Seleccionar</option>
                                                                                <option value="1">SI</option>
                                                                                <option value="0">NO</option>
                                                                            </select>
                                                                        @else
                                                                            @if ($recojo->acompaniamento_confirmado == 1)
                                                                                <input disabled type="text" class="form-control col-6 px-2 py-2" value="Acompañamiento Confirmado">
                                                                            @elseif($recojo->acompaniamento_confirmado == 0)
                                                                                <input disabled type="text" class="form-control col-6 px-2 py-2" value="No cuento con disponibilidad">
                                                                            @endif
                                                                        @endif
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div>
                                                                @if ($recojo->acompaniamento_confirmado)
                                                                    <button role="button" disabled type="submit" class="btn btn-success labeltext">Realizado</button>
                                                                @else
                                                                    <button role="button" type="submit" class="w-100 btn btn-outline-dark">Realizado</button>
                                                                @endif
                                                            </div>
                                                        </form>
                                                    </div>
                                                    <!-- <a href="" class="w-100 btn btn-outline-dark">Realizado</a> -->
                                                </div>
                                            @endif
                                            <!-- begin::Item 1  -->
                                            <div class="timeline-item item-border pt-3 pt-sm-5 border-bottom">
                                                <!--begin::Date-->

                                                <!--begin::Badge-->
                                                <div class="timeline-badge">
                                                    <div class="text-center rounded-circle badge-circle border labeltext black-main c-princi"> 1</div>
                                                </div>
                                                <div class="w-100">
                                                    <form method="POST" class="d-flex flex-column flex-sm-row" action="{{ route('registro_actividad_recojo_ida_paso1') }}" class="d-flex">
                                                        @csrf
                                                        <input type="hidden" id="id_recojo" name="id_recojo" value="{{ $recojo->id_recojo }}">
                                                        <input type="hidden" id="estado_etapa" name="estado_etapa" value="1">
                                                        <input type="hidden" id="email" name="email" value="{{$recojo->email}}">

                                                        <div class="timeline-content w-100">
                                                            <div class="timeline-activity card-body p-0">
                                                                <h5 class="f-weight">Conductor salió al punto de recojo</h5>
                                                                <p class="labeltext">Saliendo a recoger a la mascota. ¿Cúal es el tiempo estimado para llegar al punto?</p>
                                                                <div>
                                                                    @if (empty($recojo->tiempo_llegada))
                                                                        <select class="form-select" id="tiempo-llegada" name="tiempo_llegada" aria-label="Default select example">
                                                                            <option selected disabled>Seleccionar</option>
                                                                            <option value="10 min.">10 min.</option>
                                                                            <option value="20 min.">20 min.</option>
                                                                            <option value="30 min.">30 min.</option>
                                                                            <option value="40 min.">40 min.</option>
                                                                            <option value="50 min.">50 min.</option>
                                                                            <option value="1 hora">1 hora</option>
                                                                            <option value="1 Hrs y 30 min.">1 Hrs y 30 min.</option>
                                                                        </select>
                                                                    @else
                                                                        <input disabled type="text" class="form-control col-6 px-2 py-2" value="{{$recojo->tiempo_llegada}}">
                                                                    @endif
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div>
                                                            @if ($recojo->estado_etapa >= 1)
                                                                <button role="button" disabled type="submit" class="btn btn-success labeltext">Realizado</button>
                                                            @else
                                                                <button role="button" type="submit" class="w-100 btn btn-outline-dark">Realizado</button>
                                                            @endif
                                                        </div>
                                                    </form>
                                                </div>
                                                <!-- <a href="" class="w-100 btn btn-outline-dark">Realizado</a> -->
                                            </div>
                                            <!-- begin::Item 2 -->
                                            <div class="timeline-item item-border pt-3 pt-sm-5 border-bottom">
                                                <!--begin::Date-->

                                                <!--begin::Badge-->
                                                <div class="timeline-badge">
                                                    <div
                                                        class="text-center rounded-circle badge-circle border labeltext black-main c-princi">
                                                        2
                                                    </div>
                                                </div>
                                                <div class="timeline-content w-100">
                                                    <div class="timeline-activity card-body p-0">
                                                        <h5 class="f-weight">Conductor llegó al punto de recojo</h5>
                                                        <p class="labeltext">He llegado al punto de recojo</p>
                                                    </div>
                                                </div>
                                                <form method="POST" action="{{ route('registro_actividad_recojo_ida_paso2') }}" class="">
                                                    @csrf
                                                    <input type="hidden" id="id_recojo" name="id_recojo" value="{{ $recojo->id_recojo }}">
                                                    <input type="hidden" id="estado_etapa" name="estado_etapa" value="2">
                                                    <input type="hidden" id="email" name="email" value="{{$recojo->email}}">
                                                    @if ($recojo->estado_etapa >= 2)
                                                        <button role="button" disabled type="submit" class="btn btn-success labeltext">Realizado</button>
                                                    @else
                                                        <button role="button" type="submit" class="w-100 btn btn-outline-dark">Realizado</button>
                                                    @endif
                                                </form>
                                                <!-- <a href="" class="w-100 btn btn-outline-dark">Realizado</a> -->
                                            </div>
                                            <!-- begin::Item 3 -->
                                            <div class="timeline-item item-border pt-3 pt-sm-5 border-bottom">
                                                <!--begin::Date-->

                                                <!--begin::Badge-->
                                                <div class="timeline-badge">
                                                    <div
                                                        class="text-center rounded-circle badge-circle border labeltext black-main c-princi">
                                                        3
                                                    </div>
                                                </div>
                                                <div class="timeline-content w-100">
                                                    <div class="timeline-activity card-body p-0">
                                                        <h5 class="f-weight">El recojo ha sido realizado</h5>
                                                        <p class="labeltext">Ha sido recogido la mascota de su casa
                                                        </p>
                                                    </div>
                                                </div>
                                                <form method="POST" class="d-flex flex-column flex-sm-row" action="{{ route('registro_actividad_recojo_ida_paso3') }}" class="">
                                                    @csrf
                                                    <input type="hidden" id="id_recojo" name="id_recojo" value="{{ $recojo->id_recojo }}">
                                                    <input type="hidden" id="nombre_usuario" name="nombre_usuario" value="{{ $recojo->nombres }} {{ $recojo->apellidos }}">
                                                    <input type="hidden" id="nombre_mascota" name="nombre_mascota" value="{{ $recojo->nombre_mascota }}">
                                                    <input type="hidden" id="email" name="email" value="{{$recojo->email}}">
                                                    <input type="hidden" id="estado_etapa" name="estado_etapa" value="3">
                                                    @if ($recojo->estado_etapa >= 3)
                                                        <button role="button" disabled type="submit"
                                                                class="btn btn-success labeltext">Realizado
                                                        </button>
                                                    @else
                                                        <button role="button" type="submit"
                                                                class="w-100 btn btn-outline-dark">Realizado
                                                        </button>
                                                    @endif
                                                </form>
                                                <!-- <a href="" class="w-100 btn btn-outline-dark">Realizado</a> -->
                                            </div>
                                            <!-- begin::Item 4 -->
                                            <div class="timeline-item item-border pt-3 pt-sm-5">
                                                <!--begin::Date-->

                                                <!--begin::Badge-->
                                                <div class="timeline-badge">
                                                    <div
                                                        class="text-center rounded-circle badge-circle border labeltext black-main c-princi">
                                                        4
                                                    </div>
                                                </div>
                                                <div class="timeline-content w-100">
                                                    <div class="timeline-activity card-body p-0">
                                                        <h5 class="f-weight">Llegada al compostario</h5>
                                                        <p class="labeltext">He llegado al compostario, estoy haciendo entrega al operario</p>
                                                    </div>
                                                </div>
                                                <form method="POST" class="d-flex flex-column flex-sm-row" action="{{ route('registro_actividad_recojo_ida_paso4') }}"
                                                      class="">
                                                    @csrf
                                                    <input type="hidden" id="id_usuario" name="id_usuario" value="{{ $recojo->id_usuario }}">
                                                    <input type="hidden" id="id_mascota" name="id_mascota" value="{{ $recojo->id_mascota }}">
                                                    <input type="hidden" id="id_recojo" name="id_recojo" value="{{ $recojo->id_recojo }}">
                                                    <input type="hidden" id="nombre_usuario" name="nombre_usuario" value="{{ $recojo->nombres }} {{ $recojo->apellidos }}">
                                                    <input type="hidden" id="nombre_mascota" name="nombre_mascota" value="{{ $recojo->nombre_mascota }}">
                                                    <input type="hidden" id="email" name="email" value="{{$recojo->email}}">
                                                    <input type="hidden" id="estado_etapa" name="estado_etapa" value="4">
                                                    <input type="hidden" id="etapa_recojo" name="etapa_recojo" value="1">
                                                    @if ($recojo->estado_etapa >= 4)
                                                        <button role="button" disabled type="submit"
                                                                class="btn btn-success labeltext">Realizado
                                                        </button>
                                                    @else
                                                        <button role="button" type="submit"
                                                                class="w-100 btn btn-outline-dark">Realizado
                                                        </button>
                                                    @endif
                                                </form>
                                                <!-- <a href="" class="w-100 btn btn-outline-dark">Realizado</a> -->
                                            </div>
                                        </div>
                                    </div>

                                    <!-- timeline -->
                                    {{-- @endif --}}
                                </div>
                            </div>


                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
