@extends('front.layouts.useradministrador')
@section('content')
<div class="container-fluid">
    <div class="row">
        <!-- Head title -->
        <div class="col-xl-12 mt-5">
            <div class="card-header">
                <h4 class="font-weight-bold">Agregar usuarios</h4>
            </div>
        </div>
        <!-- Form crear usuarios -->
        <div class="col-xl-12 py-4">
            <div class="card">
                <div class="card-header">
                    <h5 class="font-weight-bold">Datos del usuario para agregar</h5>
                </div>

                <!-- Form -->
                <div class="card-body">
                    <div class="row form-registro-administrador">
                        <div class="col-lg-3">
                            <label for="nombre-admin" class="text-dark form-label mb-2">Nombre</label>
                            <input type="text" name="nombre-admin" class="form-control" id="nombre-admin"
                                placeholder="Escriba su nombre">
                        </div>

                        <div class="col-lg-3">
                            <label for="rol-admin" class="text-dark form-label mb-2">Rol</label>
                            <select name="rol-admin" class="form-select" id="rol-admin">
                                <option disabled selected class="text-dark">Seleccionar</option>
                                <option value="1" class="text-dark">Administrador</option>
                                <option value="2" class="text-dark">Operario</option>
                                <option value="3" class="text-dark">Conductor</option>
                            </select>
                        </div>

                        <div class="col-lg-3">
                            <label for="email-admin"
                                class="text-dark form-label form-label mb-2">Email</label>
                            <input type="email" class="form-control" id="email-admin" placeholder="name@example.com">
                        </div>

                        <div class="col-lg-3">
                            <label for="password-admin" class="text-dark form-label mb-2">Password</label>
                            <input type="password-admin" id="password-admin" placeholder="Crear contraseña"
                                class="form-control" aria-describedby="passwordHelpBlock">
                        </div>

                        <div class="footer">
                            <div class="row">
                                <div class="col-xl-12 d-flex justify-content-end mt-4">
                                    <a href="#" id="registro-usuario-admin" class="btn ">Crear Usuario</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Tabla de Usuarios creados -->
        <div class="col-xl-12 py-3">
            <div class="card">
                <div class="card-header">
                    <h5 class="font-weight-bold">Usuarios de Vuelve Compostario</h5>
                </div>

                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-flush">
                            <thead class="c-princi">
                                <tr role="row">
                                    <th class="px-0 text-xs f-weight color-grey"><span class="text-thead">N°</span></th>
                                    <th class="px-0 text-xs f-weight color-grey"><span class="text-thead">Nombre</span></th>
                                    <th class="px-0 text-xs f-weight color-grey"><span class="text-thead">Email</span></th>
                                    <th class="px-0 text-xs f-weight color-grey"><span class="text-thead">Contraseña</span></th>
                                    <th class="px-0 text-xs f-weight color-grey"><span class="text-thead">Rol</span></th>
                                    <th class="px-0 text-xs f-weight color-grey"><span class="text-thead">Opciones</span></th>
                                </tr>
                            </thead>

                            <t-body class="position-relative">
                                @foreach ( $administradores as $administrador)
                                <tr>
                                    <td class="f-weight-50 black-main text-xs"><span class="text-td">{{$administrador->id_administrador}}</span></td>
                                    <td class="f-weight-50 black-main text-xs"><span class="text-td">{{$administrador->nombres}}</span></td>
                                    <td class="f-weight-50 black-main text-xs"><span class="text-td">{{$administrador->email}}</span></td>
                                    <td class="f-weight-50 black-main text-xs"><span class="text-td">{{$administrador->contrasena}}</span></td>
                                    <td class="f-weight-50 black-main text-xs"><span class="text-td">Admin</span></td>
                                    <td class="f-weight-50 black-main text-xs">
                                        <div class="opciones">
                                            <a href="/administrador/usuario/{{ $administrador->id_administrador }}">
                                                <i class="ri-pencil-line"></i>
                                            </a>
                                            <a href="#" type="button" class="">
                                                <i class="ri-delete-bin-line"></i>
                                            </a>
                                        </div>
                                    </td>
                                </tr>
                                @endforeach
                                @foreach ( $operarios as $operario)
                                <tr>
                                    <td class="f-weight-50 black-main text-xs"><span class="text-td">{{$operario->id_operario}}</span></td>
                                    <td class="f-weight-50 black-main text-xs"><span class="text-td">{{$operario->nombres}}</span></td>
                                    <td class="f-weight-50 black-main text-xs"><span class="text-td">{{$operario->email}}</span></td>
                                    <td class="f-weight-50 black-main text-xs"><span class="text-td">{{$operario->contrasena}}</span></td>
                                    <td class="f-weight-50 black-main text-xs"><span class="text-td">Operario</span></td>
                                    <td class="f-weight-50 black-main text-xs">
                                        <div class="opciones">
                                            <a href="/operario/usuario/{{ $operario->id_operario }}">
                                                <i class="ri-pencil-line"></i>
                                            </a>
                                            <a href="#" type="button" class="">
                                                <i class="ri-delete-bin-line"></i>
                                            </a>
                                        </div>
                                    </td>
                                </tr>
                                @endforeach
                                @foreach ( $conductores as $conductor)
                                <tr>
                                    <td class="f-weight-50 black-main text-xs"><span class="text-td">{{$conductor->id_conductor}}</span></td>
                                    <td class="f-weight-50 black-main text-xs"><span class="text-td">{{$conductor->nombre_conductor}}</span></td>
                                    <td class="f-weight-50 black-main text-xs"><span class="text-td">{{$conductor->email}}</span></td>
                                    <td class="f-weight-50 black-main text-xs"><span class="text-td">{{$conductor->contrasena}}</span></td>
                                    <td class="f-weight-50 black-main text-xs"><span class="text-td">Conductor</span></td>
                                    <td class="f-weight-50 black-main text-xs">
                                        <div class="opciones">
                                            <a href="/conductor/usuario/{{ $conductor->id_conductor }}"></a>
                                                <i class="ri-pencil-line"></i>
                                            </a>
                                            <a href="#" type="button" class="">
                                                <i class="ri-delete-bin-line"></i>
                                            </a>
                                        </div>
                                    </td>
                                </tr>
                                @endforeach
                            </t-body>
                        </table>
                    </div>
                    <!-- <div class="row">
                        <div class="col-xl-12 d-flex justify-content-end mt-3">
                            <a href="" type="button" class="btn">Guardar cambios</a>
                        </div>
                    </div> -->
                </div>
            </div>
        </div>
    </div>
</div>


@endsection