@extends('front.layouts.useradministrador')
@section('content')

    <!--   Content -->

    <div class="container-fluid">
        <!--   head Title -->
        <div class="row head d-flex align-items-center py-5">
            <!--  head -->
            <div class="col-xl-9 col-lg-9 col-md-8">
                <h4 class="f-weight">Admin Vuelve Compostario</h4>
            </div>

            <div class="col-xl-3 col-lg-3 col-md-4 col-sm-12">
                <a href="{{ url('/admin/usuarios') }}" class="btn mb-0 btn-success col-lg-12 col-md-12 labeltext
          "><span><i class="me-1 ri-add-line p-0" style="font-size: 24px;"></i></span><span class="m-0 p-0">Agregar
                    usuarios</span></a>
            </div>
        </div>

        <!-- cards -->
        <div class="row cards g-4">
            <div class="col-9">
                <div class="row">
                    <div class="col-9">
                        <div class="card mb-4">
                            <div class="card-header  pb-0">
                                <h5 class="subtitle mb-0">Servicios en compostario</h5>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-lg-4 col-md-4 col-sm-4">
                                        <div class="item-t-xs">
                                            <h2 class=" f-weight-50 black-main m-0">{{$totalServiciosEnProceso}}</h2>
                                            <p class="text-sm m-0 black-main">Total de <br> Servicios en Proceso</p>
                                        </div>
                                    </div>

                                    <div class="col-lg-4 col-md-4 col-sm-4">
                                        <div class="item-t-xs">
                                            <h2 class=" f-weight-50 black-main m-0">{{$totalServiciosVuelveCasa}}</h2>
                                            <p class="text-sm m-0 black-main">Servicio <br> Vuelve a Casa</p>
                                        </div>
                                    </div>

                                    <div class="col-lg-4 col-md-4 col-sm-4">
                                        <div class="item-t-xs">
                                            <h2 class=" f-weight-50 black-main m-0">{{$totalServiciosSiempreJuntos}}</h2>
                                            <p class="text-sm m-0 black-main">Servicio <br>Siempre Juntos</p>
                                        </div>
                                    </div>
                                    <!--
                            <div class="col-md-3">
                              <img src="../assets/img/zimba-image.svg" alt="imagen-compost">
                            </div>
                            -->
                                </div>
                            </div>

                        </div>
                    </div>
                    <!-- Resume -->
                    <div class="col-3">
                        <div class="card mb-4 bg-surface-primary ">
                            <div class="card-header pb-0 mb-0">
                                <h5 class="white-color">Resumen</h5>
                            </div>
                            <div class="card-body pt-0">
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="d-flex align-items-center position-relative">
                                            <h2 class="col-3 m-0 f-weight-50 color-font-white">{{$ClientesVuelveaCasa}}</h2>
                                            <p class="alpha-white text-sm m-0 ps-2">Total de Clientes <br>Vuelve a Casa</p>
                                        </div>
                                    </div>
                                    <div class="col-md-12">
                                        <div class="d-flex align-items-center position-relative">
                                            <h2 class="col-3 m-0 f-weight-50 color-font-white">{{$ClientesSiempreJuntos}}</h2>
                                            <p class="alpha-white text-sm m-0 ps-2">Total de Clientes <br>Siempre Juntos</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-12">
                        <div class="card mb-4">
                            <div class="card-header pb-0">
                                <div class="row">
                                    <div class="col-xl-12">
                                        <h6 class="font-weight-bold">Timeline de la mascota</h6>
                                    </div>

                                </div>
                            </div>

                            <div class="card-body h-100 pb-3">
                                <table class="table table-flush">
                                    <thead class="bg-grey-10">
                                    <tr>
                                        <th class="text-xs text-center">Salida al pto de recojo</th>
                                        <th class="text-xs text-center">Llegada al punto de recojo</th>
                                        <th class="text-xs text-center">En camino al compostario</th>
                                        <th class="text-xs text-center">Llegada al compostario</th>
                                        <th class="text-xs text-center">Inicio de Compostaje</th>
                                        <th class="text-xs text-center">Cuna Lista</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <tr>
                                        <td class="text-xs text-center">
                                            @foreach($timelineConductor as $item)
                                                @if($item->estado_etapa == 1)
                                                    <span class="text-xs text-center d-block mb-1 btn bg-success text-white">
                                                        {{ $item->nombre_mascota }}
                                                    </span>
                                                @endif
                                            @endforeach
                                        </td>
                                        <td class="text-xs text-center">
                                            @foreach($timelineConductor as $item)
                                                @if($item->estado_etapa == 2)
                                                    <span class="text-xs text-center d-block mb-1 btn bg-success text-white">
                                                        {{ $item->nombre_mascota }}
                                                    </span>
                                                @endif
                                            @endforeach
                                        </td>
                                        <td class="text-xs text-center">
                                            @foreach($timelineConductor as $item)
                                                @if($item->estado_etapa == 3)
                                                    <span class="text-xs text-center d-block mb-1 btn bg-success text-white">
                                                        {{ $item->nombre_mascota }}
                                                    </span>
                                                @endif
                                            @endforeach
                                        </td>
                                        <td class="text-xs text-center">
                                            @foreach($timelineConductor as $item)
                                                @if($item->estado_etapa == 4)
                                                    <span class="text-xs text-center d-block mb-1 btn bg-success text-white">
                                                        {{ $item->nombre_mascota }}
                                                    </span>
                                                @endif
                                            @endforeach
                                        </td>
                                        <td class="text-xs text-center">
                                            @foreach($timelineCompostajeIniciado as $item)
                                                <span class="text-xs text-center d-block mb-1 btn bg-success text-white">
                                                    {{ $item->nombre_mascota }}
                                                </span>
                                            @endforeach
                                        </td>
                                        <td class="text-xs text-center">
                                            @foreach($timelineCompostajeFinalizado as $item)
                                                <span class="text-xs text-center d-block mb-1 btn bg-success text-white">
                                                    {{ $item->nombre_mascota }}
                                                </span>
                                            @endforeach
                                        </td>
                                    </tr>
                                    </tbody>
                                </table>

                            </div>
                        </div>
                    </div>
                    <div class="col-12">
                        <div class="card mb-4">
                            <!-- card header -->
                            <div class="card-header pb-0">
                                <div class="row align-items-center">
                                    <div class="col-md-9">
                                        <h5 class="subtitle f-weight-50">Registros Recientes</h5>
                                    </div>

                                    <div class="col-md-3">
                                        <select class="form-select form-select-table" aria-label="Default select example">
                                            <option selected data-chart="table-semana" class="text-dark">Esta Semana</option>
                                            <option value="1" data-chart="table-15dias" class="text-dark ">Hace 15 días</option>
                                            <option value="2" data-chart="table-mes" class="text-dark ">Hace un Mes</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <!-- card body table -->
                            <div class="card-body h-100">
                                <div id="table-semana" class="table-responsive">
                                    <table class="table table-flush">
                                        <thead class="bg-grey-10">
                                        <tr role="row">
                                            <th><span class=" text-uppercase text-xs f-weight color-grey">Fecha de registro</span></th>
                                            <th><span class=" text-uppercase text-xs f-weight color-grey">Cliente</span></th>
                                            <th><span class=" text-uppercase text-xs f-weight color-grey">Mascota</span></th>
                                            <th><span class=" text-uppercase text-xs f-weight color-grey">Peso</span></th>
                                            <th><span class=" text-uppercase text-xs f-weight color-grey">Tipo</span></th>
                                            <th><span class=" text-uppercase text-xs f-weight color-grey">Edad</span></th>
                                        </tr>
                                        </thead>

                                        <t-body class="position-relative">
                                            @foreach ( $objNuevosClientesEstaSemana as $objNuevosCliente)

                                                <tr>
                                                    <td><span class="text-sm f-weight-50 text-sm black-main">{{$objNuevosCliente->fecha_creacion}}</span></td>
                                                    <td><span class="text-sm f-weight-50 text-sm black-main">{{$objNuevosCliente->nombres}} {{$objNuevosCliente->apellidos}}</span></td>
                                                    <td><span class="text-sm f-weight-50 text-sm black-main">{{$objNuevosCliente->nombre_mascota}}</span></td>
                                                    <td><span class="text-sm f-weight-50 text-sm black-main">{{$objNuevosCliente->peso_mascota}} Kg.</span></td>
                                                    <td><span class="text-sm f-weight-50 text-sm black-main">{{$objNuevosCliente->tipo_mascota}}</span></td>
                                                    <td><span class="text-sm f-weight-50 text-sm black-main">{{$objNuevosCliente->edad_mascota}}</span></td>
                                                </tr>
                                            @endforeach
                                        </t-body>
                                    </table>
                                </div>

                                <div id="table-15dias" class="d-none table-responsive">
                                    <table class="table table-flush">
                                        <thead class="bg-grey-10">
                                        <tr role="row">
                                            <th><span class=" text-uppercase text-xs f-weight color-grey">Fecha de registro</span></th>
                                            <th><span class=" text-uppercase text-xs f-weight color-grey">Cliente</span></th>
                                            <th><span class=" text-uppercase text-xs f-weight color-grey">Mascota</span></th>
                                            <th><span class=" text-uppercase text-xs f-weight color-grey">Peso</span></th>
                                            <th><span class=" text-uppercase text-xs f-weight color-grey">Tipo</span></th>
                                            <th><span class=" text-uppercase text-xs f-weight color-grey">Edad</span></th>
                                        </tr>
                                        </thead>

                                        <t-body class="position-relative">
                                            @foreach ( $objNuevosClientes15Dias as $objNuevosCliente)

                                                <tr>
                                                    <td><span class="text-sm f-weight-50 text-sm black-main">{{$objNuevosCliente->fecha_creacion}}</span></td>
                                                    <td><span class="text-sm f-weight-50 text-sm black-main">{{$objNuevosCliente->nombres}} {{$objNuevosCliente->apellidos}}</span></td>
                                                    <td><span class="text-sm f-weight-50 text-sm black-main">{{$objNuevosCliente->nombre_mascota}}</span></td>
                                                    <td><span class="text-sm f-weight-50 text-sm black-main">{{$objNuevosCliente->peso_mascota}} Kg.</span></td>
                                                    <td><span class="text-sm f-weight-50 text-sm black-main">{{$objNuevosCliente->tipo_mascota}}</span></td>
                                                    <td><span class="text-sm f-weight-50 text-sm black-main">{{$objNuevosCliente->edad_mascota}}</span></td>
                                                </tr>
                                            @endforeach
                                        </t-body>
                                    </table>
                                </div>

                                <div id="table-mes" class="d-none table-responsive">
                                    <table class="table table-flush">
                                        <thead class="bg-grey-10">
                                        <tr role="row">
                                            <th><span class=" text-uppercase text-xs f-weight color-grey">Fecha de registro</span></th>
                                            <th><span class=" text-uppercase text-xs f-weight color-grey">Cliente</span></th>
                                            <th><span class=" text-uppercase text-xs f-weight color-grey">Mascota</span></th>
                                            <th><span class=" text-uppercase text-xs f-weight color-grey">Peso</span></th>
                                            <th><span class=" text-uppercase text-xs f-weight color-grey">Tipo</span></th>
                                            <th><span class=" text-uppercase text-xs f-weight color-grey">Edad</span></th>
                                        </tr>
                                        </thead>

                                        <t-body class="position-relative">
                                            @foreach ( $objNuevosClientes1mes as $objNuevosCliente)

                                                <tr>
                                                    <td><span class="text-sm f-weight-50 text-sm black-main">{{$objNuevosCliente->fecha_creacion}}</span></td>
                                                    <td><span class="text-sm f-weight-50 text-sm black-main">{{$objNuevosCliente->nombres}} {{$objNuevosCliente->apellidos}}</span></td>
                                                    <td><span class="text-sm f-weight-50 text-sm black-main">{{$objNuevosCliente->nombre_mascota}}</span></td>
                                                    <td><span class="text-sm f-weight-50 text-sm black-main">{{$objNuevosCliente->peso_mascota}} Kg.</span></td>
                                                    <td><span class="text-sm f-weight-50 text-sm black-main">{{$objNuevosCliente->tipo_mascota}}</span></td>
                                                    <td><span class="text-sm f-weight-50 text-sm black-main">{{$objNuevosCliente->edad_mascota}}</span></td>
                                                </tr>
                                            @endforeach
                                        </t-body>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>


                    <div class="col-12">
                        <div class="card mb-4">
                            <div class="card-header pb-0">
                                <div class="row">
                                    <div class="col-xl-9">
                                        <h6 class="font-weight-bold m-0">Cantidad de servicios totales</h6>
                                    </div>
                                </div>
                            </div>

                            <div class="card-body pb-3">
                                <table class="table table-flush">
                                    <thead class="bg-grey-10">
                                    <tr>
                                        <th class="text-xs">Servicios escogidos</th>
                                        <th class="text-xs text-center">Vuelve a casa</th>
                                        <th class="text-xs text-center">Siempre Juntos</th>
                                        {{--                                        <th class="text-xs text-center">Vuelve Cenizas</th>--}}
                                        <th class="text-xs text-center">Vets</th>
                                        <th class="text-xs text-center">Total</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <tr>
                                        <td class="text-xs">2023</td>
                                        @foreach($totalServiciosAnio as $item)
                                            @if($item->anio == 2023)
                                                <td class="text-xs text-center"> {{ $item->total }}</td>
                                            @endif
                                        @endforeach
                                        @foreach($totalServiciosAnioPorAnio as $item)
                                            @if($item->anio == 2023)
                                                <td class="text-xs text-center"> {{ $item->total }}</td>
                                            @endif
                                        @endforeach
                                    </tr>
                                    <tr>
                                        <td class="text-xs">2024</td>
                                        @foreach($totalServiciosAnio as $item)
                                            @if($item->anio == 2024)
                                                <td class="text-xs text-center"> {{ $item->total }}</td>
                                            @endif
                                        @endforeach
                                        @foreach($totalServiciosAnioPorAnio as $item)
                                            @if($item->anio == 2024)
                                                <td class="text-xs text-center"> {{ $item->total }}</td>
                                            @endif
                                        @endforeach
                                    </tr>
                                    <tr>
                                        <td class="text-xs">2025</td>
                                        @foreach($totalServiciosAnio as $item)
                                            @if($item->anio == 2025)
                                                <td class="text-xs text-center"> {{ $item->total }}</td>
                                            @endif
                                        @endforeach
                                        @foreach($totalServiciosAnioPorAnio as $item)
                                            @if($item->anio == 2025)
                                                <td class="text-xs text-center"> {{ $item->total }}</td>
                                            @endif
                                        @endforeach
                                    </tr>
                                    </tbody>
                                    <tfoot>
                                    <tr>
                                        <td class="text-xs">Total</td>
                                        @foreach($totalServiciosAnioPorServicio as $item)
                                            <td class="text-xs text-center"> {{ $item->total }}</td>
                                        @endforeach
                                    </tr>
                                    </tfoot>
                                </table>

                                <table class="table table-flush">
                                    <thead class="bg-grey-10">
                                    <tr>
                                        <th class="text-xs">Monto total a pagar</th>
                                        <th class="text-xs text-center">Vuelve a casa</th>
                                        <th class="text-xs text-center">Siempre Juntos</th>
                                        {{--                                        <th class="text-xs text-center">Vuelve Cenizas</th>--}}
                                        <th class="text-xs text-center">Vets</th>
                                        <th class="text-xs text-center">Total</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <tr>
                                        <td class="text-xs">2023</td>
                                        @foreach($montosPorServicio as $item)
                                            @if($item->anio == 2023)
                                                <td class="text-xs text-center"> S./ {{ $item->total_monto }}</td>
                                            @endif
                                        @endforeach
                                        @foreach($totalMontoPorAnio as $item)
                                            @if($item->anio == 2023)
                                                <td class="text-xs text-center"> S./ {{ $item->total_monto }}</td>
                                            @endif
                                        @endforeach
                                    </tr>
                                    <tr>
                                        <td class="text-xs">2024</td>
                                        @foreach($montosPorServicio as $item)
                                            @if($item->anio == 2024)
                                                <td class="text-xs text-center"> S./ {{ $item->total_monto }}</td>
                                            @endif
                                        @endforeach
                                        @foreach($totalMontoPorAnio as $item)
                                            @if($item->anio == 2024)
                                                <td class="text-xs text-center"> S./ {{ $item->total_monto }}</td>
                                            @endif
                                        @endforeach
                                    </tr>
                                    <tr>
                                        <td class="text-xs">2025</td>
                                        @foreach($montosPorServicio as $item)
                                            @if($item->anio == 2025)
                                                <td class="text-xs text-center"> S./ {{ $item->total_monto }}</td>
                                            @endif
                                        @endforeach
                                        @foreach($totalMontoPorAnio as $item)
                                            @if($item->anio == 2025)
                                                <td class="text-xs text-center"> S./ {{ $item->total_monto }}</td>
                                            @endif
                                        @endforeach
                                    </tr>
                                    </tbody>
                                    <tfoot>
                                    <tr>
                                        <td class="text-xs">Total</td>
                                        @foreach($totalMontoPorServicio as $item)
                                            <td class="text-xs text-center"> S./ {{ $item->total_monto }}</td>
                                        @endforeach
                                    </tr>
                                    </tfoot>
                                </table>


                            </div>
                        </div>
                    </div>

                    <div class="col-12">
                        <div class="card mb-4">
                            <div class="card-header pb-0">
                                <div class="row">
                                    <div class="col-xl-9">
                                        <h6 class="font-weight-bold m-0">Cantidad de servicios en el mes vs el mes anterior</h6>
                                    </div>
                                </div>
                            </div>

                            <div class="card-body pb-3">
                                <table class="table table-flush">
                                    <thead class="bg-grey-10">
                                    <tr>
                                        <th class="text-xs text-center"></th>
                                        <th class="text-xs text-center" colspan="12">Meses</th>
                                    </tr>
                                    <tr>
                                        <th class="text-xs text-center">Año</th>
                                        <th class="text-xs text-center">1</th>
                                        <th class="text-xs text-center">2</th>
                                        <th class="text-xs text-center">3</th>
                                        <th class="text-xs text-center">4</th>
                                        <th class="text-xs text-center">5</th>
                                        <th class="text-xs text-center">6</th>
                                        <th class="text-xs text-center">7</th>
                                        <th class="text-xs text-center">8</th>
                                        <th class="text-xs text-center">9</th>
                                        <th class="text-xs text-center">10</th>
                                        <th class="text-xs text-center">11</th>
                                        <th class="text-xs text-center">12</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <tr>
                                        <td class="text-xs text-center">2023</td>
                                        @foreach($totalServiciosMes as $item)
                                            @if($item->anio == 2023)
                                                <td class="text-xs text-center"> {{ $item->total }}</td>
                                            @endif
                                        @endforeach
                                    </tr>
                                    <tr>
                                        <td class="text-xs text-center">2024</td>
                                        @foreach($totalServiciosMes as $item)
                                            @if($item->anio == 2024)
                                                <td class="text-xs text-center"> {{ $item->total }}</td>
                                            @endif
                                        @endforeach
                                    </tr>
                                    <tr>
                                        <td class="text-xs text-center">2025</td>
                                        @foreach($totalServiciosMes as $item)
                                            @if($item->anio == 2025)
                                                <td class="text-xs text-center"> {{ $item->total }}</td>
                                            @endif
                                        @endforeach
                                    </tr>
                                    </tbody>
                                    <tfoot>
                                    <tr>
                                        <td class="text-xs text-center">Total</td>
                                        @foreach($sumaTotalServiciosMes as $item)
                                            <td class="text-xs text-center"> {{ $item->total }}</td>
                                        @endforeach
                                    </tr>
                                    </tfoot>
                                </table>

                            </div>
                        </div>
                    </div>


                    <div class="col-12">
                        <div class="card mb-4">
                            <div class="card-header pb-0">
                                <div class="row">
                                    <div class="col-xl-9">
                                        <h6 class="font-weight-bold m-0">Cantidad de ingresos de dinero del mes vs el mes pasado</h6>
                                    </div>
                                </div>
                            </div>

                            <div class="card-body pb-3">

                                <table class="table table-flush">
                                    <thead class="bg-grey-10">
                                    <tr>
                                        <th class="text-xs text-center"></th>
                                        <th class="text-xs text-center" colspan="12">Meses</th>
                                    </tr>
                                    <tr>
                                        <th class="text-xs text-center">Monto total a pagar</th>
                                        <th class="text-xs text-center">1</th>
                                        <th class="text-xs text-center">2</th>
                                        <th class="text-xs text-center">3</th>
                                        <th class="text-xs text-center">4</th>
                                        <th class="text-xs text-center">5</th>
                                        <th class="text-xs text-center">6</th>
                                        <th class="text-xs text-center">7</th>
                                        <th class="text-xs text-center">8</th>
                                        <th class="text-xs text-center">9</th>
                                        <th class="text-xs text-center">10</th>
                                        <th class="text-xs text-center">11</th>
                                        <th class="text-xs text-center">12</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <tr>
                                        <td class="text-xs text-center">2023</td>
                                        @foreach($montosPorMesMontosMensuales as $item)
                                            @if($item->anio == 2023)
                                                <td class="text-xs text-center"> {{ $item->total_monto }}</td>
                                            @endif
                                        @endforeach
                                    </tr>
                                    <tr>
                                        <td class="text-xs text-center">2024</td>
                                        @foreach($montosPorMesMontosMensuales as $item)
                                            @if($item->anio == 2024)
                                                <td class="text-xs text-center"> {{ $item->total_monto }}</td>
                                            @endif
                                        @endforeach
                                    </tr>
                                    <tr>
                                        <td class="text-xs text-center">2025</td>
                                        @foreach($montosPorMesMontosMensuales as $item)
                                            @if($item->anio == 2025)
                                                <td class="text-xs text-center"> {{ $item->total_monto }}</td>
                                            @endif
                                        @endforeach
                                    </tr>
                                    </tbody>
                                    <tfoot>
                                    <tr>
                                        <td class="text-xs text-center">Total</td>
                                        @foreach($montosTotalesPorMesGlobal as $item)
                                            <td class="text-xs text-center"> {{ $item->total_monto }}</td>
                                        @endforeach
                                    </tr>
                                    </tfoot>
                                </table>

                                <table class="table table-flush">
                                    <thead class="bg-grey-10">
                                    <tr>
                                        <th class="text-xs text-center"></th>
                                        <th class="text-xs text-center" colspan="12">2025</th>
                                    </tr>
                                    <tr>
                                        <th class="text-xs text-center">Monto total a pagar</th>
                                        <th class="text-xs text-center">1</th>
                                        <th class="text-xs text-center">2</th>
                                        <th class="text-xs text-center">3</th>
                                        <th class="text-xs text-center">4</th>
                                        <th class="text-xs text-center">5</th>
                                        <th class="text-xs text-center">6</th>
                                        <th class="text-xs text-center">7</th>
                                        <th class="text-xs text-center">8</th>
                                        <th class="text-xs text-center">9</th>
                                        <th class="text-xs text-center">10</th>
                                        <th class="text-xs text-center">11</th>
                                        <th class="text-xs text-center">12</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <tr>
                                        <td class="text-xs text-center">Vuelve a casa</td>
                                        @foreach($montosTotalesPorAnio as $item)
                                            @if($item->id_servicio == 1)
                                                <td class="text-xs text-center"> {{ $item->total_monto }}</td>
                                            @endif
                                        @endforeach
                                    </tr>
                                    <tr>
                                        <td class="text-xs text-center">Siempre Juntos</td>
                                        @foreach($montosTotalesPorAnio as $item)
                                            @if($item->id_servicio == 2)
                                                <td class="text-xs text-center"> {{ $item->total_monto }}</td>
                                            @endif
                                        @endforeach
                                    </tr>
                                    {{--                                    <tr>--}}
                                    {{--                                        <td class="text-xs text-center">Vuelve Cenizas</td>--}}
                                    {{--                                        @foreach($montosTotalesPorAnio as $item)--}}
                                    {{--                                            @if($item->id_servicio == 3)--}}
                                    {{--                                                <td class="text-xs text-center"> {{ $item->total_monto }}</td>--}}
                                    {{--                                            @endif--}}
                                    {{--                                        @endforeach--}}
                                    {{--                                    </tr>--}}
                                    <tr>
                                        <td class="text-xs text-center">Vets</td>
                                        @foreach($montosTotalesPorAnio as $item)
                                            @if($item->id_servicio == 4)
                                                <td class="text-xs text-center"> {{ $item->total_monto }}</td>
                                            @endif
                                        @endforeach
                                    </tr>
                                    </tbody>
                                    <tfoot>
                                    <tr>
                                        <td class="text-xs text-center">Total</td>
                                        @foreach($montosTotalesPorMesGlobal as $item)
                                            <td class="text-xs text-center"> {{ $item->total_monto }}</td>
                                        @endforeach
                                    </tr>
                                    </tfoot>
                                </table>

                            </div>
                        </div>
                    </div>


                </div>
            </div>
            <!-- Alarm -->
            <div class="col-xl-3 col-lg-3 col-md-6">
                <div class="card bg-secondary text-white mb-4">
                    <div class="card-header pb-2">
                        <h5 class="text-white">Recordatorio</h5>
                    </div>

                    <div class="card-body pt-0">
                        <div class="row">
                            <div class="col-2 text-white">
                                <svg width="40" height="47" viewBox="0 0 40 47" fill="none"
                                     xmlns="http://www.w3.org/2000/svg">
                                    <path d="M0 17H40V42C40 44.7614 37.7614 47 35 47H5C2.23858 47 0 44.7614 0 42V17Z"
                                          fill="white" fill-opacity="0.05"/>
                                    <path
                                        d="M0.5 17.5H39.5V42C39.5 44.4853 37.4853 46.5 35 46.5H5C2.51472 46.5 0.5 44.4853 0.5 42V17.5Z"
                                        stroke="white" stroke-opacity="0.5"/>
                                    <path d="M0 5C0 2.23858 2.23858 0 5 0H35C37.7614 0 40 2.23858 40 5V18H0V5Z"
                                          fill="white"/>
                                    <path
                                        d="M13.56 41V27.8H10.74V26.1H15.54V41H13.56ZM25.8167 41V37.56H18.4967V35.94L25.7767 26.1H27.6567V35.94H29.5967V37.56H27.6567V41H25.8167ZM19.9767 36.64L19.6967 35.94H25.8167V27.74L26.3967 27.9L19.9767 36.64Z"
                                        fill="white"/>
                                    <path
                                        d="M12.39 13.12C11.9167 13.12 11.4833 13.0333 11.09 12.86C10.6967 12.68 10.3633 12.4367 10.09 12.13C9.81667 11.8233 9.62 11.48 9.5 11.1L10.35 10.75C10.53 11.23 10.7967 11.6 11.15 11.86C11.51 12.1133 11.93 12.24 12.41 12.24C12.7033 12.24 12.96 12.1933 13.18 12.1C13.4 12.0067 13.57 11.8767 13.69 11.71C13.8167 11.5367 13.88 11.3367 13.88 11.11C13.88 10.7967 13.79 10.55 13.61 10.37C13.4367 10.1833 13.18 10.0433 12.84 9.95L11.47 9.53C10.93 9.36333 10.5167 9.1 10.23 8.74C9.94333 8.38 9.8 7.96667 9.8 7.5C9.8 7.09333 9.89667 6.73667 10.09 6.43C10.29 6.11667 10.5633 5.87333 10.91 5.7C11.2633 5.52 11.6633 5.43 12.11 5.43C12.5567 5.43 12.96 5.51 13.32 5.67C13.6867 5.83 13.9967 6.04667 14.25 6.32C14.5033 6.58667 14.69 6.89333 14.81 7.24L13.97 7.59C13.81 7.17 13.57 6.85333 13.25 6.64C12.93 6.42 12.5533 6.31 12.12 6.31C11.8533 6.31 11.6167 6.35667 11.41 6.45C11.21 6.53667 11.0533 6.66667 10.94 6.84C10.8333 7.00667 10.78 7.20667 10.78 7.44C10.78 7.71333 10.8667 7.95667 11.04 8.17C11.2133 8.38333 11.4767 8.54667 11.83 8.66L13.08 9.03C13.6667 9.21 14.11 9.46667 14.41 9.8C14.71 10.1333 14.86 10.5467 14.86 11.04C14.86 11.4467 14.7533 11.8067 14.54 12.12C14.3333 12.4333 14.0433 12.68 13.67 12.86C13.3033 13.0333 12.8767 13.12 12.39 13.12ZM17.6184 13.12C17.265 13.12 16.9517 13.0567 16.6784 12.93C16.4117 12.7967 16.2017 12.6167 16.0484 12.39C15.895 12.1567 15.8184 11.89 15.8184 11.59C15.8184 11.3033 15.8784 11.0467 15.9984 10.82C16.125 10.5867 16.3184 10.39 16.5784 10.23C16.845 10.07 17.1784 9.95667 17.5784 9.89L19.5784 9.56V10.34L17.7884 10.64C17.4417 10.7 17.1884 10.81 17.0284 10.97C16.875 11.13 16.7984 11.3267 16.7984 11.56C16.7984 11.78 16.885 11.9633 17.0584 12.11C17.2384 12.2567 17.4617 12.33 17.7284 12.33C18.0684 12.33 18.3617 12.26 18.6084 12.12C18.8617 11.9733 19.0584 11.7767 19.1984 11.53C19.345 11.2833 19.4184 11.01 19.4184 10.71V9.34C19.4184 9.04667 19.3084 8.81 19.0884 8.63C18.875 8.44333 18.5917 8.35 18.2384 8.35C17.9317 8.35 17.6584 8.43 17.4184 8.59C17.185 8.74333 17.0117 8.95 16.8984 9.21L16.0884 8.79C16.1884 8.54333 16.3484 8.32333 16.5684 8.13C16.7884 7.93 17.045 7.77333 17.3384 7.66C17.6317 7.54667 17.9384 7.49 18.2584 7.49C18.6717 7.49 19.035 7.57 19.3484 7.73C19.6617 7.88333 19.905 8.1 20.0784 8.38C20.2584 8.65333 20.3484 8.97333 20.3484 9.34V13H19.4384V11.98L19.6084 12.04C19.495 12.2533 19.3417 12.44 19.1484 12.6C18.955 12.76 18.7284 12.8867 18.4684 12.98C18.2084 13.0733 17.925 13.12 17.6184 13.12ZM17.7984 6.6L18.5884 5.02H19.8484L18.7284 6.6H17.7984ZM24.5803 13.12C24.147 13.12 23.7503 13.0233 23.3903 12.83C23.037 12.6367 22.7636 12.3633 22.5703 12.01L22.7003 11.85V13H21.7903V5.43H22.7203V8.77L22.5803 8.54C22.7803 8.22 23.0536 7.96667 23.4003 7.78C23.747 7.58667 24.1436 7.49 24.5903 7.49C25.097 7.49 25.5503 7.61333 25.9503 7.86C26.357 8.10667 26.677 8.44333 26.9103 8.87C27.1436 9.29 27.2603 9.77 27.2603 10.31C27.2603 10.8367 27.1436 11.3133 26.9103 11.74C26.677 12.1667 26.357 12.5033 25.9503 12.75C25.5503 12.9967 25.0936 13.12 24.5803 13.12ZM24.5103 12.22C24.8503 12.22 25.1536 12.1367 25.4203 11.97C25.687 11.8033 25.8936 11.5767 26.0403 11.29C26.1936 10.9967 26.2703 10.67 26.2703 10.31C26.2703 9.93667 26.1936 9.61 26.0403 9.33C25.8936 9.04333 25.687 8.81667 25.4203 8.65C25.1536 8.47667 24.8503 8.39 24.5103 8.39C24.1703 8.39 23.8636 8.47333 23.5903 8.64C23.3236 8.80667 23.1103 9.03667 22.9503 9.33C22.797 9.61667 22.7203 9.94333 22.7203 10.31C22.7203 10.67 22.797 10.9967 22.9503 11.29C23.1103 11.5767 23.3236 11.8033 23.5903 11.97C23.8636 12.1367 24.1703 12.22 24.5103 12.22ZM28.8598 13V11.8H29.8298V13H28.8598Z"
                                        fill="#3F9DA9"/>
                                </svg>
                            </div>
                            <div class="col-10 text-white">
                                @php
                                    $numeroRecordatoriosCosechas = count($objRecordatoriosCosechas);
                                    $numeroRecordatoriosEntregas = count($objRecordatoriosEntregas);
                                    $cantidadRecordatoriosCosechas = sprintf("%02d", $numeroRecordatoriosCosechas);
                                    $cantidadRecordatoriosEntregas = sprintf("%02d", $numeroRecordatoriosEntregas);

                                @endphp
                                @if (count($objRecordatoriosEntregas) > 0)
                                    <p class=" mb-0 text-white">Esta semana hay {{$cantidadRecordatoriosEntregas}} {{ $cantidadRecordatoriosEntregas > 2 ? 'entregas de mascotas' : 'entrega de mascota' }}
                                @else
                                    <p class=" mb-0 text-white">Esta semana no hay entregas de mascotas</p>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>

                <div class="card mb-4">
                    <div class="p-3 pb-2">
                        <p class="header-strong p-0">Total de Servicios completos</p>
                    </div>

                    <div class="card-body pt-0">
                        <div class="row">
                            <div class="col-9">
                                <h2 class="f-weight-50 black-main m-0">{{$totalServiciosCompletos}}</h2>
                                <p class="text-small">Servicios completos del mes</p>
                            </div>

                            <div class="col-3 mt-3">
                                <svg xmlns="http://www.w3.org/2000/svg" width="32" height="32" viewBox="0 0 32 32"
                                     fill="none">
                                    <rect width="32" height="32" rx="11" fill="#A2B260"/>
                                    <path
                                        d="M5 22C9.08569 22 8.14284 16.9714 11.6 16.9714C14.4459 16.9714 13.4857 19.4857 17.5714 19.4857C21.657 19.4857 21.3428 11 27.3142 11"
                                        stroke="white" stroke-width="2" stroke-linecap="round"/>
                                </svg>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card mb-4">
                    <div class="p-3 pb-2">
                        <p class="header-strong">Total de compost generado</p>
                        <div class="row">
                            <div class="col-9">
                                <h2 class="f-weight-50 black-main m-0">{{ $objCompostajesMes->sum('peso_cosecha') ?? '0' }}<span
                                        class="light-text">Kg.</span></h3>
                                    <p class="text-small">Compostaje del mes</p>
                            </div>

                            <div class="col-3  pt-3">
                                <svg xmlns="http://www.w3.org/2000/svg" width="34" height="34" viewBox="0 0 34 34"
                                     fill="none">
                                    <rect x="1" y="1" width="32" height="32" rx="11" fill="#3F9DA9"/>
                                    <rect x="0.5" y="0.5" width="33" height="33" rx="11.5" stroke="white"
                                          stroke-opacity="0.3"/>
                                    <path
                                        d="M11.6666 11.6666H22.3333M22.3333 11.6666V22.3333M22.3333 11.6666L11.6666 22.3333"
                                        stroke="white" stroke-width="2" stroke-linecap="round"
                                        stroke-linejoin="round"/>
                                </svg>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="card mb-4">
                    <div class="p-3 pb-2">
                        <p class="header-strong">Total de CO2 ahorrado</p>
                        <div class="row">
                            <div class="col-9">
                                <h2 class="f-weight-50 black-main m-0">{{$totalCO2Ahorrado}}<span
                                        class="light-text">Kg.</span></h3>
                                    <p class="text-small">Compostaje total del mes</p>
                            </div>

                            <div class="col-3  pt-3">
                                <img src="../assets/img/co2.svg" alt="">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card mb-4">
                    <div class="p-3 pb-2">
                        <p class="header-strong mb-4">Cantidad de pedidos por distrito</p>
                        <table class="table table-flush">
                            <thead class="bg-grey-10">
                            <tr>
                                <th class="text-xs">Distrito</th>
                                <th class="text-xs text-center">Cantidad</th>
                            </tr>
                            </thead>
                            <tbody>
                            @foreach ($totalCantidadDistritos as $totalCantidadDistrito)
                                <tr>
                                    <td class="text-xs">{{ $totalCantidadDistrito->distrito }}</td>
                                    <td class="text-xs text-center">{{ $totalCantidadDistrito->cantidad_pedidos }}</td>
                                </tr>
                            @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>

                <div class="card mb-4">
                    <div class="p-3 pb-2">
                        <p class="header-strong mb-4">Cantidad por tipo de servicio</p>
                        <table class="table table-flush">
                            <thead class="bg-grey-10">
                            <tr>
                                <th class="text-xs">Mascota</th>
                                <th class="text-xs text-center">Cantidad</th>
                            </tr>
                            </thead>
                            <tbody>
                            @foreach ($cantidadTipoServicio as $item)
                                <tr>
                                    <td class="text-xs">
                                        @if ($item->rango_peso == "0-1 kg")
                                            Muy Pequeña (0-1 kg)
                                        @elseif ($item->rango_peso == "1-11 kg")
                                            Pequeña (1-11 kg)
                                        @elseif ($item->rango_peso == "11-25 kg")
                                            Mediana (11-25 kg)
                                        @elseif ($item->rango_peso == "25+ kg")
                                            Grande (25+ kg)
                                        @endif
                                    </td>
                                    <td class="text-xs text-center">{{ $item->total }}</td>
                                </tr>
                            @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>

                <div class="card mb-4">
                    <div class="p-3 pb-2">
                        <p class="header-strong">Promedio dias Inicio de Compostaje / Cosecha</p>
                        <div class="row">
                            <div class="col-9">
                                <h2 class="f-weight-50 black-main m-0">{{ number_format($promedioDiasInicioFin, 0) ?? '0' }}</h2>
                                <p class="text-small">Dias</p>
                            </div>

                            <div class="col-3  pt-3">
                                <svg xmlns="http://www.w3.org/2000/svg" width="34" height="34" viewBox="0 0 34 34"
                                     fill="none">
                                    <rect x="1" y="1" width="32" height="32" rx="11" fill="#3F9DA9"/>
                                    <rect x="0.5" y="0.5" width="33" height="33" rx="11.5" stroke="white"
                                          stroke-opacity="0.3"/>
                                    <path
                                        d="M11.6666 11.6666H22.3333M22.3333 11.6666V22.3333M22.3333 11.6666L11.6666 22.3333"
                                        stroke="white" stroke-width="2" stroke-linecap="round"
                                        stroke-linejoin="round"/>
                                </svg>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="card mb-4">
                    <div class="p-3 pb-2">
                        <p class="header-strong">Promedio dias Cosecha / Entrega al cliente</p>
                        <div class="row">
                            <div class="col-9">
                                <h2 class="f-weight-50 black-main m-0">{{ number_format($promedioDiasFinRecojosFin, 0) ?? '0' }}</h2>
                                <p class="text-small">Dias</p>
                            </div>

                            <div class="col-3  pt-3">
                                <svg xmlns="http://www.w3.org/2000/svg" width="34" height="34" viewBox="0 0 34 34"
                                     fill="none">
                                    <rect x="1" y="1" width="32" height="32" rx="11" fill="#3F9DA9"/>
                                    <rect x="0.5" y="0.5" width="33" height="33" rx="11.5" stroke="white"
                                          stroke-opacity="0.3"/>
                                    <path
                                        d="M11.6666 11.6666H22.3333M22.3333 11.6666V22.3333M22.3333 11.6666L11.6666 22.3333"
                                        stroke="white" stroke-width="2" stroke-linecap="round"
                                        stroke-linejoin="round"/>
                                </svg>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="card mb-4">
                    <div class="p-3 pb-2">
                        <p class="header-strong">Promedio dias Inicio de compostaje / Entrega al cliente</p>
                        <div class="row">
                            <div class="col-9">
                                <h2 class="f-weight-50 black-main m-0">{{ number_format($promedioDiasInicioFinRecojos, 0) ?? '0' }}</h2>
                                <p class="text-small">Dias</p>
                            </div>

                            <div class="col-3  pt-3">
                                <svg xmlns="http://www.w3.org/2000/svg" width="34" height="34" viewBox="0 0 34 34"
                                     fill="none">
                                    <rect x="1" y="1" width="32" height="32" rx="11" fill="#3F9DA9"/>
                                    <rect x="0.5" y="0.5" width="33" height="33" rx="11.5" stroke="white"
                                          stroke-opacity="0.3"/>
                                    <path
                                        d="M11.6666 11.6666H22.3333M22.3333 11.6666V22.3333M22.3333 11.6666L11.6666 22.3333"
                                        stroke="white" stroke-width="2" stroke-linecap="round"
                                        stroke-linejoin="round"/>
                                </svg>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>


    </div>
@endsection
