@extends('front.layouts.useradministrador')
@section('content')
    <div class="container-fluid py-4">
        @if (session('exito'))
            <div class="alert alert-success mb-5 white-color" role="alert">
                {{ session('exito') }}
            </div>
        @endif
        <!-- Navbar tabs Primary-->
        <div class="w-full d-none">
            <a href="{{ url('/admin/base-de-datos/vuelve-a-casa') }}" class="btn btn-success h-full py-3 col-3">Vuelve a
                Casa</a>
            <a href="{{ url('/admin/base-de-datos/plan-siempre-juntos') }}" class="btn btn-outline-dark py-3 col-3">Siempre Juntos</a>
            {{-- <a href="{{ url('/admin/base-de-datos/vuelve-ceniza') }}" class="btn btn-outline-dark h-full py-3">Vuelve Cenizas</a> --}}
            {{-- <a href="{{ url('/admin/base-de-datos/vuelve-solidario') }}" class="btn btn-outline-dark py-3">Vuelve Solidario</a> --}}
        </div>
        <div class="col-xl-12 my-4 d-flex justify-content-between">
            <h4 class="font-weight-bold mb-0">Base de datos - Vuelve a casa</h4>
            <a id="btnExportarCSV" class="btn btn-success f-weight-40 mb-0">Descargar Información</a>
        </div>
        <div class="table-responsive">
            <table class="table table-flush" id="datatable-search">
                <thead class="bg-grey-10">
                <tr>

                    <th class="text-xs text-center f-weight color-grey">N° de Pedido</th>
                    <th class="text-xs text-center f-weight color-grey">Año</th>
                    <th class="text-xs text-center f-weight color-grey">Fecha</th>
                    <th class="text-xs text-center f-weight color-grey">Mes</th>
                    <th class="text-xs text-center f-weight color-grey">Correo</th>
                    <th class="text-xs text-center f-weight color-grey">Nombres</th>
                    <th class="text-xs text-center f-weight color-grey">Apellidos</th>
                    <th class="text-xs text-center f-weight color-grey">DNI</th>
                    <th class="text-xs text-center f-weight color-grey">Celular</th>
                    <th class="text-xs text-center f-weight color-grey">Nombre de mascota</th>
                    <th style="min-width: 500px;" class="text-xs text-center f-weight color-grey">Comentarios/Detalle</th>
                    <th class="text-xs text-center f-weight color-grey">Tipo de servicio</th>
                    <th class="text-xs text-center f-weight color-grey">Servicio es de vet aliada</th>
                    <th class="text-xs text-center f-weight color-grey">Nombre Vet</th>
                    <th class="text-xs text-center f-weight color-grey">Tipo Mascota</th>
                    <th class="text-xs text-center f-weight color-grey">Fecha fallecimento</th>
                    <th class="text-xs text-center f-weight color-grey">Peso de mascota</th>
                    <th class="text-xs text-center f-weight color-grey">Distrito recojo</th>
                    <th class="text-xs text-center f-weight color-grey">Dirección</th>
                    <th class="text-xs text-center f-weight color-grey">Edad mascota</th>
                    <th class="text-xs text-center f-weight color-grey">Motivo muerte</th>
                    <th class="text-xs text-center f-weight color-grey">Horario recojo</th>
                    <th class="text-xs text-center f-weight color-grey">Dirección de entrega de planta</th>
                    <th class="text-xs text-center f-weight color-grey">Sexo de mi mascota</th>
                    <th class="text-xs text-center f-weight color-grey">Raza mascota</th>
                    <th class="text-xs text-center f-weight color-grey">Edad cliente</th>
                    <th class="text-xs text-center f-weight color-grey">Monto servicio</th>
                    <th class="text-xs text-center f-weight color-grey">Producto extra</th>
                    <th class="text-xs text-center f-weight color-grey">Movilidad cobrada a cliente</th>
                    <th class="text-xs text-center f-weight color-grey">Cobro extra x horario</th>
                    <th class="text-xs text-center f-weight color-grey">Descuentos o cobros adicionales</th>
                    <th class="text-xs text-center f-weight color-grey">Monto total a pagar</th>
                    <th class="text-xs text-center f-weight color-grey">Cantidad de cuotas</th>
                    <th class="text-xs text-center f-weight color-grey">Monto Cuota</th>
                    <th class="text-xs text-center f-weight color-grey">Fecha pago</th>
                    <th class="text-xs text-center f-weight color-grey">Tipo de pago</th>
                    <th class="text-xs text-center f-weight color-grey">Método Pago</th>
                    <th class="text-xs text-center f-weight color-grey">Boleta emitida y enviada</th>
                    <th class="text-xs text-center f-weight color-grey">Cuota 1</th>
                    <th class="text-xs text-center f-weight color-grey">Fecha</th>
                    <th class="text-xs text-center f-weight color-grey">Cuota 2</th>
                    <th class="text-xs text-center f-weight color-grey">Fecha</th>
                    <th class="text-xs text-center f-weight color-grey">Cuota 3</th>
                    <th class="text-xs text-center f-weight color-grey">Fecha</th>
                    <th class="text-xs text-center f-weight color-grey">Cuota 4</th>
                    <th class="text-xs text-center f-weight color-grey">Fecha</th>
                    <th class="text-xs text-center f-weight color-grey">Cuenta por cobrar</th>
                    <th class="text-xs text-center f-weight color-grey">Conductor encargado del recojo</th>
                    <th class="text-xs text-center f-weight color-grey">Conductor encargado de entrega planta</th>
                    <th class="text-xs text-center f-weight color-grey">Dirección de entrega de planta</th>
                    <th class="text-xs text-center f-weight color-grey">Tipo de compost</th>
                    <th class="text-xs text-center f-weight color-grey">Macetas extra</th>
                    <th class="text-xs text-center f-weight color-grey">Dije</th>
                    <th class="text-xs text-center f-weight color-grey">Llavero</th>
                    <th class="text-xs text-center f-weight color-grey">Acuarela</th>
                    <th class="text-xs text-center f-weight color-grey">Maceta papel</th>
                    <th class="text-xs text-center f-weight color-grey">Maceta con retrato</th>
                    <th class="text-xs text-center f-weight color-grey">Fecha inicio compost</th>
                    <th class="text-xs text-center f-weight color-grey">Fecha cosecha</th>
                    <th class="text-xs text-center f-weight color-grey">Fecha entrega</th>
                    <th class="text-xs text-center f-weight color-grey">Peso compost final (tamizado)</th>
                    <th class="text-xs text-center f-weight color-grey">Cómo te enteraste de nosotros</th>
                    <th class="text-xs text-center f-weight color-grey">Encuesta completada</th>
                    <th class="text-xs text-center f-weight color-grey">Cuenta Activada</th>
                    <th class="text-xs f-weight color-grey"><span class="text-thead">Opciones</span></th>
                </tr>
                </thead>
                <tbody>
                @foreach ( $objUsers as $key => $objUser)
                    @php
                        $pagosPedidoId = $objPagos->where('id_pedido_pago', $objUser->id_pedido);
                    @endphp
                    <tr>
                        <td class=" normal black-main text-xs text-center">{{$objUser->id_pedido}}</td>
                        <td class=" normal black-main text-xs text-center">{{ \Carbon\Carbon::parse($objUser->fecha_creacion)->format('Y') }}</td>
                        <td class=" normal black-main text-xs text-center">{{ \Carbon\Carbon::parse($objUser->fecha_creacion)->format('d-m-Y') }}</td>
                        <td class=" normal black-main text-xs text-center">{{ \Carbon\Carbon::parse($objUser->fecha_creacion)->locale('es')->translatedFormat('F') }}</td>
                        <td class=" normal black-main text-xs text-center">{{$objUser->email}}</td>
                        <td class=" normal black-main text-xs text-center">{{$objUser->nombres}}</td>
                        <td class=" normal black-main text-xs text-center">{{$objUser->apellidos}}</td>
                        <td class=" normal black-main text-xs text-center">{{$objUser->dni}}</td>
                        <td class=" normal black-main text-xs text-center">{{$objUser->celular}}</td>
                        <td class=" normal black-main text-xs text-center">{{$objUser->nombre_mascota}}</td>
                        <td style="width: 250px;"
                            class=" normal black-main text-xs text-center pedido-id-{{$objUser->id_pedido}}">
                            <form action="" method="POST" class="">
                                @csrf
                                <input type="hidden" class="text-center" name="id_pedido" id="id_pedido"
                                       value="{{$objUser->id_pedido}}">
                                <textarea name="comentario" disabled id="comentario" cols="30" rows="2"
                                          class="comentario form-control text-xs">{{$objUser->comentario_pedido}}</textarea>
                                <br/>
                                <button type="submit" style="width: 70px;float: right"
                                        class="btn mt-1 p-1 btn-xs btn-success d-none">Actualizar
                                </button>
                            </form>
                        </td>
                        <td class=" normal black-main text-xs text-center">Vuelve a casa</td>
                        <td class=" normal black-main text-xs text-center">Servicio es de vet aliada</td>
                        <td class=" normal black-main text-xs text-center">Nombre Vet</td>
                        <td class=" normal black-main text-xs text-center">{{$objUser->tipo_mascota}}</td>
                        <td class=" normal black-main text-xs text-center">{{ \Carbon\Carbon::parse($objUser->fecha_creacion)->format('d-m-Y') }}</td>
                        <td class=" normal d-none black-main text-xs text-center">{{$objUser->peso_mascota}}</td>
                        <td class=" normal black-main text-xs text-center">
                            @if ($objUser->peso_mascota < 1)
                                Muy Pequeña
                            @elseif ($objUser->peso_mascota > 1 && $objUser->peso_mascota < 11)
                                Pequeña
                            @elseif ($objUser->peso_mascota > 11 && $objUser->peso_mascota < 25)
                                Mediana
                            @elseif ($objUser->peso_mascota > 25)
                                Grande
                            @endif
                        </td>
                        <td class=" normal black-main text-xs text-center">{{$objUser->ida_distrito}}</td>
                        <td class=" normal black-main text-xs text-center">{{$objUser->ida_direccion}}</td>
                        <td class=" normal black-main text-xs text-center">{{$objUser->edad_mascota}}</td>
                        <td class=" normal black-main text-xs text-center">{{$objUser->muerte_mascota}}</td>
                        <td class=" normal black-main text-xs text-center">{{$objUser->ida_hora}}</td>
                        <td class=" normal black-main text-xs text-center">{{$objUser->vuelta_direccion}}</td>
                        <td class=" normal black-main text-xs text-center">{{$objUser->sexo_mascota}}</td>
                        <td class=" normal black-main text-xs text-center">{{$objUser->raza_mascota}}</td>
                        <td class=" normal black-main text-xs text-center">{{$objUser->edad}}</td>
                        <td class=" normal black-main text-xs text-center">
                            @foreach($pagosPedidoId as $pago)
                                @if($pago->tipo_pago == 'servicio')
                                    {{ $pago->pago_peso }}
                                @endif
                            @endforeach
                        </td>
                        <td class=" normal black-main text-xs text-center">
                            @php
                                $pago_extra = 0;
                            @endphp
                            @foreach($pagosPedidoId as $pago)
                                @php
                                    $pago_extra += $pago->pago_extra;
                                @endphp
                            @endforeach
                            {{ $pago_extra }}
                        </td>
                        <td class=" normal black-main text-xs text-center">
                            @foreach($pagosPedidoId as $pago)
                                @if($pago->tipo_pago == 'servicio')
                                    {{ $pago->costo_envio }}
                                @endif
                            @endforeach
                        </td>
                        <td class=" normal black-main text-xs text-center">
                            @foreach($pagosPedidoId as $pago)
                                @if($pago->tipo_pago == 'servicio')
                                    {{ $pago->costo_envio_hora }}
                                @endif
                            @endforeach
                        </td>
                        <td class=" normal black-main text-xs text-center">
                            @php
                                $pago_feeadicional = 0;
                            @endphp
                            @foreach($pagosPedidoId as $pago)
                                @php
                                    $pago_feeadicional += $pago->fee_adicional;
                                @endphp
                            @endforeach
                            {{ $pago_feeadicional }}
                        </td>
                        <td class=" normal black-main text-xs text-center">
                            @php
                                $total_pagar = 0;
                            @endphp
                            @foreach($pagosPedidoId as $pago)
                                @php
                                    $total_pagar += $pago->total_pagar;
                                @endphp
                            @endforeach
                            {{ $total_pagar }}
                        </td>
                        <td class=" normal black-main text-xs text-center">
                            @foreach($pagosPedidoId as $pago)
                                <p class="text-xs">{{ $pago->cantidad_cuotas }}</p>
                            @endforeach
                        </td>
                        <td class=" normal black-main text-xs text-center">
                            @foreach($pagosPedidoId as $pago)
                                @if($pago->tipo_pago == 'servicio')
                                    {{ $pago->pago_cuota_1 ?? ''}}
                                @endif
                            @endforeach
                        </td>
                        <td class=" normal black-main text-xs text-center">
                            @foreach($pagosPedidoId as $pago)
                                @if($pago->tipo_pago == 'servicio')
                                    @if(isset($pago->fecha_1_pago) && $pago->cantidad_cuotas  == 2)
                                        <p class="text-xs m-0">
                                            1. {{ $pago->fecha_1_pago ?? '' }}
                                        </p>
                                    @else
                                        {{ $pago->fecha_1_pago ?? '' }}
                                    @endif
                                    @if(isset($pago->fecha_2_pago) && $pago->cantidad_cuotas  == 2)
                                        <p class="text-xs m-0">
                                            2. {{ $pago->fecha_2_pago ?? '' }}
                                        </p>
                                    @endif
                                @endif
                            @endforeach
                        </td>
                        <td class=" normal black-main text-xs text-center">
                            @foreach($pagosPedidoId as $pago)
                                @if($pago->tipo_pago == 'servicio')
                                    {{ $pago->forma_pago }}
                                @endif
                            @endforeach
                        </td>

                        <td class=" normal black-main text-xs text-center">
                            @foreach($pagosPedidoId as $pago)
                                @if($pago->tipo_pago == 'servicio')
                                    {{ $pago->metodo_pago }}
                                @endif
                            @endforeach
                        </td>
                        <td class=" normal black-main text-xs text-center">
                            @if ($objUser->boleta)
                                Si
                            @else
                                No
                            @endif
                        </td>

                        <td class=" normal black-main text-xs text-center">
                            @foreach($pagosPedidoId as $pago)
                                @if($pago->tipo_pago == 'servicio')
                                    {{ $pago->pago_cuota_1 ?? ''}}
                                @endif
                            @endforeach
                        </td>
                        <td class=" normal black-main text-xs text-center">
                            @foreach($pagosPedidoId as $pago)
                                @if($pago->tipo_pago == 'servicio')
                                    {{ $pago->fecha_1_pago ?? '' }}
                                @endif
                            @endforeach
                        </td>
                        <td class=" normal black-main text-xs text-center">
                            @foreach($pagosPedidoId as $pago)
                                @if($pago->tipo_pago == 'servicio')
                                    {{ $pago->pago_cuota_2 ?? '' }}
                                @endif
                            @endforeach
                        </td>
                        <td class=" normal black-main text-xs text-center">
                            @foreach($pagosPedidoId as $pago)
                                @if($pago->tipo_pago == 'servicio')
                                    {{ $pago->fecha_2_pago ?? '' }}
                                @endif
                            @endforeach
                        </td>
                        <td class=" normal black-main text-xs text-center">
                            @foreach($pagosPedidoId as $pago)
                                @if($pago->tipo_pago == 'servicio')
                                    {{ $pago->pago_cuota_3 ?? '' }}
                                @endif
                            @endforeach
                        </td>
                        <td class=" normal black-main text-xs text-center">
                            @foreach($pagosPedidoId as $pago)
                                @if($pago->tipo_pago == 'servicio')
                                    {{ $pago->fecha_3_pago ?? '' }}
                                @endif
                            @endforeach
                        </td>

                        <td class=" normal black-main text-xs text-center">
                            @foreach($pagosPedidoId as $pago)
                                @if($pago->tipo_pago == 'servicio')
                                    {{ $pago->pago_cuota_4 ?? '' }}
                                @endif
                            @endforeach
                        </td>
                        <td class=" normal black-main text-xs text-center">
                            @foreach($pagosPedidoId as $pago)
                                @if($pago->tipo_pago == 'servicio')
                                    {{ $pago->fecha_4_pago ?? '' }}
                                @endif
                            @endforeach
                        </td>
                        <td class=" normal black-main text-xs text-center">
                            @php
                                $total_pagar = 0;
                                $pago_cuota_1 = 0;
                                $pago_cuota_2 = 0;
                            @endphp
                            @foreach($pagosPedidoId as $pago)
                                @php
                                    $total_pagar += $pago->total_pagar ?? 0;
                                    $pago_cuota_1 += $pago->pago_cuota_1 ?? 0;
                                    $pago_cuota_2 += $pago->pago_cuota_2 ?? 0;
                                @endphp
                            @endforeach
                            {{ $total_pagar - ($pago_cuota_1 + $pago_cuota_2) }}
                        </td>
                        <td class=" normal black-main text-xs text-center">{{$objUser->ida_condutor}}</td>
                        <td class=" normal black-main text-xs text-center">{{$objUser->vuelta_condutor}}</td>
                        <td class=" normal black-main text-xs text-center">{{$objUser->vuelta_direccion}}</td>
                        <td class=" normal black-main text-xs text-center">
                            @if ($objUser->id_tipo == 1)
                                Bolsa con el compost de mi mascota
                            @elseif ($objUser->id_tipo == 2)
                                Todo el compost de mi mascota
                            @elseif ($objUser->id_tipo == 3)
                                Donado a proyectos de forestación.
                            @endif
                        </td>

                        <td class=" normal black-main text-xs text-center">{{$objUser->total_producto_1}}</td>
                        <td class=" normal black-main text-xs text-center">{{$objUser->total_producto_4}}</td>
                        <td class=" normal black-main text-xs text-center">{{$objUser->total_producto_5}}</td>
                        <td class=" normal black-main text-xs text-center">{{$objUser->total_producto_2}}</td>
                        <td class=" normal black-main text-xs text-center">{{$objUser->total_producto_6}}</td>
                        <td class=" normal black-main text-xs text-center">{{$objUser->total_producto_3}}</td>


                        <td class=" normal black-main text-xs text-center">{{$objUser->inicio_fecha}}</td>
                        <td class=" normal black-main text-xs text-center">{{$objUser->fin_fecha}}</td>
                        <td class=" normal black-main text-xs text-center">{{$objUser->vuelta_fecha}}</td>
                        <td class=" normal black-main text-xs text-center">{{$objUser->peso_cosecha}}</td>

                        <td class=" normal black-main text-xs text-center">
                            {{$objUser -> encuesta_opcion}}
                            @php
                                $objUser -> encuesta_opcion == 'Otro' ?  print(' - '.$objUser -> encuesta_otro) : '' ;
                            @endphp
                        </td>

                        <td class=" normal black-main text-xs text-center">{{$objUser->encuesta_completada}}</td>
                        <td class=" normal black-main text-xs text-center">
                            @if ($objUser->pedido_activo == 1)
                                <div class=" rounded mt-1 p-1 bg-success text-white">Activo</div>
                            @else
                                <div class=" rounded mt-1 p-1 bg-light">Pendiente</div>
                            @endif
                        </td>
                        <td class="f-weight-50 black-main text-xs">
                            <p class=" text-xs">
                                <a style="width: 127px; float: right; margin-bottom: 5px" href="#"
                                   class="nav-link border rounded form-pedido"
                                   data-pedido="pedido-id-{{$objUser->id_pedido}}">
                                    <i class="ri-pencil-line" style="margin: 0 4px"></i>
                                    <span>Editar comentario</span>
                                </a>
                            </p>
                            <p class="m-0 text-xs">
                            <form action="" method="POST" class="">
                                @csrf
                                <input type="hidden" class="text-center" name="id_usuario" id="id_usuario"
                                       value="{{$objUser->id_usuario}}">
                                <input type="hidden" class="text-center" name="action" id="action" value="eliminar">
                                <button type="submit" style="width: 127px;float: right"
                                        class="text-white nav-link border rounded bg-danger">
                                    <i class="ri-delete-bin-line" style="margin: 0 4px"></i>
                                    <span>Eliminar pedido</span>
                                </button>
                            </form>
                            </p>
                        </td>
                    </tr>

                @endforeach

                </tbody>
            </table>

        </div>


    </div>

@endsection

