@extends('front.layouts.web')
@section('content')

    <section>
        <div class="page-header py-3">
            <form method="GET" action="{{ route('pago') }}" class="container">
                @if (isset($_GET['extra']))
                    @foreach ($_GET['extra'] as $product_id => $cantidad)
                        @if ($cantidad > 0)
                            <input type="hidden" name="extra[{{ $product_id }}]" value="{{ $cantidad }}">
                        @endif
                    @endforeach
                @endif
                @csrf
                <div class="row">
                    <div class="col-xl-6 col-lg-7 col-md-12">
                        <div class="my-4 card-header p-0 text-start">
                            <h1 class="semibold t-verde fs-4">Creando más vida con Vuelve</h1>
                        </div>
                        <div class="card card-plain p-0">
                            <div class="card-header p-0 text-start">
                                <h2 class="f-weight text-dark fs-4">Detalle de pago</h2>
                                <p class="mt-4 text-sm">Selecciona como quieres hacer tu pago</p>
                                <div class="row mt-4">
                                    <div class="col-md-4">
                                        <div class="rounded-pill bg-success-bj border mb-3 p-3"
                                             id="cambiarDireccionBtn2">
                                            <div class="form-check">
                                                <input class="form-check-input" type="radio" name="forma-pago"
                                                       id="forma-pago1" value="total" checked>
                                                <label class="form-check-label" for="forma-pago1">Pago Total</label>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="rounded-pill bg-success-bj border mb-3 p-3"
                                             id="cambiarDireccionBtn">
                                            <div class="form-check">
                                                <input class="form-check-input" type="radio" name="forma-pago"
                                                       id="forma-pago2" value="cuotas">
                                                <label class="form-check-label" for="forma-pago2">Pago en cuotas</label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div id="direccionExactaContainer" style="display: none;">
                                <div class="card-header pb-0 text-start">
                                    <h5 class="f-weight">Para el pago en cuotas</h5>
                                    <p class="text-dark mt-2">Se aplica un fee adicional del 10%.</p>
                                    <div class="row justify-content-between ">
                                        <div class="col-md-6 mb-3">
                                            <label for="exampleFormControlInput1" class="text-dark form-label m-0 mb-1">Seleccionar
                                                cuotas</label>
                                            <select class="form-select" id="numero-cuotas" name="numero-cuotas"
                                                    aria-label="Default select example">
                                                <option value="2" selected class="text-dark">2 cuotas</option>
                                                {{-- <option value="3" class="text-dark">3 cuotas</option>
                                                <option value="4" class="text-dark">4 cuotas</option> --}}
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="card-header pb-0 text-start mt-2">
                                    <h5 class="f-weight">Total a pagar</h5>
                                    <h2 class="normal f-weight text-dark">S/. <span
                                            class="total_pagocuotas-cuota">0</span></h2>
                                    <h5 class="f-weight">Cuotas</h5>
                                    <div class="row mt-2">
                                        @php $fecha = strtotime(date('Y-m-d')); @endphp
                                        @for ($i = 0; $i <= 2; $i++)
                                            <div class="col-6 col-sm-4  cuotax cuota-{{ $i }} hide
                            {{ $i == 1 ? 'seleccionado' : '' }}">
                                                <div class="rounded-3 border mb-3 bg-success-bj"
                                                     style="cursor: pointer;">
                                                    <div class="m-3">
                                                        <h1 class="semibold fs-6 text-secondary2">Cuota {{ $i }}</h1>
                                                        <h2 class="normal f-weight text-secondary2">S/. <span
                                                                class="costo-cuota"></span></h2>
                                                        <div class="d-flex mt-4">
                                                            <i class="me-2 fa-regular fa-calendar-days text-secondary2"></i>
                                                            <h5 class="fs-6 text-secondary2">{{ date('d/m/y', $fecha) }}</h5>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            @php
                                                $fecha = strtotime('+1 month', $fecha);
                                            @endphp
                                        @endfor
                                    </div>
                                </div>
                            </div>
                            <div class="card-header pb-0">
                                <div class="text-md-end text-sm-center mt-19" id="cambiarDireccionBtn3">
                                    <a type="button" href="{{ route('extras') }}"
                                       class="mx-1 btn btn-outline-dark btn-lg fs-6  semibold">Volver</a>
                                    <button type="submit" class="mx-1 btn btn-success c btn-lg fs-6 semibold ">
                                        Continuar
                                    </button>
                                </div>
                            </div>
                        </div>
                        <hr>
                        <div class="">
                            <div class="d-flex justify-content-between align-items-center">
                                <div
                                    class="text-center rounded-circle orden border border-success border-2 text-xs normal">
                                    <i class="t-verde fa-solid fa-check"></i></div>
                                <hr class="flex-grow-1 hr-v">
                                <div
                                    class="text-center rounded-circle orden border border-success border-2 text-xs normal">
                                    <i class="t-verde fa-solid fa-check"></i></div>
                                <hr class="flex-grow-1 hr-v">
                                <div
                                    class="text-center rounded-circle orden border border-success border-2 text-xs normal">
                                    <i class="t-verde fa-solid fa-check"></i></div>
                                <hr class="flex-grow-1 hr-v">
                                <div
                                    class="text-center rounded-circle orden border border-success border-2 text-xs normal">
                                    <i class="t-verde fa-solid fa-check"></i></div>
                                <hr class="flex-grow-1 hr-v">
                                <div
                                    class="text-center rounded-circle orden border border-success border-2 bg-success text-white text-xs normal">
                                    5
                                </div>
                                <hr class="flex-grow-1 hr-v">
                                <div class="text-center rounded-circle orden border text-xs normal">6</div>
                            </div>
                            <div class="d-flex justify-content-between align-items-center">
                                <h6 class="f-weight text-xs">Datos</h6>
                                <hr class="flex-grow-1 hr-t">
                                <h6 class="f-weight text-xs">Mascota</h6>
                                <hr class="flex-grow-1 hr-t">
                                <h6 class="f-weight text-xs">Recojo</h6>
                                <hr class="flex-grow-1 hr-t">
                                <h6 class="f-weight text-xs">Extras</h6>
                                <hr class="flex-grow-1 hr-t">
                                <h6 class="f-weight text-xs">Cuotas</h6>
                                <hr class="flex-grow-1 hr-t">
                                <h6 class="semibold text-xs text-secondary">Pago</h6>
                            </div>
                        </div>


                    </div>
                    <div class="col-1"></div>
                    <div class="col-xl-5 col-lg-7 col-md-12 h-100">
                        <div id="imgloquiero" class="my-auto pe-0 text-center justify-content-center flex-column">
                            <div
                                class="position-relative bg-success h-100 p-5 border-radius-lg d-flex flex-column justify-content-center overflow-hidden">
                                <div class="rounded-top bg-white-transparent">
                                    <div class="m-4">
                                        <div class="row justify-content-between">
                                            <div class="col-12">
                                                <h4 class="semibold text-start text-white">Resumen</h4>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="my-2">
                                    <img src="../.../../assets/img/mi-servicio.png" alt="">
                                </div>
                                <div class="mb-3 mx-4">
                                    <h4 class="semibold text-start text-white">Servicio <br>Vuelve a Casa</h4>
                                </div>
                                <div class="bg-white-transparent-2">
                                    <div class="p-4">
                                        <div class="row justify-content-between hide">
                                            <div class="col-6">
                                                <h6 class="normal text-start text-white">Servicio</h6>
                                            </div>
                                            <div class="col-4">
                                                <h6 class="normal text-start text-white text-end">
                                                    S/.{{ $precioServicio }}</h6>
                                                <input type="hidden" name="precio-servicio"
                                                       value="{{ $precioServicio }}">
                                            </div>
                                        </div>
                                        <div class="row justify-content-between">
                                            <div class="col-6">
                                                <h6 class="normal text-start text-white">Servicio</h6>
                                            </div>
                                            <div class="col-6">
                                                <h6 class="normal text-start text-white text-end">
                                                    S/.{{ $precioPeso }}</h6>
                                                <input type="hidden" name="precio-peso" value="{{ $precioPeso }}">
                                            </div>
                                        </div>
                                        <div class="row justify-content-between">
                                            <div class="col-6">
                                                <h6 class="normal text-start text-white">Extra</h6>
                                            </div>
                                            <div class="col-4">
                                                <h6 class="normal text-start text-white text-end">
                                                    S/.{{ $precioExtras }}</h6>
                                                <input type="hidden" name="precio-extra" value="{{ $precioExtras }}">
                                            </div>
                                        </div>
                                        <div class="row justify-content-between">
                                            <div class="col-6">
                                                <h6 class="normal text-start text-white">Extra por recojo</h6>
                                            </div>
                                            <div class="col-6">
                                                <h6 class="normal text-start text-white text-end">
                                                    S/.{{ $precioRecojo }}</h6>
                                                <input type="hidden" name="precio-recojo" value="{{ $precioRecojo }}">
                                                <input type="hidden" name="precio-diarecojo"
                                                       value="{{ $precioDiaRecojo }}">
                                                <input type="hidden" name="precio-horarecojo"
                                                       value="{{ $precioHoraRecojo }}">
                                                <input type="hidden" name="precio-distritorecojo"
                                                       value="{{ $precioDistritoRecojo }}">
                                                <input type="hidden" name="precio-igv" value="{{ $precioIgv }}">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="rounded-bottom bg-white-transparent">
                                    <div class="p-4">
                                        <div class="row align-items-center justify-content-between">
                                            <div class="col-6 d-flex">
                                                <h4 class="semibold text-start text-white m-0" id="texto-total">
                                                    Total</h4>
                                            </div>
                                            <div class="col-4">
                                                <h4 class="semibold text-start text-white text-end">
                                                    S/.<span id="costo-cuota">{{ $precioTotal }}</span>
                                                </h4>
                                                <input type="hidden" name="precio-total" id="precio-total"
                                                       value="{{ $precioTotal }}">
                                                <input type="hidden" name="precio-cuota" id="precio-cuota" value="0">
                                                <input type="hidden" name="fee-adicional" id="fee-adicional" value="0">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="pagoencuotas hide mt-5">
                                    <div class="">
                                        <div class="p-4">
                                            <div class="row justify-content-between">
                                                <div class="col-6">
                                                    <h6 class="normal text-start text-white semibold">Pago en
                                                        cuotas</h6>
                                                </div>
                                                <div class="col-6">
                                                    <h6 class="normal text-start text-white text-end">+10% <span
                                                            id="fee-adicional-text"></span></h6>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="rounded-bottom bg-white-transparent">
                                        <div class="p-4">
                                            <div class="row align-items-center justify-content-between">
                                                <div class="col-6 d-flex">
                                                    <h4 class="semibold text-start text-white m-0" id="texto-total">
                                                        Total a pagar</h4>
                                                </div>
                                                <div class="col-6 ">
                                                    <h4 class="semibold text-end text-white text-end">S/.<span
                                                            class="total_pagocuotas-cuota">0</span></h4>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="p-4">
                                        <div class="row justify-content-between">
                                            <div class="col-7">
                                                <h6 class="normal text-start text-white semibold">Pago de la 1º
                                                    cuota</h6>
                                            </div>
                                            <div class="col-5">
                                                <h6 class="normal text-start text-white text-end">S/. <span
                                                        class="costo-cuota">0</span></h6>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="rounded border border-light-subtle mt-5">
                                    <p class="normal m-3 fs-6 text-white">Muchas gracias por confiar en nosotros y ser
                                        parte de esta familia sostenible. 🌍♻</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </section>
@endsection
@section('scripts')
    <script>
        $(function () {
            const total = {{ $precioTotal }};
            $('input[name="forma-pago"]').change(function () {
                if ($('#forma-pago2').is(':checked')) {
                    $('#direccionExactaContainer').show();
                    $('.pagoencuotas').removeClass('hide');

                    $('.cuotax').addClass('hide');
                    let cuota = 2;
                    for (let i = 1; i <= cuota; i++) {
                        $('.cuota-' + i).removeClass('hide');
                    }
                    let totalConAumento = (total * 1.10).toFixed(); // Aumenta el total en un 10%
                    let costo_cuota = (totalConAumento / cuota).toFixed(); // Divide entre la cantidad de cuotas y redondea a 2 decimales
                    let fee_adicional = (totalConAumento - total).toFixed();
                    $('.costo-cuota').text(costo_cuota);
                    // $('#costo-cuota').text(costo_cuota);
                    $('#precio-cuota').val(costo_cuota);
                    // $('#texto-total').text('Total cuota 1 de '+cuota);
                    // $('#total_pagocuotas-cuota').text((totalConAumento).toFixed(2));
                    $('.total_pagocuotas-cuota').text(totalConAumento);
                    $('#precio-total').val(totalConAumento);
                    $('#fee-adicional').val(fee_adicional);
                    $('#fee-adicional-text').html('(S/.' + fee_adicional + ')');

                } else {
                    $('#precio-total').val(total);
                    $('#direccionExactaContainer').hide();
                    $('.pagoencuotas').addClass('hide');
                    $('#fee-adicional').val('');

                }
            })
            // const total = {{ $precioTotal }};
            // $('#numero-cuotas').change(function() {
            //   $('.cuotax').addClass('hide');
            //   let cuota = 2;
            //   for (let i = 1; i <= cuota; i++) {
            //     $('.cuota-' + i).removeClass('hide');
            //   }
            //   let totalConAumento = total * 1.10; // Aumenta el total en un 10%
            //   let costo_cuota = (totalConAumento / cuota).toFixed(2); // Divide entre la cantidad de cuotas y redondea a 2 decimales
            //   $('.costo-cuota').text(costo_cuota);
            //   $('#costo-cuota').text(costo_cuota);
            //   $('#precio-cuota').val(costo_cuota);
            //   $('#texto-total').text('Total cuota 1 de '+cuota);
            //   $('.total_pagocuotas-cuota').text(totalConAumento);
            // })
            // $('input[name="forma-pago"]').change(function() {
            //   if ($('#forma-pago1').is(':checked')) {
            //     $('.cuotax').addClass('hide');
            //     $('.costo-cuota').text(total);
            //     $('#costo-cuota').text(total);
            //     $('#precio-cuota').val(total);
            //     $('#texto-total').text('Total');
            //   }
            // })
        })
    </script>
@endsection
