<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePagosCuotasTable extends Migration
{
    public function up()
    {
        Schema::create('pagos_cuotas', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('id_pago');
            $table->tinyInteger('numero_cuota');
            $table->date('fecha_programada');
            $table->date('fecha_pagada')->nullable();
            $table->decimal('monto', 10, 2);
            $table->enum('estado', ['pendiente', 'pagado', 'fallido'])->default('pendiente');
            $table->string('boleta', 50)->nullable();
            $table->timestamps();

            $table->foreign('id_pago')->references('id')->on('pagos')->onDelete('cascade');
        });
    }

    public function down()
    {
        Schema::dropIfExists('pagos_cuotas');
    }
}
