<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateEmailsProgramadosTable extends Migration
{
    public function up()
    {
        Schema::create('emails_programados', function (Blueprint $table) {
            $table->id();

            // Clave foránea con convención estándar de Laravel
            $table->foreignId('user_id')->constrained('usuarios')->onDelete('cascade');

            $table->string('email');
            $table->string('tipo'); // seguimiento_1, seguimiento_2, etc.
            $table->json('data');
            $table->timestamp('enviar_en');
            $table->boolean('enviado')->default(false);

            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('emails_programados');
    }
}
