<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class RegistroCompra extends Mailable
{
    use Queueable, SerializesModels;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($argsMail)
    {
        $token_reset = $argsMail['token_reset'];
        $url = url('/cambiar-contrasena?token=' . $token_reset);
        $this->data = [
            'nombre_usuario' => $argsMail['nombre_usuario'],
            'nombre_mascota' => $argsMail['nombre_mascota'],
            'acompaniar_mascota' => $argsMail['acompaniar_mascota'],
            'token_reset' => $token_reset,
            'url' => $url
        ];
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this
            ->subject('Registro exitoso - Bienvenido a Vuelve Compostario')
            ->view('emails.registrar_compra_nuevo')
            ->with([
                'data' => $this->data
            ]);
    }
}
