<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class RecojoIdaPaso1 extends Mailable
{
    use Queueable, SerializesModels;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($argsMail)
    {
        $this->data = [
            'tiempo_llegada' => $argsMail['tiempo_llegada'],
            'email' => $argsMail['email']
        ];
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this
            ->subject('Nuestro conductor estará llegando a recoger a tu mascota')
            ->view('emails.recojo_ida_paso_1')
            ->with([
                'data' => $this->data
            ]);

    }
}
