<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class NoConfirmarAcompanamiento extends Mailable
{
    use Queueable, SerializesModels;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($argsMail)
    {
        $this->data = [
            'nombre_usuario' => $argsMail['nombre_usuario']
        ];
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this
                ->subject('Lamentablemente, en este momento no tenemos disponible el servicio de traslado de acompañantes')
                ->view('emails.noconfirmar_acompanamiento')
                ->with([
                    'data' => $this->data
                ]);
    }
}
