<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class EntregarBoleta extends Mailable
{
    use Queueable, SerializesModels;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($argsMail,$boletaPath)
    {
        $this->data = [
            'nombre_usuario' => $argsMail['nombre_persona']
        ];

        $this->boletaPath = $boletaPath; // Ruta del archivo adjunto
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this
                ->subject('Se ha enviado su boleta')
                ->view('emails.entregar_boleta')
                ->with([
                    'data' => $this->data
                ])
                ->attach($this->boletaPath, [
                    'as' => 'boleta.pdf', // Nombre del archivo adjunto
                    'mime' => 'application/pdf',
                ]);;
    }
}
