<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class ConfirmarAcompanamiento extends Mailable
{
    use Queueable, SerializesModels;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($argsMail)
    {
        $this->data = [
            'nombre_usuario' => $argsMail['nombre_usuario']
        ];
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this
                ->subject('Confirmamos que nuestro conductor podrá trasladarte a ti y hasta 3 acompañantes junto con tu mascota')
                ->view('emails.confirmar_acompanamiento')
                ->with([
                    'data' => $this->data
                ]);
    }
}
