<?php

namespace App\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;

// ← importante
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use App\Jobs\EnviarCorreoProgramado;

class RevisarCorreosPendientes implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public function handle()
    {
        Log::info("Revisando correos pendientes...");
        $pendientes = DB::table('emails_programados')
            ->where('enviar_en', '<=', now())
            ->where('enviado', 0)
            ->limit(100)
            ->get();

        foreach ($pendientes as $correo) {
            Log::info("Encolando correo para: {$correo->email}");

            dispatch(new EnviarCorreoProgramado(
                $correo->email,
                $correo->tipo,
                json_decode($correo->data, true),
                $correo->pedido_id
            ))->onQueue('emails');

            DB::table('emails_programados')
                ->where('id', $correo->id)
                ->update(['enviado' => 1]);
        }
    }
}
