<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use DB;
use Session;

// use Barryvdh\DomPDF\Facade\Pdf;
use Barryvdh\Snappy\Facades\SnappyPdf as PDF;
use Illuminate\Support\Facades\Mail;
use App\Mail\RegistroVisita;
use Illuminate\Support\Facades\Log;

use Illuminate\Support\Facades\Http;
use Carbon\Carbon;

// SDK de Mercado Pago
use MercadoPago;

//use Illuminate\Support\Facades\Log;


class UsuariosController extends Controller
{
    //
    public function handle(Request $request)
    {
        // Registra_todo en logs (solo en pruebas)
        Log::info('Webhook Mercado Pago recibido:', [
            'body' => $request->all()
        ]);

        // Procesar eventos
        $type = $request->input('type');
        $id = $request->input('data.id');

        if ($type === 'preapproval_payment') {
            // Aquí puedes consultar más info del pago
            // y guardar en la base de datos
            Log::info("Se cobró una cuota (ID de pago: $id)");
        }

        return response()->json(['status' => 'ok']);
    }

    public function admin_inicio(Request $request)
    {
        return view('admin.inicio');
    }

    public function admin_usuarios(Request $request)
    {
        return view('admin.usuarios');
    }

    public function bd_plan_siempre_juntos(Request $request)
    {
        return view('admin.bd_plan_siempre_juntos');
    }

    public function bd_vuelve_a_casa(Request $request)
    {
        return view('admin.bd_vuelve_a_casa');
    }

    public function bd_vuelve_ceniza(Request $request)
    {
        return view('admin.bd_vuelve_ceniza');
    }

    public function bd_vuelve_solidario(Request $request)
    {
        return view('admin.bd_vuelve_solidario');
    }

    public function mi_perfil(Request $request)
    {

        $user_id = $request->session()->get('user_id');

        $usuario = DB::table('usuarios')->where('id', $user_id)->first();
        if (!$usuario) {
            return redirect()->route('iniciar_sesion');
        }

        $usuario = DB::table('usuarios')->where('id', $user_id)->first();
        $mascota = DB::table('mascotas')->where('id_usuario', $user_id)->first();


        return view('front.usuario.mi_perfil', compact('usuario', 'mascota'));

        // return view('front.perfil', compact('precioServicio', 'precioExtras','precioTotal'));
    }

    public function mis_servicios(Request $request)
    {

        $user_id = $request->session()->get('user_id');

        $pagosPendiente = DB::table('pedidos')->where('id_usuario', $user_id)->where('estado_pedido', 0)->get();

//        @dd($pagosPendiente);

        $usuario = DB::table('usuarios')->where('id', $user_id)->first();
        if (!$usuario) {
            return redirect()->route('iniciar_sesion');
        }


        $usuario = DB::table('usuarios')->where('id', $user_id)->first();

        $pedidosRecientes = DB::table('pedidos')
            ->join('mascotas', 'mascotas.id_mascota', '=', 'pedidos.id_mascota')
            ->join('servicios', 'servicios.id_servicio', '=', 'pedidos.id_servicio')
            ->where('pedidos.id_usuario', $user_id)
            ->where('pedidos.estado_pedido', '<>', 5)->get();

        // @dd($pedidosRecientes);

        $pedidosCompletados = DB::table('pedidos')
            ->join('mascotas', 'mascotas.id_mascota', '=', 'pedidos.id_mascota')
            ->join('servicios', 'servicios.id_servicio', '=', 'pedidos.id_servicio')
            ->where('pedidos.estado_pedido', '=', 5)
            ->where('pedidos.id_usuario', $user_id)->get();

        // @dd($pedidosCompletados);


        return view('front.usuario.mis_servicios', compact('usuario', 'pedidosRecientes', 'pedidosCompletados', 'pagosPendiente'));

    }

    public function mis_servicios_id($id, Request $request)
    {

        $user_id = $request->session()->get('user_id');

        if (!$user_id) {
            return redirect()->route('iniciar_sesion');
        }


        if ($_POST) {
            $data = $request->all();
            // Comprobar si 'id_planta' está presente, si no, asignarle un valor vacío
            // $data['id_planta'] = isset($data['id_planta']) ? $data['id_planta'] : '';
//            @dd($data);

            if (isset($data['agendar-visita'])) {
                $argsVisita = [
                    'fecha_visita' => $data['visitascal'],
                    'horario' => $data['horario'],
                    'id_usuario' => $data['usuario'],
                    'id_mascota' => $data['mascota'],
                    'id_pedido' => $data['pedido'],
                ];

                DB::table('visitas')->insert($argsVisita);

                // {{-- $data['fecha_visita'],
                //     $data['horario'],
                //     $data['nombre_mascota'],
                //     $data['nombre_persona'] --}}

                $usuario = DB::table('usuarios')->where('id', $argsVisita['id_usuario'])->first();
                $fecha = Carbon::parse($data["visitascal"])->locale('es')->isoFormat('dddd D [de] MMMM YYYY');
                $hora = Carbon::parse($data["horario"])->format('h:i A');

                $argsMail = [
                    'fecha_visita' => $fecha,
                    'horario' => $hora,
                    'nombre_persona' => $usuario->nombres
                ];

                // @dd($argsMail);

                Mail::to($usuario->email)->send(new RegistroVisita($argsMail));

                return redirect()->route('mis_servicios_id', ['id' => $id])->with('exito', 'Se ha registrado la visita correctamente');
            }

            if (isset($data['proc-compostaje'])) {
                // "compostaje" => "15"
                // "proc-compostaje" => "proc-compostaje"
                // "con_entrega" => "3"
                DB::table('compostajes')->where('id_compostaje', $data['compostaje'])->update([
                    'id_tipo' => $data['tipo']
                ]);

                return redirect()->route('mis_servicios_id', ['id' => $id])->with('exito', 'Se ha guardado la información correctamente');
            }

            if (isset($data['recojo'])) {
                if (isset($data['recojo-ida'])) {

                    $recojo_ida = DB::table('recojos')->where('id_recojo', $data['id_recojo'])->first();

                    // @dd($recojo_ida);

                    DB::table('recojos')->where('id_recojo', $data['id_recojovuelta'])->update([
                        'fecha_recojo' => $data['fecha_recojo'],
                        'id_distrito' => $recojo_ida->id_distrito,
                        'direccion_recojo' => $recojo_ida->direccion_recojo,
                        'id_mascota' => $data['id_mascota'],
                        'estado' => 1
                    ]);

                } else {

                    DB::table('recojos')->where('id_recojo', $data['id_recojo'])->update([
                        'fecha_recojo' => $data['fecha_recojo'],
                        'id_distrito' => $data['distrito_recojo'],
                        'direccion_recojo' => $data['direccion_recojo'],
                        'id_mascota' => $data['id_mascota'],
                        'estado' => 1
                    ]);
                }

                return redirect()->route('mis_servicios_id', ['id' => $id])->with('exito', 'Se ha guardado la información correctamente');

            }

            if (isset($data['servicio']) && $data['servicio'] == 'servicio') {
                DB::table('pedidos_servicios')->where('pedido_id', $id)->where('producto_id', 1)->update([
                    'modelo' => $data['maceta-modelo'],
                    'planta' => $data['maceta-planta'],
                    'color1' => $data['maceta-color-1'],
                    'color2' => $data['maceta-color-2']
                ]);

            }
            if (isset($data['producto_id'])) {
                $file = $request->file('file');
                if ($file) {
                    $originalFileName = $file->getClientOriginalName();
                    $path = $file->storeAs('public/productos-extras', $originalFileName);
                } else {
                    $path = NULL;
                }


                DB::table('pedidos_productos')->where('pedido_id', $id)->where('producto_id', $data['producto_id'])->update([

                    'color1' => $data['color-1'] ?? null,
                    'color2' => $data['color-2'] ?? null,
                    'modelo' => $data['modelo'] ?? null,
                    'planta' => $data['planta'] ?? null,
                    'intensidad' => $data['intensidad'] ?? null,
                    'retrato' => $path,
                ]);
            }

            return redirect()->route('mis_servicios_id', ['id' => $id])->with('exito', 'Se ha guardado la información correctamente');
        }

        $usuario = DB::table('usuarios')->where('id', $user_id)->first();
        $pedido = DB::table('pedidos')->where('id_pedido', $id)->first();

//        $pagosPendiente = $pedido->pedido_activo;

//        @dd($pedido);

        $servicio = DB::table('servicios')->where('id_servicio', $pedido->id_servicio)->first();

        $pagosServicio = DB::table('pagos')
            ->where('tipo_pago', 'servicio')
            ->where('id_pedido_pago', $id)->first();
//         @dd($pagosServicio);


        $objPagosRaw = DB::table('pagos')
            ->where('pagos.id_pedido_pago', $pedido->id_pedido)
//            ->leftJoin('pagos_cuotas', 'pagos.id', '=', 'pagos_cuotas.id_pago')
            ->leftJoin('pagos_cuotas', 'pagos.id_cuota_pago', '=', 'pagos_cuotas.id_pago')
            ->leftJoin('pedidos', 'pedidos.id_pedido', '=', 'pagos.id_pedido_pago')
            ->leftJoin('servicios', 'servicios.id_servicio', '=', 'pedidos.id_servicio')
            ->select(
                'pagos.id as pago_id',
                'pagos.user_id',
                'pagos.id_pedido_pago',
                'pagos.id_cuota_pago',
                'pagos.tipo_pago',
                'pagos.cantidad_cuotas',
                'pagos.monto_servicio',
                'pagos.fee_adicional',
                'pagos.igv',
                'pagos.total_pagar',
                'pagos.costo_envio',
                'pagos.pago_extra',
                'pagos.metodo_pago',
                'pagos.pago_peso',
                'pagos.forma_pago',
                'pagos.estado',
                'pagos.prod_extras',
                'pagos.created_at',
                'pagos.updated_at',
                'pagos_cuotas.id as cuota_id',
                'pagos_cuotas.numero_cuota',
                'pagos_cuotas.fecha_programada',
                'pagos_cuotas.id_pago',
                'pagos_cuotas.fecha_pagada',
                'pagos_cuotas.monto as cuota_monto',
                'pagos_cuotas.boleta',
                'servicios.nombre_servicio'
            )
            ->get();

//        @dd($objPagosRaw);

        $pagosAgrupados = [];

        foreach ($objPagosRaw as $row) {
            $idPago = $row->pago_id;

            if (!isset($pagosAgrupados[$idPago])) {
                // Inicializa el pago
                $pagosAgrupados[$idPago] = [
                    'id' => $row->pago_id,
                    'user_id' => $row->user_id,
                    'id_pedido_pago' => $row->id_pedido_pago,
                    'tipo_pago' => $row->tipo_pago,
                    'cantidad_cuotas' => $row->cantidad_cuotas,
                    'monto_servicio' => $row->monto_servicio,
                    'fee_adicional' => $row->fee_adicional,
                    'id_cuota_pago' => $row->id_cuota_pago,
                    'igv' => $row->igv,
                    'pago_peso' => $row->pago_peso,
                    'total_pagar' => $row->total_pagar,
                    'costo_envio' => $row->costo_envio,
                    'pago_extra' => $row->pago_extra,
                    'metodo_pago' => $row->metodo_pago,
                    'prod_extras' => $row->prod_extras,
                    'forma_pago' => $row->forma_pago,
                    'estado' => $row->estado,
                    'created_at' => $row->created_at,
                    'updated_at' => $row->updated_at,
                    'cuotas' => [], // Aquí irán las cuotas
                ];
            }

            // Si hay cuota, añádela (puede ser null por el leftJoin)
            if ($row->id_cuota_pago !== null) {
                $pagosAgrupados[$idPago]['cuotas'][] = [
                    'id' => $row->cuota_id,
                    'id_pago' => $row->id_pago,
                    'numero_cuota' => $row->numero_cuota,
                    'fecha_programada' => $row->fecha_programada,
                    'fecha_pagada' => $row->fecha_pagada,
                    'monto' => $row->cuota_monto,
                    'boleta' => $row->boleta,
                ];
            }
        }

        // Si prefieres un array numérico
        $pagosFinal = array_values($pagosAgrupados);

//        @dd($pagosFinal);


        $pagosExtras = DB::table('pagos')->where('id_pedido_pago', $id)->where('tipo_pago', 'extra')->get();
//        @dd($pagosExtras);
        $pagosExtrasRaw = DB::table('pagos')
            ->where('pagos.id_pedido_pago', $pedido->id_pedido)
            ->where('tipo_pago', 'extra')
            ->leftJoin('pagos_cuotas', 'pagos.id', '=', 'pagos_cuotas.id_pago')
            ->get();

        $pagosExtrasAgrupados = [];

        foreach ($pagosExtrasRaw as $row) {
            $idPago = $row->id;

            if (!isset($pagosExtrasAgrupados[$idPago])) {
                $pagosExtrasAgrupados[$idPago] = [
                    'id' => $row->id,
                    'user_id' => $row->user_id,
                    'id_pedido_pago' => $row->id_pedido_pago,
                    'tipo_pago' => $row->tipo_pago,
                    'cantidad_cuotas' => $row->cantidad_cuotas,
                    'monto_servicio' => $row->monto_servicio,
                    'fee_adicional' => $row->fee_adicional,
                    'id_cuota_pago' => $row->id_cuota_pago,
                    'igv' => $row->igv,
                    'pago_peso' => $row->pago_peso,
                    'total_pagar' => $row->total_pagar,
                    'costo_envio' => $row->costo_envio,
                    'pago_extra' => $row->pago_extra,
                    'prod_extras' => $row->prod_extras,
                    'metodo_pago' => $row->metodo_pago,
                    'forma_pago' => $row->forma_pago,
                    'estado' => $row->estado,
                    'created_at' => $row->created_at,
                    'updated_at' => $row->updated_at,
                    'cuotas' => [],
                ];
            }

            if ($row->id_cuota_pago !== null) {
                $pagosExtrasAgrupados[$idPago]['cuotas'][] = [
                    'id' => $row->id,
                    'id_pago' => $row->id_pago,
                    'numero_cuota' => $row->numero_cuota,
                    'fecha_programada' => $row->fecha_programada,
                    'fecha_pagada' => $row->fecha_pagada,
                    'monto' => $row->monto,
                    'boleta' => $row->boleta,
                ];
            }
        }

        $pagosExtrasFinal = array_values($pagosExtrasAgrupados);

// Puedes verificarlo con:
//        @dd($pagosExtrasFinal);

        $recojo = DB::table('recojos')->where('id_recojo', $pedido->id_recojo_ida)->join('distritos', 'recojos.id_distrito', '=', 'distritos.id_distrito')->first();
        // @dd($recojo);

        $recojo_vuelta = DB::table('recojos')->where('id_recojo', $pedido->id_recojo_vuelta)->first();

        if ($recojo_vuelta) {

            $fechaRecojo = Carbon::parse($recojo_vuelta->fecha_recojo); // Fecha base


            $fechasCalendario = collect();

            for ($i = 1; $i <= 14; $i++) {
                $fechaRecojo->addDay();
                if (in_array($fechaRecojo->dayOfWeek, [5, 6])) { // 5 = Viernes, 6 = Sábado
                    $fechasCalendario->push($fechaRecojo->toDateString());
                }
            }
        } else {
            $fechasCalendario = "";
        }
        // @dd($recojo_vuelta);


        // OPCIONAL SI ES DESPUES DEL MIERCOLES

        // $fechaRecojo = Carbon::parse($recojo_vuelta->fecha_recojo); // Fecha base

        // // Si la fecha base es miércoles (3) o después en la semana, moverla al próximo lunes
        // if ($fechaRecojo->dayOfWeek >= 3) { // 3 = Miércoles
        //     $fechaRecojo->next(Carbon::MONDAY); // Mueve la fecha al próximo lunes
        // }

        // $fechasCalendario = collect();

        // for ($i = 0; $i < 14; $i++) {
        //     if (in_array($fechaRecojo->dayOfWeek, [5, 6])) { // 5 = Viernes, 6 = Sábado
        //         $fechasCalendario->push($fechaRecojo->toDateString());
        //     }
        //     $fechaRecojo->addDay();
        // }

        // OPCIONAL SI ES DESPUES DEL MIERCOLES

        $resultadofechasCalendario = json_encode($fechasCalendario);

        $mascota = DB::table('mascotas')->where('id_mascota', $pedido->id_mascota)->first();
        // $extras = [];
        // $extras_object = DB::table('pedidos_productos')->where('pedido_id', $id)->get();
        $extras = DB::table('pedidos_productos')->where('pedido_id', $id)->join('productos', 'pedidos_productos.producto_id', '=', 'productos.id_producto')->get();
        $pedidos_servicios = DB::table('pedidos_servicios')->where('pedido_id', $id)
            ->join('productos', 'pedidos_servicios.producto_id', '=', 'productos.id_producto')
            ->join('pagos', 'pedidos_servicios.pedido_id', '=', 'pagos.id_pedido_pago')->first();
        // $productos_seleccionado_maceta = DB::table('productos_seleccionado')->where('id_pedido', $id)->where('producto', 'maceta')->first();
        // $productos_seleccionado_planta = DB::table('productos_seleccionado')->where('id_pedido', $id)->where('producto', 'planta')->first();
//         @dd($pedidos_servicios);
        // $maceta = DB::table('maceta_modelo')->where('id_maceta', $pedidos_servicios->color1)->first();
        // $planta = DB::table('maceta_planta')->where('id_planta', $pedidos_servicios->planta)->first();

        // $productos = DB::table('productos')->join('productos_tipo','productos.tipo','=','productos_tipo.id_tipo')->get();
        $productos = DB::table('productos')->where('estado', 1)->get();
        $compostaje = DB::table('compostajes')->where('id_compostaje', $pedido->id_compostaje)->first();

        // @dd($compostaje);

        return view('front.usuario.mis_servicios_id', compact('usuario', 'resultadofechasCalendario', 'compostaje', 'recojo_vuelta', 'pedidos_servicios', 'servicio', 'pagosFinal', 'pagosExtrasFinal', 'pagosExtras', 'mascota', 'pedido', 'recojo', 'extras', 'servicio', 'productos'));

    }

    public function seguimientos(Request $request)
    {

        $user_id = $request->session()->get('user_id');

        $pagosPendiente = DB::table('pedidos')->where('id_usuario', $user_id)->where('estado_pedido', 0)->get();

//        @dd($pagosPendiente);

        $usuario = DB::table('usuarios')->where('id', $user_id)->first();
        if (!$usuario) {
            return redirect()->route('iniciar_sesion');
        }


        $usuario = DB::table('usuarios')->where('id', $user_id)->first();

        $pedidosRecientes = DB::table('pedidos')
            // ->join('mascotas', 'mascotas.id_mascota', '=', 'pedidos.id_mascota')
            ->join('mascotas', 'mascotas.id_mascota', '=', 'pedidos.id_mascota')
            ->join('servicios', 'servicios.id_servicio', '=', 'pedidos.id_servicio')
            ->where('pedidos.id_usuario', $user_id)->get();

        $pedidosCompletados = DB::table('pedidos')
            ->join('mascotas', 'mascotas.id_mascota', '=', 'pedidos.id_mascota')
            ->join('servicios', 'servicios.id_servicio', '=', 'pedidos.id_servicio')
            ->where('pedidos.id_usuario', $user_id)->get();


        return view('front.usuario.seguimientos', compact('usuario', 'pedidosRecientes', 'pedidosCompletados', 'pagosPendiente'));

    }

    public function seguimientos_id($id, Request $request)
    {


        $user_id = $request->session()->get('user_id');

        $usuario = DB::table('usuarios')->where('id', $user_id)->first();
        if (!$usuario) {
            return redirect()->route('iniciar_sesion');
        }

        $productosPedidos = DB::table('pedidos')->where('id_pedido', $id)
            ->leftJoin('pedidos_productos', 'pedidos.id_pedido', '=', 'pedidos_productos.pedido_id')
            ->join('productos', 'pedidos_productos.producto_id', '=', 'productos.id_producto')->get();
//            ->leftJoin('mascotas', 'pedidos.id_mascota', '=', 'mascotas.id_mascota')
//            ->leftJoin('servicios', 'pedidos.id_servicio', '=', 'servicios.id_servicio')
//            ->leftJoin('compostajes', 'pedidos.id_compostaje', '=', 'compostajes.id_compostaje')
//            ->leftJoin('pedidos_servicios', 'pedidos.id_pedido', '=', 'pedidos_servicios.pedido_id')
//            ->select('pedidos.*', 'usuarios.*', 'mascotas.*', 'servicios.*', 'pedidos_servicios.*', 'compostajes.*')
//            ->first();
//        @dd($productosPedidos);

        $pedido = DB::table('pedidos')
            ->where('id_pedido', $id)
            ->leftJoin('usuarios', 'pedidos.id_usuario', '=', 'usuarios.id')
            ->leftJoin('mascotas', 'pedidos.id_mascota', '=', 'mascotas.id_mascota')
            ->leftJoin('servicios', 'pedidos.id_servicio', '=', 'servicios.id_servicio')
            ->leftJoin('compostajes', 'pedidos.id_compostaje', '=', 'compostajes.id_compostaje')
            ->leftJoin('pedidos_servicios', 'pedidos.id_pedido', '=', 'pedidos_servicios.pedido_id')
            ->select('pedidos.*', 'usuarios.*', 'mascotas.*', 'servicios.*', 'pedidos_servicios.*', 'compostajes.*')
            ->first();

        // @dd($pedido);

        $recojo_ida = DB::table('recojos')->where('id_recojo', $pedido->id_recojo_ida)->first();
        // @dd($recojo_ida);

        $recojo_vuelta = DB::table('recojos')->where('id_recojo', $pedido->id_recojo_vuelta)->first();

        $compostaje = DB::table('compostajes')->where('id_compostaje', $pedido->id_compostaje)->first();


        return view('front.usuario.seguimientos_id', compact('pedido', 'recojo_vuelta', 'recojo_ida', 'compostaje', 'productosPedidos'));

        // return view('front.perfil', compact('precioServicio', 'precioExtras','precioTotal'));
    }

    public function editar_perfil(Request $request)
    {

        // $user_id = session('user_id');
        // $usuario = DB::table('usuarios')->where('idusuario', $user_id)->first();


        // return view('front.editar_perfil', compact('precioServicio', 'precioExtras','precioTotal'));
        return view('front.usuario.editar_perfil');
    }

    public function inicio(Request $request)
    {


        $user_id = $request->session()->get('user_id');

        $usuario = DB::table('usuarios')->where('id', $user_id)->first();
        if (!$usuario) {
            return redirect()->route('iniciar_sesion');
        }


        $usuario = DB::table('usuarios')->where('id', $user_id)->first();
        $pedidos = DB::table('pedidos')->join('mascotas', 'mascotas.id_mascota', '=', 'pedidos.id_mascota')->where('pedidos.id_usuario', $user_id)->get();
        $pagosPendiente = DB::table('pedidos')->where('id_usuario', $user_id)->where('pedido_activo', 0)->get();
        // $mascotas = DB::table('mascotas')->where('id_usuario', $user_id)->get();

//        @dd($pagosPendiente);


        return view('front.usuario.inicio', compact('usuario', 'pedidos', 'pagosPendiente'));
    }

    public function descargarPdf(Request $request)
    {
        // @dd($request);

        $nombre = $request->input('nombre');
        $peso = $request->input('peso');

        $pdf = Pdf::loadView('front.usuario.constancia', compact('nombre', 'peso'));

        return $pdf->download('constancia.pdf');
    }

    public function verPdf(Request $request)
    {

        $nombre = $request->query('nombre', 'Sin nombre'); // Valor por defecto si no viene el parámetro
        $peso = $request->query('peso', 'Sin apellido');

        // $pdf = Pdf::loadView('front.usuario.constancia', compact('nombre'));

        return view('front.usuario.constancia', compact('nombre', 'peso'));

        // $pdf = Pdf::loadView('front.usuario.constancia', compact('nombre', 'peso'));

        // return $pdf->download('constancia.pdf');


        // Mostrar el PDF en el navegador
        // return $pdf->stream('constancia.pdf');
    }

    public function verCuna(Request $request)
    {

        $nombre = $request->query('nombre', 'Sin nombre'); // Valor por defecto si no viene el parámetro
        $foto = $request->query('foto', 'Sin apellido');

        // $pdf = Pdf::loadView('front.usuario.constancia', compact('nombre'));

        return view('front.usuario.cuna-mascota', compact('nombre', 'foto'));

        // $pdf = Pdf::loadView('front.usuario.constancia', compact('nombre', 'peso'));

        // return $pdf->download('constancia.pdf');


        // Mostrar el PDF en el navegador
        // return $pdf->stream('constancia.pdf');
    }

    public function seleccionar_horario(Request $request)
    {
        // @dd($request);
        // Obtener la fecha enviada por AJAX
        $fechaSeleccionada = $request->input('fecha');
        $dia = $request->input('dia');

        // Si no hay fecha, devolver error
        if (!$fechaSeleccionada) {
            return response()->json(['error' => 'Fecha no proporcionada'], 400);
        }

        // Obtener horarios que ya tienen 3 reservas en esa fecha
        // $horariosOcupados = Visitas::whereDate('fecha', $fechaSeleccionada)
        //     ->select('horario', \DB::raw('count(*) as total'))
        //     ->groupBy('horario')
        //     ->having('total', '>=', 3)
        //     ->pluck('horario')
        //     ->toArray();

        $horariosOcupados = DB::table('visitas')
            ->whereDate('fecha_visita', $fechaSeleccionada)
            ->select('horario', DB::raw('count(*) as total'))
            ->groupBy('horario')
            ->having('total', '>=', 4)
            ->pluck('horario')
            ->toArray();

        // Lista de horarios disponibles

        if ($dia === '5') {
            $horariosDisponibles = [
                '11:00',
                '11:30',
                '12:00',
                '12:30',
                '14:00',
                '14:30',
                '15:00',
                '15:30'
            ];
        } else {
            $horariosDisponibles = [
                '10:00',
                '10:30',
                '11:00',
                '11:30',
                '12:00'
            ];
        }

        return response()->json([
            'horariosDisponibles' => $horariosDisponibles,
            'horariosOcupados' => $horariosOcupados
        ]);
    }

    public function pedidos_productos(Request $request)
    {

        $precioExtras = 0;
        $precioRecojo = 0;
        $precioPeso = 0;
        $precioServicio = 0;
        $preference_id = 0;

        $data = $request->all();

//        @dd($data);

        $pageId = $data['id'];

        if (isset($_GET['extra'])) {

            // @dd($_GET['extra']);
            // $data = json_encode($_GET);
            $productos_id = [];
            $productos = DB::table('productos')->where('estado', 1)->get();
            if ($productos) {
                foreach ($productos as $producto) {
                    $productos_id[$producto->id_producto] = $producto->precio;
                }
            }

            // return dd($data);
            $precioExtras = 0;
            if (isset($data['extra'])) {
                foreach ($data['extra'] as $id => $cantidad) {
                    $precio = $productos_id[$id] * $cantidad;
                    $precioExtras += $precio;
                }
            }
            // $data = $request->all();


        }


        $precioTotal = $precioExtras;

        $precioIgv = round($precioTotal * 0.18, 2);


        $data['precio-extra'] = $precioExtras;
        $data['precio-igv'] = $precioIgv;
        $data['precio-total'] = $precioTotal;


        $data = json_encode($data);

        // @dd($data);

        return view('front.servicio.pago_extras', compact('pageId', 'precioExtras', 'precioServicio', 'precioRecojo', 'precioTotal', 'precioIgv', 'precioPeso', 'data', 'preference_id'));
    }

    public function process_payment_extras(Request $request)
    {
        $user_id = $request->session()->get('user_id');

        // return dd($user_id);

        $data = $request->all();
//        @dd($data);
        // print_r($data);die;
//        $usuario = DB::table('usuarios')->where('id', $user_id)->first();

        // return dd($user_id);

        try {

            if ($data['token']) {

                MercadoPago\SDK::setAccessToken(config('services.mercadopago.access_token'));

                try {

                    $payment = new MercadoPago\Payment();
                    $payment->transaction_amount = $data['transaction_amount'];
                    $payment->token = $request->token;
                    $payment->description = "Compra de productos";
                    $payment->installments = (int)$request->installments;
                    $payment->payment_method_id = $request->payment_method_id;
                    $payment->issuer_id = (int)$request->issuer_id;

                    $payer = new MercadoPago\Payer();
                    $payerForm = $data['payer'];
                    $payer->email = $payerForm['email'];
                    $payer->identification = array(
                        "type" => $payerForm['identification']['type'],
                        "number" => $payerForm['identification']['number']
                    );
                    $payment->payer = $payer;
                    $payment->save();

                    if ($payment->id === null) {
                        $error_message = 'Unknown error cause';
                        if (isset($payment->error)) {
                            $error_message = $payment->error->message;
                        }
                        echo $error_message;
                        die;
                    }

                    $registro = $request->session()->get('registro');


                    if ($payment->status == 'approved') {
                        // ----------------- Pago aprobado

                        // Registro usuario
                        $user_id = Session::get('user_id');
                        $token_reset = time();

                        $pedido_id = $data['data']['id'];

                        $filteredExtras = array_filter($data['data']['extra'], function ($value) {
                            return intval($value) >= 1;
                        });


                        $argsPagos = [
                            'user_id' => $user_id,
                            'forma_pago' => 'total',
                            'id_pedido_pago' => $pedido_id,
                            'tipo_pago' => 'extra',
                            'metodo_pago' => 'mercado_pago',
                            'cantidad_cuotas' => 1,
                            'total_pagar' => $data['data']['precio-total'],
                            'igv' => $data['data']['precio-igv'],
                            'pago_extra' => $data['data']['precio-total'],
                            'prod_extras' => json_encode($filteredExtras),
                            'estado' => 'pagado',
                            'created_at' => now(),
                            'updated_at' => now(),
                        ];

                        $pagos_id = DB::table('pagos')->insertGetId($argsPagos);

                        // Registrar items extras
                        if (isset($data['data']['extra'])) {
                            foreach ($data['data']['extra'] as $producto_id => $cantidad) {
                                // $argsExtra = [
                                //   'pedido_id' => $pedido_id,
                                //   'producto_id' => $producto_id,
                                //   'cantidad' => $cantidad,
                                //   'created_at' => date('Y-m-d H:i:s')
                                // ];
                                // DB::table('pedidos_productos')->insert($argsExtra);
                                for ($i = 0; $i < $cantidad; $i++) {
                                    $argsExtra = [
                                        'pedido_id' => $pedido_id,
                                        'pago_id' => $pagos_id,
                                        'producto_id' => $producto_id,
                                        'cantidad' => 1, // Siempre 1 porque cada unidad será un registro
                                        'created_at' => date('Y-m-d H:i:s')
                                    ];

                                    // Insertamos una fila por cada unidad del producto
                                    DB::table('pedidos_productos')->insert($argsExtra);
                                }
                            }
                        }

                    }

                    $pagos_id = DB::table('pagos')->insertGetId($argsPagos);

                    DB::table('pagos_cuotas')->insert([
                        'id_pago' => $pagos_id,
                        'numero_cuota' => 1,
                        'fecha_programada' => date('Y-m-d H:i:s'),
                        'fecha_pagada' => date('Y-m-d H:i:s'),
                        'monto' => $data['data']['precio-total'],
                        'estado' => 'pagado',
                        'boleta' => null,
                        'created_at' => now(),
                        'updated_at' => now(),
                    ]);

                    $response = array(
                        "request" => $request,
                        "payment_id" => $payment->id,
                        "status" => $payment->status,
                        "status_detail" => $payment->status_detail,
                        "data" => $data,
                        "registro" => $registro
                    );

                    echo json_encode($response);

                    // $payment->transaction_amount = (float) $data['transaction_amount'];
                    // $payment->token = $data['token'];
                    // $payment->description = "Test Silk Shirt";
                    // $payment->installments = 1;
                    // $payment->payment_method_id = $data['payment_method_id'];
                    // $payment->payer = $data['payer'];

                    // $payment->save();

                    // echo $payment->status;
                    // echo json_encode($payment);

                    // Step 7: Handle exceptions
                } catch (MPApiException $e) {
                    echo "Status code: " . $e->getApiResponse()->getStatusCode() . "\n";
                    echo "Content: ";
                    var_dump($e->getApiResponse()->getContent());
                    echo "\n";
                } catch (\Exception $e) {
                    echo "Error: " . $e->getMessage();
                }
                die;

            } else {
                echo json_encode([
                    'id' => 0,
                    'status' => 'error',
                    'message' => 'No se encontró un plan, comunícate con soporte'
                ]);
            }

        } catch (\Exception $e) {
            print_r($e);
            die;
            echo json_encode([
                'id' => 0,
                'status' => 'error',
                'error' => json_encode($e),
                'message' => 'Hubo un error al validar el pago, puedes volver a intentarlo con otra tarjeta'
            ]);
        }
    }


}




