<?php

namespace App\Http\Controllers;

use App\Mail\RegistroConstanciaPago;
use App\Mail\RegistroCompra;
use App\Mail\RegistroUsuarioNuevo;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Session;


// SDK de Mercado Pago
use MercadoPago;


class ServicioNuevo extends Controller
{
    //
    public function registroServicioNuevo(Request $request)
    {


        $user_id = $request->session()->get('user_id');

//        $usuario = DB::table('usuarios')->where('id', $user_id)->first();

//        dd($user_id);

        $hora_actual = Carbon::now()->addHour()->format('H:i'); // Formato 24h (Ejemplo: "11:00")
        $hora_limite = "23:00"; // 10:00 PM en formato 24h

        $horarios = DB::table('horarios')->select('horario', 'id_horario', 'costo')->get()->filter(function ($horario) use ($hora_actual, $hora_limite) {
            $hora_inicio = Carbon::parse(trim(explode('-', $horario->horario)[0]));
            return $hora_inicio->between($hora_actual, $hora_limite);
        });

        $horario_first = $horarios->first();

        $pedido = DB::table('pedidos')->where('id_usuario', $user_id)->first();

        $recojo = DB::table('recojos')->where('id_recojo', $pedido->id_recojo_ida)->join('distritos', 'recojos.id_distrito', '=', 'distritos.id_distrito')->first();


        // @dd($horarios);


        return view('front.servicionuevo_vuelve_casa', compact('user_id', 'horarios', 'horario_first', 'recojo', 'user_id'));
    }

    public function registroServicioNuevoExtras(Request $request)
    {

        if ($_POST) {


            $data = $request->all();

//            @dd($data);

//                    "_token" => "1hjgN9ITA3ZHl8x4b9CptKx0vcZafc95nMBusfdA"
//          "id-usuario" => "2"
//          "servicio-vuelve" => "1"
//          "nombre_mascota" => "3232"
//          "tipo_mascota" => "Perr@"
//          "edad_mascota" => "32"
//          "sexo_mascota" => "Hembra"
//          "peso_mascota" => "3"
//          "raza_mascota" => "3"
//          "muerte_mascota" => "3"
//          "servicio-recojo" => "inmediato"
//          "dia-innmediato" => "2025-08-11"
//          "fecha_recojo" => null
//          "horario-innmediato" => "1"
//          "nuevaDireccion" => "false"
//          "distrito_recojo" => "38"
//          "direccion_recojo" => "Calle santa anita 233"
//          "acompaniar_mascota" => "false"
//          "traslado_mascota" => "propio"
//        ]

            if ($data['servicio-recojo'] == 'inmediato') {
                $data['hora_recojo'] = $data['horario-innmediato'];
                $data['fecha_recojo'] = $data['dia-innmediato'];
            }

            session(['registro' => $data]);
        }

        $data = $request->session()->all();

        $productos = DB::table('productos')->where('estado', 1)->get();

        return view('front.servicionuevo.extras', compact('productos'));
    }

    public function registroServicioNuevoCuotas(Request $request)
    {

        $precioExtras = 0;
        $precioRecojo = 0;
        $precioPeso = 0;
        $precioServicio = 0;

        $precioDiaRecojo = 0;
        $precioHoraRecojo = 0;
        $precioDistritoRecojo = 0;


        if (isset($_GET['extra'])) {

            $productos_id = [];

            $productos = DB::table('productos')->where('estado', 1)->get();

            // @dd($productos_id);

            if ($productos) {
                foreach ($productos as $producto) {
                    $productos_id[$producto->id_producto] = $producto->precio;
                }
            }

            $data = $request->all();
            // return dd($data);
            $precioExtras = 0;
            if (isset($data['extra'])) {
                foreach ($data['extra'] as $id => $cantidad) {
                    $precio = $productos_id[$id] * $cantidad;
                    $precioExtras += $precio;
                }
            }
        }

        $registro = $request->session()->get('registro');

        // @dd($registro);

        if ($registro['servicio-vuelve'] == 1) {
            $carbonDate = Carbon::parse($registro['fecha_recojo']);

            // Verificar si es domingo (domingo es 0 en Carbon)
            $esDomingo = $carbonDate->isSunday();
            $esSabado = $carbonDate->isSaturday();

            if ($esSabado || $esDomingo) {
                $precioDiaRecojo += 60;
            } else {
                $precioDiaRecojo += 0;
            }

        }

        if ($registro['servicio-vuelve'] == 2) {
            $precioHoraRecojo += 0;
        }

        if ($registro == null) return redirect()->route('registro');

        // @dd($registro);

        if ($registro['servicio-vuelve'] == 1) {
            $horario = DB::table('horarios')->where('id_horario', $registro['hora_recojo'])->first();
            if ($horario) {
                $precioHoraRecojo += $horario->costo;
            }
        }

        // if($registro['servicio-vuelve'] == 2){
        //   $precioRecojo += 0;
        // }


        $distrito = DB::table('distritos')->where('id_distrito', $registro['distrito_recojo'])->first();
        if ($distrito) {
            $precioDistritoRecojo += $distrito->costo;
        }

        if ($registro['peso_mascota'] < 11) {
            $precioPeso += 590;
        } elseif ($registro['peso_mascota'] > 11 && $registro['peso_mascota'] < 25) {
            $precioPeso += 690;
        } elseif ($registro['peso_mascota'] > 26) {
            $precioPeso += 790;
        }

        // $peso = DB::table('pesos')->where('id_peso', $registro['peso_mascota'])->first();
        // if ($peso) {
        //   $precioPeso += $peso->costo;
        // }

        $servicio = DB::table('servicios')->where('slug', $registro['servicio-vuelve'])->first();

        if ($servicio) {
            $precioServicio += $servicio->costo;
        }

        // $precioDiaRecojo = 0;
        // $precioHoraRecojo = 0;
        // $precioDistritoRecojo = 0;
        $precioRecojo += $precioDiaRecojo + $precioHoraRecojo + $precioDistritoRecojo;

        $precioTotal = $precioExtras + $precioPeso + $precioDiaRecojo + $precioHoraRecojo + $precioDistritoRecojo + $precioServicio;

        $precioIgv = round($precioTotal * 0.18, 2);


        return view('front.servicionuevo.cuotas', compact('precioExtras', 'precioPeso', 'precioDiaRecojo', 'precioHoraRecojo', 'precioDistritoRecojo', 'precioRecojo', 'precioServicio', 'precioTotal', 'precioIgv'));
    }

    public function registroServicioNuevoPago(Request $request)
    {
        // $data = $request->session()->all();
        // $dataJson = $request->query('data'); // Esto es un string JSON

        // return dd($dataJson);

        // $data = json_decode($_GET, true);
        // $data = json_decode($_GET, true);
        // $data = json_encode($_GET, true);

        $data = $request->all();

        // return dd($data);

        // $data = json_decode($dataJson, true)

        // return dd($data);

        // Agrega credenciales
        MercadoPago\SDK::setAccessToken(config('services.mercadopago.access_token'));

        // $preference = new MercadoPago\Preference();

        // $item = new MercadoPago\Item();
        // $item->title = 'Suscripción a mi sitio web';
        // $item->quantity = 1;
        // $item->price = $_GET['precio-total'];
        // $item->unit_price = $_GET['precio-total'];
        // $item->currency_id = 'PEN';
        // $preference->items = array($item);
        // $preference->save();

        // $preference_id = $preference->id;


        $formaDePago = $_GET['forma-pago'];

        // return dd($formaDePago);


        if ($formaDePago === "total") {
            $data['numero-cuotas'] = 0;
        }


        $data = json_encode($data, true);

        // return dd($data);

        $preference_id = 0;
        $precioCuota = $_GET['precio-cuota'];

        if ($precioCuota == 0) {
            $precioTotal = $_GET['precio-total'];
        } else {
            $precioTotal = $_GET['precio-cuota'];
        }

        $user_id = Session::get('user_id');

        if ($formaDePago === "total") {

            return view('front.servicionuevo.pago-total', compact('precioTotal', 'preference_id', 'data', 'user_id'));
        } else {
            return view('front.servicionuevo.pago-cuotas', compact('precioTotal', 'preference_id', 'data', 'user_id'));

        }

    }

    public function registroServicioNuevoPedidoRealizado(Request $request)
    {

        // $user_id = Session::get('user_id');
        $data = $request->all();
//        @dd($data);

        if ($_POST) {

            $data = $request->all();

//            @dd($data);
//            $usuario = DB::table('usuarios')->where('id', $registro['user_id'])->first();
//            $user_id = $registro['user_id'];
            $usuarioConstancia = \Illuminate\Support\Facades\DB::table('usuarios')
                ->where('id', $data['id_usuario'])
                ->first();

//            @dd($usuarioConstancia);

            $imagePaths = [];

            foreach ($request->file('foto_entrega') as $image) {
                $uniqueFileName = uniqid() . '_' . $image->getClientOriginalName();
                $imagePath = $image->storeAs('pagos-constancias', $uniqueFileName, 'public');

                DB::table('pagos_constancias')->insert([
                    'id_pago' => $data['id_pago'],
                    'id_pedido' => $data['id_pedido'],
                    'foto' => $imagePath,
                    'fecha_creacion' => now(),
                ]);

                $imagePaths[] = $imagePath; // <== Guardamos la ruta

            }


            $argsMailConstantancia = [
                'nombre_usuario' => $usuarioConstancia->nombres . ' ' . $usuarioConstancia->apellidos,
                'celular' => $usuarioConstancia->celular,
                'id_pedido' => $data['id_pedido'],
                'email' => $usuarioConstancia->email,
                'dni' => $usuarioConstancia->dni,
                'forma_pago' => 'Yape o Plim'
            ];

            Mail::to(config('mail.admin_address'))->send(new RegistroConstanciaPago($argsMailConstantancia, $imagePaths));

            return redirect()->route('inicio')->with('constancia', 'Se han enviado los comprobantes exitosamente. Nuestro equipo está validando los pagos.');

        }


        $pedido = DB::table('pedidos')
            ->where('id_pedido', $data['orden'])
            ->first();

        $pago = DB::table('pagos')
            ->where('id_pedido_pago', $data['orden'])
            ->first();


        return view('front.servicionuevo.pedido_realizado', compact('pedido', 'pago'));
    }

    public function registroServicioNuevoPaymentDeposito(Request $request)
    {
        // $user_id = $request->session()->get('user_id');

        // return dd($user_id);
        $registro = $request->session()->get('registro');
        $data = $request->all();
        // print_r($data);die;
        // @dd($registro);

        $data = json_decode($data['data'], true); // true para obtener array asociativo


        // $usuario = DB::table('usuarios')->where('id', $user_id)->first();

        // return dd($user_id);

        if ($data['_token']) {

            // print_r($payment);die;

            // ----------------- Pago aprobado
            // Registro usuario
            // $user_id = Session::get('user_id');

            $token_reset = time();

            $pagos_id = 'pago_' . uniqid();

            $usuario = DB::table('usuarios')->where('id', $registro['user_id'])->first();
            $user_id = $registro['user_id'];

//            dd($user_id);

            $argsUsuario = [
                'nombres' => $usuario->nombres,
                'apellidos' => $usuario->apellidos,
                'edad' => $usuario->edad,
                'celular' => $usuario->celular,
                'email' => $usuario->email,
                'dni' => $usuario->dni,
                'token_reset' => $token_reset,
                // 'contrasena' => sha1($registro['contrasena']),
            ];
            Session::put('argsUsuario', $argsUsuario);
            Session::put('user_id', $registro['user_id']);

            // Session::put('argsUsuario', $argsUsuario);
            // }

            // Registro mascota
            $argsMascota = [
                'nombre_mascota' => $registro['nombre_mascota'],
                'edad_mascota' => $registro['edad_mascota'],
                'peso_mascota' => $registro['peso_mascota'],
                'sexo_mascota' => $registro['sexo_mascota'],
                'raza_mascota' => $registro['raza_mascota'],
                'muerte_mascota' => $registro['muerte_mascota'],
                'id_usuario' => $user_id,
                'tipo_mascota' => $registro['tipo_mascota'],
                'fecha_creacion' => date('Y-m-d')
            ];
            $mascota_id = DB::table('mascotas')->insertGetId($argsMascota);

            // Registro recojo
            $argsRecojo = [
                'fecha_recojo' => $registro['fecha_recojo'],
                'id_horario' => $registro['hora_recojo'],
                'id_distrito' => $registro['distrito_recojo'],
                'direccion_recojo' => $registro['direccion_recojo'],
                'id_usuario' => $user_id,
                'id_mascota' => $mascota_id,
                'etapa' => 1,
                // Asignacion fija
                'estado' => 1,
                // 'estado_etapa' => 1,
//                'pedido_activo' => 0,
                'id_conductor' => 3,
                'conductor_confirmado' => 1,
            ];

            $recojo_ida_id = DB::table('recojos')->insertGetId($argsRecojo);
            // $argsRecojo["etapa"] = 2;
            // $recojo_vuelta_id = DB::table('recojos')->insertGetId($argsRecojo);

            // use Carbon\Carbon;
            $fechaBase = Carbon::parse(date('Y-m-d')); // Fecha actual
            $fechaNueva = $fechaBase->addWeeks(6); // Sumar 6 semanas
            $fechaFormateada = $fechaNueva->format('Y-m-d'); // Formato YYYY-MM-DD

            // echo $fechaFormateada;

            $argsCompostaje = [
                'id_mascota' => $mascota_id,
                'estado' => 1,
                // 'estado_etapa' => 0,
                // Asignacion fija
                'id_operario' => 1,
                'operario_confirmado' => 1,
                'fin_tentativo' => $fechaFormateada
            ];

            $compostaje_id = DB::table('compostajes')->insertGetId($argsCompostaje);

            // Registrar pedido
            $servicio = DB::table('servicios')->where('slug', $registro['servicio-vuelve'])->first();

            $argsPedido = [
                'estado_pedido' => 0,
                'id_servicio' => $registro['servicio-vuelve'], // Vuelve ceniza
                'id_recojo_ida' => $recojo_ida_id,
                // 'id_recojo_vuelta' => $recojo_vuelta_id,
                'id_mascota' => $mascota_id,
                'id_usuario' => $user_id,
                'id_compostaje' => $compostaje_id,
                // 'fecha_recojo' => $registro['fecha_recojo'],
                'id_horario' => $registro['hora_recojo'],
                'acompaniar_mascota' => $registro['acompaniar_mascota'],
                'traslado_mascota' => $registro['traslado_mascota'],
                // 'direccion_recojo' => $registro['direccion_recojo'],
                // 'con_entrega' => $registro['con_entrega'] == 'true' ? 1 : 0,
                'fecha_creacion' => date('Y-m-d H:i:s'),
                'pedido_activo' => 0,
            ];
            // if ($registro['nuevaDireccion'] == 'true') {
            //   $argsPedido['direccion_entrega'] = $registro['nueva_direccion'];
            // } else {
            //   $argsPedido['direccion_entrega'] = $registro['direccion_recojo'];
            // }
            $pedido_id = DB::table('pedidos')->insertGetId($argsPedido);


            $argsPagos = [
                'user_id' => $user_id,
                'monto_servicio' => $data['precio-servicio'],
                'id_pedido_pago' => $pedido_id,
                'id_cuota_pago' => $pagos_id,
                'forma_pago' => $data['forma-pago'],
                'tipo_pago' => 'servicio',
                'cantidad_cuotas' => 1,
                'total_pagar' => $data['precio-total'],
                'igv' => $data['precio-igv'],
                'costo_envio' => $data['precio-recojo'],
                'pago_extra' => $data['precio-extra'],
                'pago_peso' => $data['precio-peso'],
                'fee_adicional' => 0,
                'costo_envio_dia' => $data['precio-diarecojo'],
                'costo_envio_hora' => $data['precio-horarecojo'],
                'costo_envio_distrito' => $data['precio-distritorecojo'],
                'metodo_pago' => 'transferencia',
                'estado' => 'pagado',
                'created_at' => now(),
                'updated_at' => now()
                //'prod_extras' => json_encode($filteredExtras) ?? null
            ];

            if (isset($data['extra'])) {
                $filteredExtras = array_filter($data['extra'], function ($value) {
                    return intval($value) >= 1;
                });

                $argsPagos['prod_extras'] = json_encode($filteredExtras);

            }


//            if ($data['forma-pago'] == 'total') {
//                $argsPagos['pago_cuota_1'] = $data['precio-total'];
//            }
//
//            if ($data['forma-pago'] == 'cuotas') {
//                $fecha = strtotime('+1 month', strtotime(date('Y-m-d')));
//                $fecha_formateada = date('Y-m-d', $fecha);
//                $argsPagos['fecha_2_pago'] = $fecha_formateada;
//            }

            // @dd($argsPagos);

            $pagos_id_db = DB::table('pagos')->insertGetId($argsPagos);

            DB::table('pagos_cuotas')->insert([
                'id_pago' => $pagos_id,
                'numero_cuota' => 1,
                'fecha_programada' => now(),
                'fecha_pagada' => now(),
                'monto' => $data['precio-total'],
                'estado' => 'pendiente',
                'boleta' => null,
                'created_at' => now(),
                'updated_at' => now(),
            ]);


            // AQUI REVISAR
            $argsServicio = [
                'pedido_id' => $pedido_id,
                'producto_id' => 1,
                'servicio_id' => $registro['servicio-vuelve'],
//                'pedido_tipo' => 'servicio',
                'cantidad' => 1, // Siempre 1 porque cada unidad será un registro
                'created_at' => date('Y-m-d H:i:s')
            ];

            // Insertamos una fila por cada unidad del producto
            DB::table('pedidos_servicios')->insert($argsServicio);

            // if($servicio->id_servicio == 1 || $servicio->id_servicio == 3){

            // }


            // Registrar items extras
            if (isset($data['extra'])) {
                foreach ($data['extra'] as $producto_id => $cantidad) {
                    // $argsExtra = [
                    //   'pedido_id' => $pedido_id,
                    //   'producto_id' => $producto_id,
                    //   'cantidad' => $cantidad,
                    //   'created_at' => date('Y-m-d H:i:s')
                    // ];
                    // DB::table('pedidos_productos')->insert($argsExtra);
                    for ($i = 0; $i < $cantidad; $i++) {
                        $argsExtra = [
                            'pedido_id' => $pedido_id,
                            'producto_id' => $producto_id,
                            'servicio_id' => $registro['servicio-vuelve'],
//                            'pedido_tipo' => 'extras',
                            'cantidad' => 1, // Siempre 1 porque cada unidad será un registro
                            'created_at' => date('Y-m-d H:i:s')
                        ];

                        // Insertamos una fila por cada unidad del producto
                        DB::table('pedidos_productos')->insert($argsExtra);
                    }
                }
            }

            // if (!$user_id) {
            $argsMail = [
                'nombre_usuario' => $usuario->nombres . ' ' . $usuario->apellidos,
                'nombre_mascota' => $argsMascota['nombre_mascota'],
                'hora_recojo' => $registro['hora_recojo'],
                'acompaniar_mascota' => $argsPedido['acompaniar_mascota'],
                'token_reset' => $token_reset
            ];

            $argsMailUsuarioNuevo = [
                'nombre_usuario' => $usuario->nombres . ' ' . $usuario->apellidos,
                'celular' => $usuario->celular,
                'nombre_mascota' => $argsMascota['nombre_mascota'],
                'raza_mascota' => $argsMascota['raza_mascota'],
                'fecha_recojo' => $registro['fecha_recojo'],
                'id_horario' => $registro['hora_recojo'],
                'direccion_recojo' => $registro['direccion_recojo'],
                'forma_pago' => 'Mercado Pago',
            ];

            // @dd($argsMail);


            Mail::to(config('mail.admin_address'))->send(new RegistroUsuarioNuevo($argsMailUsuarioNuevo));
            Mail::to($usuario->email)->send(new RegistroCompra($argsMail));


            return redirect()->route('registroservicionuevo_pedido_realizado', ['orden' => $pedido_id]);


        } else {
            echo json_encode([
                'id' => 0,
                'status' => 'error',
                'message' => 'No se encontró un, comunícate con soporte'
            ]);
        }

    }

    public function registroServicioNuevoPaymentSubscription(Request $request)
    {
        // Inicializa Mercado Pago

        $registro = $request->session()->get('registro');
        $data = $request->all();
        $data = json_decode($data['data'], true); // true para obtener array asociativo

//        @dd($data);
//        @dd($registro);

//        "token":"K9EPWWjcwcrl2MJjtH85ue464LhXoMnFgdaHMp8q",
//        "forma-pago":"cuotas",
//        "numero-cuotas":"2",
//        "precio-servicio":"0",
//        "precio-peso":"790",
//        "precio-extra":"0",
//        "precio-recojo":"160",
//        "precio-diarecojo":"60",
//        "precio-horarecojo":"0",
//        "precio-distritorecojo":"100",
//        "precio-igv":"171",
//        "precio-total":"1045",
//        "precio-cuota":"523",
//        "fee-adicional":"95"}


        $token_reset = time();

        $pagos_id = 'pago_' . uniqid();

        // @dd($user_id, $registro);
        // if (!$user_id) {

        $usuario = DB::table('usuarios')->where('id', $registro['user_id'])->first();
        $user_id = $registro['user_id'];
//                        dd($usuario);

        $argsUsuario = [
            'nombres' => $usuario->nombres,
            'apellidos' => $usuario->apellidos,
            'edad' => $usuario->edad,
            'celular' => $usuario->celular,
            'email' => $usuario->email,
            'dni' => $usuario->dni,
            'token_reset' => $token_reset,
            // 'contrasena' => sha1($registro['contrasena']),
        ];
        Session::put('argsUsuario', $argsUsuario);
        Session::put('user_id', $registro['user_id']);

        // Session::put('argsUsuario', $argsUsuario);
        // }

        // Registro mascota
        $argsMascota = [
            'nombre_mascota' => $registro['nombre_mascota'],
            'edad_mascota' => $registro['edad_mascota'],
            'peso_mascota' => $registro['peso_mascota'],
            'sexo_mascota' => $registro['sexo_mascota'],
            'raza_mascota' => $registro['raza_mascota'],
            'muerte_mascota' => $registro['muerte_mascota'],
            'id_usuario' => $user_id,
            'tipo_mascota' => $registro['tipo_mascota'],
            'fecha_creacion' => date('Y-m-d')
        ];
        $mascota_id = DB::table('mascotas')->insertGetId($argsMascota);

        // Registro recojo
        $argsRecojo = [
            'fecha_recojo' => $registro['fecha_recojo'],
            'id_horario' => $registro['hora_recojo'],
            'id_distrito' => $registro['distrito_recojo'],
            'direccion_recojo' => $registro['direccion_recojo'],
            'id_usuario' => $user_id,
            'id_mascota' => $mascota_id,
            'etapa' => 1,
            // Asignacion fija
            'estado' => 1,
            // 'estado_etapa' => 1,
            'id_conductor' => 3,
            'conductor_confirmado' => 1,
        ];

        $recojo_ida_id = DB::table('recojos')->insertGetId($argsRecojo);
        // $argsRecojo["etapa"] = 2;
        // $recojo_vuelta_id = DB::table('recojos')->insertGetId($argsRecojo);

        // use Carbon\Carbon;
        $fechaBase = Carbon::parse(date('Y-m-d')); // Fecha actual
        $fechaNueva = $fechaBase->addWeeks(6); // Sumar 6 semanas
        $fechaFormateada = $fechaNueva->format('Y-m-d'); // Formato YYYY-MM-DD

        // echo $fechaFormateada;

        $argsCompostaje = [
            'id_mascota' => $mascota_id,
            'estado' => 1,
            // 'estado_etapa' => 0,
            // Asignacion fija
            'id_operario' => 1,
            'operario_confirmado' => 1,
            'fin_tentativo' => $fechaFormateada
        ];

        $compostaje_id = DB::table('compostajes')->insertGetId($argsCompostaje);

        // Registrar pedido
        $servicio = DB::table('servicios')->where('slug', $registro['servicio-vuelve'])->first();

        $argsPedido = [
            'estado_pedido' => 0,
            'id_servicio' => $registro['servicio-vuelve'], // Vuelve ceniza
            'id_recojo_ida' => $recojo_ida_id,
            // 'id_recojo_vuelta' => $recojo_vuelta_id,
            'id_mascota' => $mascota_id,
            'id_usuario' => $user_id,
            'id_compostaje' => $compostaje_id,
            // 'fecha_recojo' => $registro['fecha_recojo'],
            'id_horario' => $registro['hora_recojo'],
            'acompaniar_mascota' => $registro['acompaniar_mascota'],
            'traslado_mascota' => $registro['traslado_mascota'],
            // 'direccion_recojo' => $registro['direccion_recojo'],
            // 'con_entrega' => $registro['con_entrega'] == 'true' ? 1 : 0,
            'pedido_activo' => 2,
            'fecha_creacion' => date('Y-m-d H:i:s')
        ];
        // if ($registro['nuevaDireccion'] == 'true') {
        //   $argsPedido['direccion_entrega'] = $registro['nueva_direccion'];
        // } else {
        //   $argsPedido['direccion_entrega'] = $registro['direccion_recojo'];
        // }
        $pedido_id = DB::table('pedidos')->insertGetId($argsPedido);


        $argsPagos = [
            'user_id' => $user_id,
            'monto_servicio' => $data['precio-servicio'],
            'id_pedido_pago' => $pedido_id,
            'id_cuota_pago' => $pagos_id,
            'forma_pago' => $data['forma-pago'],
            'tipo_pago' => 'servicio',
            'metodo_pago' => 'mercado_pago',
            'cantidad_cuotas' => $data['numero-cuotas'],
            'total_pagar' => $data['precio-total'],
            'igv' => $data['precio-igv'],
            'costo_envio' => $data['precio-recojo'],
            'pago_extra' => $data['precio-extra'],
            'pago_peso' => $data['precio-peso'],
            'fee_adicional' => 0,
            'costo_envio_dia' => $data['precio-diarecojo'],
            'costo_envio_hora' => $data['precio-horarecojo'],
            'costo_envio_distrito' => $data['precio-distritorecojo'],
            'estado' => 'pendiente',
            'created_at' => now(),
            'updated_at' => now()


            //'prod_extras' => json_encode($filteredExtras) ?? null
        ];

        if (isset($data['extra'])) {
            $filteredExtras = array_filter($data['extra'], function ($value) {
                return intval($value) >= 1;
            });

            $argsPagos['prod_extras'] = json_encode($filteredExtras);

        }


//        if ($data['forma-pago'] == 'total') {
//            $argsPagos['pago_cuota_1'] = $data['precio-total'];
//        }

//        if ($data['forma-pago'] == 'cuotas') {
//            $fecha = strtotime('+1 month', strtotime(date('Y-m-d')));
//            $fecha_formateada = date('Y-m-d', $fecha);
//            $argsPagos['fecha_2_pago'] = $fecha_formateada;
//        }

        // @dd($argsPagos);

        $pagos_id_ = DB::table('pagos')->insertGetId($argsPagos);

//        DB::table('pagos_cuotas')->insert([
//            'id_pago' => $pagos_id,
//            'numero_cuota' => 1,
//            'fecha_programada' => now(),
//            'fecha_pagada' => now(),
//            'monto' => $data['precio-cuota'],
//            'estado' => 'pagado',
//            'boleta' => null,
//            'created_at' => now(),
//            'updated_at' => now(),
//        ]);


        // AQUI REVISAR
        $argsServicio = [
            'pedido_id' => $pedido_id,
            'producto_id' => 1,
            'servicio_id' => $registro['servicio-vuelve'],
//            'pedido_tipo' => 'servicio',
            'cantidad' => 1, // Siempre 1 porque cada unidad será un registro
            'created_at' => date('Y-m-d H:i:s')
        ];

        // Insertamos una fila por cada unidad del producto
        DB::table('pedidos_servicios')->insert($argsServicio);

        // if($servicio->id_servicio == 1 || $servicio->id_servicio == 3){

        // }


        // Registrar items extras
        if (isset($data['extra'])) {
            foreach ($data['extra'] as $producto_id => $cantidad) {
                // $argsExtra = [
                //   'pedido_id' => $pedido_id,
                //   'producto_id' => $producto_id,
                //   'cantidad' => $cantidad,
                //   'created_at' => date('Y-m-d H:i:s')
                // ];
                // DB::table('pedidos_productos')->insert($argsExtra);
                for ($i = 0; $i < $cantidad; $i++) {
                    $argsExtra = [
                        'pedido_id' => $pedido_id,
                        'producto_id' => $producto_id,
//                        'pedido_tipo' => 'extras',
                        'cantidad' => 1, // Siempre 1 porque cada unidad será un registro
                        'created_at' => date('Y-m-d H:i:s')
                    ];

                    // Insertamos una fila por cada unidad del producto
                    DB::table('pedidos_productos')->insert($argsExtra);
                }
            }
        }


        // Email
        $argsMail = [
            'nombre_usuario' => $usuario->nombres . ' ' . $usuario->apellidos,
            'nombre_mascota' => $argsMascota['nombre_mascota'],
            'hora_recojo' => $registro['hora_recojo'],
            'acompaniar_mascota' => $argsPedido['acompaniar_mascota'],
            'token_reset' => $token_reset
        ];

        $argsMailUsuarioNuevo = [
            'nombre_usuario' => $usuario->nombres . ' ' . $usuario->apellidos,
            'celular' => $usuario->celular,
            'nombre_mascota' => $argsMascota['nombre_mascota'],
            'raza_mascota' => $argsMascota['raza_mascota'],
            'fecha_recojo' => $registro['fecha_recojo'],
            'id_horario' => $registro['hora_recojo'],
            'direccion_recojo' => $registro['direccion_recojo'],
            'forma_pago' => 'Mercado Pago',
        ];

//        @dd($argsMail);

        Mail::to(config('mail.admin_address'))->send(new RegistroUsuarioNuevo($argsMailUsuarioNuevo));
        Mail::to($usuario->email)->send(new RegistroCompra($argsMail));
        // }

        $numeroCuotas = $data['numero-cuotas'];
        $montoCuota = 2.00;


        MercadoPago\SDK::setAccessToken(config('services.mercadopago.access_token'));
        $preapproval = new MercadoPago\Preapproval();

        $emailCliente = $usuario->email; // Debes capturarlo en el frontend
//        $montoCuota = $data['precio-cuota'];


        $preapproval->back_url = route('encuestas'); // Ruta a la que vuelven luego del pago
        $preapproval->reason = '(Total: ' . $data['precio-total'] . ' Soles) Paga en ' . $numeroCuotas . ' cuotas de : ';

//        $preapproval->reason = 'Producto X - 2 cuotas de S/ 100 (total S/ 200)';
        $preapproval->payer_email = $emailCliente;
        $preapproval->external_reference = json_encode([
            'pedido_id' => $pedido_id, // Debes definirlo tú, ejemplo: ID de tu orden en la BD
            'pagos_id' => $pagos_id, // Debes definirlo tú, ejemplo: ID de tu orden en la BD
            'monto' => $data['precio-cuota'],
            'email' => $usuario->email,
            'nombre_mascota' => $registro['nombre_mascota']
        ]);

        //OFICIAL

//        $preapproval->auto_recurring = [
//            "frequency" => 1,
//            "frequency_type" => "months",
//            "transaction_amount" => $montoCuota,
//            "currency_id" => "PEN",
//            "start_date" => now()->startOfDay()->format('Y-m-d\TH:i:s.000P'),
//            "end_date" => now()->addMonths($numeroCuotas - 1)->endOfDay()->format('Y-m-d\TH:i:s.000P'),
//            "repetitions" => $numeroCuotas // ✅ Solo 2 pagos: hoy y en 1 mes
//        ];

        $preapproval->auto_recurring = [
            "frequency" => 1,
            "frequency_type" => "days", // Cobros diarios
            "transaction_amount" => $montoCuota,
            "currency_id" => "PEN",
            "start_date" => now()->startOfDay()->format('Y-m-d\TH:i:s.000P'),
            "end_date" => now()->addDay()->endOfDay()->format('Y-m-d\TH:i:s.000P'), // Termina mañana
            "repetitions" => 2 // Hoy y mañana
        ];


        try {
            $preapproval->save();

            if ($preapproval->init_point) {
                // Redirige al cliente para autorizar los cobros
                return redirect($preapproval->init_point);
            } else {
                Log::error('❌ Error al generar preapproval', (array)$preapproval);
                return back()->with('error', 'No se pudo generar el enlace de pago en cuotas.');
            }
        } catch (\Exception $e) {
            Log::error('❌ Excepción al crear preapproval', ['mensaje' => $e->getMessage()]);
            return back()->with('error', 'Error al iniciar el pago.');
        }
    }

    public function registroServicioNuevoPayment(Request $request)
    {
        // $user_id = $request->session()->get('user_id');

        // return dd($user_id);

        $data = $request->all();


        try {

            if ($data['token']) {

                MercadoPago\SDK::setAccessToken(config('services.mercadopago.access_token'));

                try {
                    // @dd($registro);
                    $registro = $request->session()->get('registro');
//                    @dd($registro);
                    $pagos_id = 'pago_' . uniqid();

                    $usuario = DB::table('usuarios')->where('id', $registro['user_id'])->first();
                    $user_id = $registro['user_id'];

                    $payment = new MercadoPago\Payment();
//                    $payment->transaction_amount = $data['transaction_amount'];
                    $payment->transaction_amount = 2.00;
                    $payment->token = $request->token;
                    $payment->description = "Compra de productos";
                    $payment->installments = (int)$request->installments;
                    $payment->payment_method_id = $request->payment_method_id;
                    $payment->issuer_id = (int)$request->issuer_id;
                    $payment->external_reference = json_encode([
                        'monto' => $data['data']['precio-total'],
                        'pagos_id' => $pagos_id,
                        'email' => $usuario->email,
                        'nombre_mascota' => $registro['nombre_mascota']
                    ]);

                    $payer = new MercadoPago\Payer();
                    $payerForm = $data['payer'];
                    $payer->email = $payerForm['email'];
                    $payer->identification = array(
                        "type" => $payerForm['identification']['type'],
                        "number" => $payerForm['identification']['number']
                    );
                    $payment->payer = $payer;
                    $payment->save();

                    // print_r($payment);die;

                    if ($payment->id === null) {
                        $error_message = 'Unknown error cause';
                        if (isset($payment->error)) {
                            $error_message = $payment->error->message;
                        }
                        echo $error_message;
                        die;
                    }


                    if ($payment->status == 'approved') {
                        // ----------------- Pago aprobado

                        $token_reset = time();

                        $argsUsuario = [
                            'nombres' => $usuario->nombres,
                            'apellidos' => $usuario->apellidos,
                            'edad' => $usuario->edad,
                            'celular' => $usuario->celular,
                            'email' => $usuario->email,
                            'dni' => $usuario->dni,
                            'token_reset' => $token_reset,
                            // 'contrasena' => sha1($registro['contrasena']),
                        ];
                        Session::put('argsUsuario', $argsUsuario);
                        Session::put('user_id', $registro['user_id']);
                        // Session::put('argsUsuario', $argsUsuario);
                        // }

                        // Registro mascota
                        $argsMascota = [
                            'nombre_mascota' => $registro['nombre_mascota'],
                            'edad_mascota' => $registro['edad_mascota'],
                            'peso_mascota' => $registro['peso_mascota'],
                            'sexo_mascota' => $registro['sexo_mascota'],
                            'raza_mascota' => $registro['raza_mascota'],
                            'muerte_mascota' => $registro['muerte_mascota'],
                            'id_usuario' => $user_id,
                            'tipo_mascota' => $registro['tipo_mascota'],
                            'fecha_creacion' => date('Y-m-d')
                        ];
                        $mascota_id = DB::table('mascotas')->insertGetId($argsMascota);

                        // Registro recojo
                        $argsRecojo = [
                            'fecha_recojo' => $registro['fecha_recojo'],
                            'id_horario' => $registro['hora_recojo'],
                            'id_distrito' => $registro['distrito_recojo'],
                            'direccion_recojo' => $registro['direccion_recojo'],
                            'id_usuario' => $user_id,
                            'id_mascota' => $mascota_id,
                            'etapa' => 1,
                            // Asignacion fija
                            'estado' => 1,
                            // 'estado_etapa' => 1,
                            'id_conductor' => 3,
                            'conductor_confirmado' => 1,
                        ];

                        $recojo_ida_id = DB::table('recojos')->insertGetId($argsRecojo);
                        // $argsRecojo["etapa"] = 2;
                        // $recojo_vuelta_id = DB::table('recojos')->insertGetId($argsRecojo);

                        // use Carbon\Carbon;
                        $fechaBase = Carbon::parse(date('Y-m-d')); // Fecha actual
                        $fechaNueva = $fechaBase->addWeeks(6); // Sumar 6 semanas
                        $fechaFormateada = $fechaNueva->format('Y-m-d'); // Formato YYYY-MM-DD

                        // echo $fechaFormateada;

                        $argsCompostaje = [
                            'id_mascota' => $mascota_id,
                            'estado' => 1,
                            // 'estado_etapa' => 0,
                            // Asignacion fija
                            'id_operario' => 1,
                            'operario_confirmado' => 1,
                            'fin_tentativo' => $fechaFormateada
                        ];

                        $compostaje_id = DB::table('compostajes')->insertGetId($argsCompostaje);

                        // Registrar pedido
                        $servicio = DB::table('servicios')->where('slug', $registro['servicio-vuelve'])->first();

                        $argsPedido = [
                            'estado_pedido' => 1,
                            'id_servicio' => $registro['servicio-vuelve'], // Vuelve ceniza
                            'id_recojo_ida' => $recojo_ida_id,
                            'id_mascota' => $mascota_id,
                            'id_usuario' => $user_id,
                            'id_compostaje' => $compostaje_id,
                            'id_horario' => $registro['hora_recojo'],
                            'acompaniar_mascota' => $registro['acompaniar_mascota'],
                            'traslado_mascota' => $registro['traslado_mascota'],
                            // 'direccion_recojo' => $registro['direccion_recojo'],
                            // 'con_entrega' => $registro['con_entrega'] == 'true' ? 1 : 0,
                            'pedido_activo' => 1,
                            'fecha_creacion' => date('Y-m-d H:i:s')
                        ];
                        // if ($registro['nuevaDireccion'] == 'true') {
                        //   $argsPedido['direccion_entrega'] = $registro['nueva_direccion'];
                        // } else {
                        //   $argsPedido['direccion_entrega'] = $registro['direccion_recojo'];
                        // }
                        $pedido_id = DB::table('pedidos')->insertGetId($argsPedido);


                        $argsPagos = [
                            'user_id' => $user_id,
                            'monto_servicio' => $data['data']['precio-servicio'],
                            'id_pedido_pago' => $pedido_id,
                            'id_cuota_pago' => $pagos_id,
                            'forma_pago' => $data['data']['forma-pago'],
                            'tipo_pago' => 'servicio',
                            'metodo_pago' => 'mercado_pago',
                            'cantidad_cuotas' => 1,
                            'total_pagar' => $data['data']['precio-total'],
                            'igv' => $data['data']['precio-igv'],
                            'costo_envio' => $data['data']['precio-recojo'],
                            'pago_extra' => $data['data']['precio-extra'],
                            'pago_peso' => $data['data']['precio-peso'],
                            'fee_adicional' => 0,
                            'costo_envio_dia' => $data['data']['precio-diarecojo'],
                            'costo_envio_hora' => $data['data']['precio-horarecojo'],
                            'costo_envio_distrito' => $data['data']['precio-distritorecojo'],
                            'estado' => 'pagado',
                            'created_at' => now(),
                            'updated_at' => now(),
                            //'prod_extras' => json_encode($filteredExtras) ?? null
                        ];

                        if (isset($data['data']['extra'])) {
                            $filteredExtras = array_filter($data['data']['extra'], function ($value) {
                                return intval($value) >= 1;
                            });

                            $argsPagos['prod_extras'] = json_encode($filteredExtras);

                        }


//                        if ($data['data']['forma-pago'] == 'total') {
//                            $argsPagos['pago_cuota_1'] = $data['data']['precio-total'];
//                        }

//                        if ($data['data']['forma-pago'] == 'cuotas') {
//                            $fecha = strtotime('+1 month', strtotime(date('Y-m-d')));
//                            $fecha_formateada = date('Y-m-d', $fecha);
//                            $argsPagos['fecha_2_pago'] = $fecha_formateada;
//                        }

                        // @dd($argsPagos);

                        $pagos_id_db = DB::table('pagos')->insertGetId($argsPagos);

//                        DB::table('pagos_cuotas')->insert([
//                            'id_pago' => $pagos_id,
//                            'numero_cuota' => 1,
//                            'fecha_programada' => now(),
//                            'fecha_pagada' => now(),
//                            'monto' => $data['data']['precio-total'],
//                            'estado' => 'pagado',
//                            'boleta' => null,
//                            'created_at' => now(),
//                            'updated_at' => now(),
//                        ]);


                        // AQUI REVISAR
                        $argsServicio = [
                            'pedido_id' => $pedido_id,
                            'producto_id' => 1,
                            'servicio_id' => $registro['servicio-vuelve'],
//                            'pedido_tipo' => 'servicio',
                            'cantidad' => 1, // Siempre 1 porque cada unidad será un registro
                            'created_at' => date('Y-m-d H:i:s')
                        ];

                        // Insertamos una fila por cada unidad del producto
                        DB::table('pedidos_servicios')->insert($argsServicio);

                        // if($servicio->id_servicio == 1 || $servicio->id_servicio == 3){

                        // }


                        // Registrar items extras
                        if (isset($data['data']['extra'])) {
                            foreach ($data['data']['extra'] as $producto_id => $cantidad) {
                                // $argsExtra = [
                                //   'pedido_id' => $pedido_id,
                                //   'producto_id' => $producto_id,
                                //   'cantidad' => $cantidad,
                                //   'created_at' => date('Y-m-d H:i:s')
                                // ];
                                // DB::table('pedidos_productos')->insert($argsExtra);
                                for ($i = 0; $i < $cantidad; $i++) {
                                    $argsExtra = [
                                        'pedido_id' => $pedido_id,
                                        'producto_id' => $producto_id,
//                                        'pedido_tipo' => 'extras',
                                        'cantidad' => 1, // Siempre 1 porque cada unidad será un registro
                                        'created_at' => date('Y-m-d H:i:s')
                                    ];

                                    // Insertamos una fila por cada unidad del producto
                                    DB::table('pedidos_productos')->insert($argsExtra);
                                }
                            }
                        }


                        // if (!$user_id) {
                        $argsMail = [
                            'nombre_usuario' => $usuario->nombres . ' ' . $usuario->apellidos,
                            'nombre_mascota' => $argsMascota['nombre_mascota'],
                            'hora_recojo' => $registro['hora_recojo'],
                            'acompaniar_mascota' => $argsPedido['acompaniar_mascota'],
                            'token_reset' => $token_reset
                        ];

                        $argsMailUsuarioNuevo = [
                            'nombre_usuario' => $usuario->nombres . ' ' . $usuario->apellidos,
                            'celular' => $usuario->celular,
                            'nombre_mascota' => $argsMascota['nombre_mascota'],
                            'raza_mascota' => $argsMascota['raza_mascota'],
                            'fecha_recojo' => $registro['fecha_recojo'],
                            'id_horario' => $registro['hora_recojo'],
                            'direccion_recojo' => $registro['direccion_recojo'],
                            'forma_pago' => 'Mercado Pago',
                        ];

                        // @dd($argsMail);

                        Mail::to(config('mail.admin_address'))->send(new RegistroUsuarioNuevo($argsMailUsuarioNuevo));
                        Mail::to($usuario->email)->send(new RegistroCompra($argsMail));
                        // }


                        $response = array(
                            "request" => $request,
                            "payment_id" => $payment->id,
                            "status" => $payment->status,
                            "status_detail" => $payment->status_detail,
                            "data" => $data,
                            "registro" => $registro
                        );

                        echo json_encode($response);


                    }

                    // Step 7: Handle exceptions
                } catch (MPApiException $e) {
                    echo "Status code: " . $e->getApiResponse()->getStatusCode() . "\n";
                    echo "Content: ";
                    var_dump($e->getApiResponse()->getContent());
                    echo "\n";
                } catch (\Exception $e) {
                    echo "Error: " . $e->getMessage();
                }
                die;


            } else {
                echo json_encode([
                    'id' => 0,
                    'status' => 'error',
                    'message' => 'No se encontró un plan, comunícate con soporte'
                ]);
            }

        } catch (\Exception $e) {
            print_r($e);
            die;
            echo json_encode([
                'id' => 0,
                'status' => 'error',
                'error' => json_encode($e),
                'message' => 'Hubo un error al validar el pago, puedes volver a intentarlo con otra tarjeta'
            ]);
        }
    }
}
