<?php

namespace App\Http\Controllers;

use App\Mail\OperarioPaso2;
use Illuminate\Http\Request;
use DB;
use Illuminate\Support\Facades\Mail;
use Session;
use Carbon\Carbon;

class OperarioController extends Controller
{
    //
    public function iniciar_sesion(Request $request)
    {
        return view('front.operario.iniciar_sesion');
    }

    public function loginaction(Request $request)
    {
        $data = $request->all();
        // return dd($data);
        $password = $data['password'];
        $usuario = DB::table('operarios')->where('email', $data['email'])
            ->where(function ($query) use ($password) {
                $query->where('contrasena', $password)
                    ->orWhere('contrasena', sha1($password));
            })->first();
        if ($usuario) {
            Session::put('user_id', $usuario->id_operario);
            // return redirect()->route('operario_inicio');
            return response()->json(['message' => 'Usuario registrado correctamente']);

        } else {
            return response()->json(['message' => 'No se encontró el usuario y/o contraseña']);
        }
    }


    public function cerrar_sesion_operario(Request $request)
    {
        $request->session()->flush();
        // return redirect()->route('landing');
        return redirect()->route('operario_iniciar_sesion');
    }

    public function inicio(Request $request)
    {


        $operario_id = $request->session()->get('user_id');

        $operario = DB::table('operarios')->where('id_operario', $operario_id)->first();
        if (!$operario) {
            return redirect()->route('operario_iniciar_sesion');
        } else {
            $operario_id = session()->get('user_id');
        }

        $usuario = DB::table('operarios')->where('id_operario', $operario_id)->first();

        $mascotasCompostario = DB::table('compostajes')
            ->where('id_operario', $operario_id)
            ->leftJoin('mascotas', 'compostajes.id_mascota', '=', 'mascotas.id_mascota')
            ->leftJoin('pedidos', 'compostajes.id_compostaje', '=', 'pedidos.id_mascota')
            ->leftJoin('servicios', 'pedidos.id_servicio', '=', 'servicios.id_servicio')
            ->select('mascotas.nombre_mascota', 'mascotas.edad_mascota', 'mascotas.peso_mascota', 'mascotas.tipo_mascota', 'mascotas.sexo_mascota', 'servicios.nombre_servicio', 'compostajes.inicio_fecha', 'compostajes.fin_fecha', 'compostajes.estado', 'compostajes.id_compostaje')
            ->get();

        // Calcular rango de la semana actual (lunes a domingo)
        $startOfWeek = Carbon::now()->startOfWeek(Carbon::MONDAY)->startOfDay();
        $endOfWeek = Carbon::now()->endOfWeek(Carbon::SUNDAY)->endOfDay();

        $mascotasCompostarioSemana = DB::table('compostajes')
            ->where('id_operario', $operario_id)
            ->whereBetween('compostajes.fin_tentativo', [$startOfWeek, $endOfWeek])
            ->leftJoin('mascotas', 'compostajes.id_mascota', '=', 'mascotas.id_mascota')
            ->select('mascotas.nombre_mascota', 'mascotas.edad_mascota', 'mascotas.peso_mascota', 'mascotas.tipo_mascota', 'mascotas.sexo_mascota', 'compostajes.fin_tentativo', 'compostajes.estado', 'compostajes.id_compostaje')
            ->get();

        $startDate = now()->subDays(30);
        $endDate = now();

        $mascotasCompostarioMes = DB::table('compostajes')
            ->where('id_operario', $operario_id)
            ->whereBetween('compostajes.fin_tentativo', [$startDate, $endDate])
            ->leftJoin('mascotas', 'compostajes.id_mascota', '=', 'mascotas.id_mascota')
            ->select('mascotas.nombre_mascota', 'mascotas.edad_mascota', 'mascotas.peso_mascota', 'mascotas.tipo_mascota', 'mascotas.sexo_mascota', 'compostajes.fin_tentativo', 'compostajes.estado', 'compostajes.id_compostaje')
            ->get();

        $startDate15 = now()->subDays(15);
        $mascotasCompostario15dias = DB::table('compostajes')
            ->where('id_operario', $operario_id)
            ->whereBetween('compostajes.fin_tentativo', [$startDate15, $endDate])
            ->leftJoin('mascotas', 'compostajes.id_mascota', '=', 'mascotas.id_mascota')
            ->select('mascotas.nombre_mascota', 'mascotas.edad_mascota', 'mascotas.peso_mascota', 'mascotas.tipo_mascota', 'mascotas.sexo_mascota', 'compostajes.fin_tentativo', 'compostajes.estado', 'compostajes.id_compostaje')
            ->get();

//        @dd($mascotasCompostario15dias);


        $objTotalCompostajes = DB::table('compostajes')->where('compostajes.estado', '=', 2)->count();;
        $objServicioVuelveCenizas = DB::table('pedidos')->where('pedidos.id_servicio', '=', 3)->count();
        $objServicioVets = DB::table('pedidos')->where('pedidos.id_servicio', '=', 5)->count();
        $objServicioVuelveACasa = DB::table('pedidos')->where('pedidos.id_servicio', '=', 1)->count();
        $objServicioPlanSiempreJuntos = DB::table('pedidos')->where('pedidos.id_servicio', '=', 2)->count();

        $sumaCompostaje = DB::table('compostajes')->sum('peso_cosecha');


        return view('front.operario.inicio', [
            'usuario' => $usuario,
            'mascotasCompostario' => $mascotasCompostario,
            'objTotalCompostajes' => $objTotalCompostajes,
            'objServicioVets' => $objServicioVets,
            'objServicioVuelveCenizas' => $objServicioVuelveCenizas,
            'objServicioVuelveACasa' => $objServicioVuelveACasa,
            'objServicioPlanSiempreJuntos' => $objServicioPlanSiempreJuntos,
            'sumaCompostaje' => $sumaCompostaje,

            'mascotasCompostarioSemana' => $mascotasCompostarioSemana,
            'mascotasCompostario15dias' => $mascotasCompostario15dias,
            'mascotasCompostarioMes' => $mascotasCompostarioMes

        ]);
    }

    public function actividades(Request $request)
    {
        // $user_id = $request->session()->get('user_id');
        $operario_id = $request->session()->get('user_id');

        $operario = DB::table('operarios')->where('id_operario', $operario_id)->first();
        if (!$operario) {
            return redirect()->route('operario_iniciar_sesion');
        } else {
            $operario_id = session()->get('user_id');
        }

        $usuario = DB::table('operarios')->where('id_operario', $operario_id)->first();
        // $pedidos = DB::table('pedidos')->where('id_operario', $operario_id)->get();
        $mascotas = DB::table('mascotas')->get();

        $compostajesPorCompostar = DB::table('compostajes')
            ->where('id_operario', $operario_id)
            ->where('compostajes.estado', '=', 1)
            ->leftJoin('mascotas', 'compostajes.id_mascota', '=', 'mascotas.id_mascota')
            ->leftJoin('pedidos', 'compostajes.id_compostaje', '=', 'pedidos.id_mascota')
            ->leftJoin('servicios', 'pedidos.id_servicio', '=', 'servicios.id_servicio')
            ->select('mascotas.nombre_mascota', 'mascotas.fecha_creacion', 'mascotas.edad_mascota', 'mascotas.peso_mascota', 'mascotas.tipo_mascota', 'mascotas.sexo_mascota', 'servicios.nombre_servicio', 'compostajes.inicio_fecha', 'compostajes.fin_fecha', 'compostajes.estado', 'compostajes.fin_tentativo', 'compostajes.id_compostaje')
            ->get();
        $compostajesEnCurso = DB::table('compostajes')
            ->where('id_operario', $operario_id)
            ->where('compostajes.estado', '=', 2)
            ->leftJoin('mascotas', 'compostajes.id_mascota', '=', 'mascotas.id_mascota')
            ->leftJoin('pedidos', 'compostajes.id_compostaje', '=', 'pedidos.id_mascota')
            ->leftJoin('servicios', 'pedidos.id_servicio', '=', 'servicios.id_servicio')
            ->select('mascotas.nombre_mascota', 'mascotas.fecha_creacion', 'mascotas.edad_mascota', 'mascotas.peso_mascota', 'mascotas.tipo_mascota', 'mascotas.sexo_mascota', 'servicios.nombre_servicio', 'compostajes.inicio_fecha', 'compostajes.fin_fecha', 'compostajes.estado', 'compostajes.fin_tentativo', 'compostajes.id_compostaje')
            ->get();

        $fechaActual = Carbon::now()->format('Y-m-d');
        $compostajesPorCosechar = DB::table('compostajes')
            ->where('id_operario', $operario_id)
//            ->where('compostajes.estado', '=', 3)
            ->whereDate('compostajes.fin_tentativo', '=', $fechaActual)
            ->leftJoin('mascotas', 'compostajes.id_mascota', '=', 'mascotas.id_mascota')
            ->leftJoin('pedidos', 'compostajes.id_compostaje', '=', 'pedidos.id_mascota')
            ->leftJoin('servicios', 'pedidos.id_servicio', '=', 'servicios.id_servicio')
            ->select('mascotas.nombre_mascota', 'mascotas.fecha_creacion', 'mascotas.edad_mascota', 'mascotas.peso_mascota', 'mascotas.tipo_mascota', 'mascotas.sexo_mascota', 'servicios.nombre_servicio', 'compostajes.inicio_fecha', 'compostajes.fin_fecha', 'compostajes.estado', 'compostajes.fin_tentativo', 'compostajes.id_compostaje')
            ->get();
//        @dd($compostajesPorCosechar);
        $hace30Dias = Carbon::now()->subDays(30)->format('Y-m-d');
        $compostajesCompletado = DB::table('compostajes')
//            ->where('id_operario', $operario_id)
//            ->where('compostajes.estado', '=', 4)
            ->whereDate('compostajes.fin_fecha', '>=', $hace30Dias)
            ->leftJoin('mascotas', 'compostajes.id_mascota', '=', 'mascotas.id_mascota')
            ->leftJoin('pedidos', 'compostajes.id_compostaje', '=', 'pedidos.id_mascota')
            ->leftJoin('servicios', 'pedidos.id_servicio', '=', 'servicios.id_servicio')
            ->select('mascotas.nombre_mascota', 'mascotas.fecha_creacion', 'mascotas.edad_mascota', 'mascotas.peso_mascota', 'mascotas.tipo_mascota', 'mascotas.sexo_mascota', 'servicios.nombre_servicio', 'compostajes.inicio_fecha', 'compostajes.fin_fecha', 'compostajes.estado', 'compostajes.fin_tentativo', 'compostajes.id_compostaje')
            ->get();
//        @dd($compostajesCompletado);

        $compostajesN = DB::table('compostajes')->where('id_operario', $operario_id)->get();

        // var_dump($compostajes);
        // @dd($compostajes);
        // @dd($compostajes);


        return view('front.operario.actividades', compact('usuario', 'compostajesPorCompostar', 'compostajesEnCurso', 'compostajesPorCosechar', 'compostajesCompletado', 'mascotas', 'usuario'));
    }

    public function actividades_id($id)
    {
        // var_dump($id);

        $user_id = session()->get('user_id');

        if ($_POST) {
            $data = $request->all();
        }

        $operario = DB::table('operarios')->where('id_operario', $user_id)->first();
        if (!$operario) {
            return redirect()->route('operario_iniciar_sesion');
        } else {
            $operario_id = session()->get('user_id');
        }


        $operario = DB::table('operarios')->where('id_operario', $operario_id)->first();
        $compostaje = DB::table('compostajes')->where('id_compostaje', $id)->first();


        $pedido = DB::table('pedidos')->where('id_compostaje', $compostaje->id_compostaje)->first();

        // dd($pedido);


        $mascota = DB::table('mascotas')->where('id_mascota', $pedido->id_mascota)->first();
        $usuario = DB::table('usuarios')->where('id', $pedido->id_usuario)->first();
        $recojos = DB::table('recojos')->where('id_recojo', $pedido->id_recojo_ida)->first();
        $horario = DB::table('horarios')->where('id_horario', $recojos->id_horario)->first();

        // @dd($pedido->fecha_creacion);

        if (!empty($pedido->fecha_creacion)) {
            $fechaBase = Carbon::parse($pedido->fecha_creacion);
            $fechaNueva = $fechaBase->addWeeks(6); // Sumar 6 semanas

            $fechaTentativa = $fechaNueva->format('Y-m-d'); // Formato YYYY-MM-DD
        }

        // echo $fechaTentativa;

        // @dd($fechaTentativa);

        $monitoreos = DB::table('monitoreoOperario')->where('id_compostaje', $id)->get();
        // DB::table('compostajes')->where('id_compostaje', $id)->first();
        $ultimoNumero = $monitoreos->count();

        // return view('monitoreo.index', compact('monitoreos', 'ultimoNumero'));


        return view('front.operario.actividades_id', compact('monitoreos', 'fechaTentativa', 'ultimoNumero', 'operario', 'pedido', 'mascota', 'usuario', 'horario', 'recojos', 'compostaje'));
    }

    public function subir_fotografia(Request $request)
    {
        $data = $request->all();
        // @dd($data);

        $file_fotohuella = $request->file('foto_huella');
        $file_fotocunalista = $request->file('foto_cunalista');
        $file_fototaparcuna = $request->file('foto_taparcuna');

        // @dd($file_fotohuella);

        if ($file_fotohuella) {

            $originalFileName = $file_fotohuella->getClientOriginalName();
            $path = $file_fotohuella->storeAs('operario-foto', $originalFileName, 'public'); // Guarda en storage/app/public/


            // @dd($path);

            DB::table('compostajes')->where('id_compostaje', $data['id_compostaje'])->update([
                'foto_huella' => $path,
            ]);

        }

        if ($file_fotocunalista) {

            $originalFileName = $file_fotocunalista->getClientOriginalName();
            $path = $file_fotocunalista->storeAs('operario-foto', $originalFileName, 'public'); // Guarda en storage/app/public/

            DB::table('compostajes')->where('id_compostaje', $data['id_compostaje'])->update([
                'foto_cunalista' => $path,
            ]);

        }

        if ($file_fototaparcuna) {

            $originalFileName = $file_fototaparcuna->getClientOriginalName();
            $path = $file_fototaparcuna->storeAs('operario-foto', $originalFileName, 'public'); // Guarda en storage/app/public/

            DB::table('compostajes')->where('id_compostaje', $data['id_compostaje'])->update([
                'foto_cunatapar' => $path,
            ]);

        }

        return redirect()->route('operario_actividades_id', $data['id_compostaje'])->with('exito', 'Se ha guardado la información correctamente');


    }

    public function confirmar_operario(Request $request)
    {
        $data = $request->all();
        // var_dump($data);
        // //return dd($data);
        // $password = $data['password'];
        DB::table('compostajes')->where('id_compostaje', $data['id_compostaje'])->update([
            'operario_confirmado' => $data['confirmacion'],
            'id_operario' => 1,
            'estado' => 2,
        ]);

        return redirect()->route('operario_actividades_id', $data['id_compostaje']);
    }

    public function registro_actividad_operario_paso1(Request $request)
    {
        $data = $request->all();
        // var_dump($data);
        // //return dd($data);
        // $password = $data['password'];
        DB::table('compostajes')->where('id_compostaje', $data['id_compostaje'])->update([
            'estado_etapa' => $data['estado_etapa'],
            'fecha_recepcion' => date('Y-m-d'),
        ]);

        DB::table('pedidos')->where('id_compostaje', $data['id_compostaje'])->update([
            'estado_pedido' => 2,
        ]);

        return redirect()->route('operario_actividades_id', $data['id_compostaje']);
    }

    public function registro_actividad_operario_paso2(Request $request)
    {
        $data = $request->all();
        // var_dump($data);
        // //return dd($data);
//        @dd($data);

        if (isset($data['estado'])) {
            DB::table('compostajes')->where('id_compostaje', $data['id_compostaje'])->update([
                'estado' => $data['estado'],
            ]);
        }

        $argsMail = [
            'nombre_mascota' => $data['nombre_mascota'],
            'nombre_usuario' => $data['nombre_usuario']
        ];
        

        Mail::to($data['email'])->send(new OperarioPaso2($argsMail));
        // $password = $data['password'];
        DB::table('compostajes')->where('id_compostaje', $data['id_compostaje'])->update([
            'estado_etapa' => $data['estado_etapa'],
        ]);

        return redirect()->route('operario_actividades_id', $data['id_compostaje']);
    }

    public function registro_actividad_operario_paso3(Request $request)
    {
        $data = $request->all();
//        @dd($data);
        // var_dump($data);
        // //return dd($data);
        // $password = $data['password'];
        DB::table('compostajes')->where('id_compostaje', $data['id_compostaje'])->update([
            'estado_etapa' => $data['estado_etapa'],
            'inicio_fecha' => $data['inicio_fecha'],
            'inicio_hora' => $data['inicio_hora'],
        ]);

        $inicio = Carbon::parse($data['inicio_fecha']); // "2025-07-25"


        // PROD

//        $plantillas = [
//            ['tipo' => 'seguimiento_2', 'dias' => 1],
//            ['tipo' => 'seguimiento_3', 'dias' => 14],
//            ['tipo' => 'seguimiento_4', 'dias' => 30],
//            ['tipo' => 'seguimiento_5', 'dias' => 42],
//        ];
//
        // QA

        $plantillas = [
            ['tipo' => 'seguimiento_2', 'dias' => 1],
            ['tipo' => 'seguimiento_3', 'dias' => 2],
            ['tipo' => 'seguimiento_4', 'dias' => 3],
            ['tipo' => 'seguimiento_5', 'dias' => 4],
        ];

        foreach ($plantillas as $p) {
            DB::table('emails_programados')->insert([
                'user_id' => $data['id_usuario'],
                'email' => $data['email'],
                'pedido_id' => $data['id_pedido'],
                'tipo' => $p['tipo'],
                'data' => json_encode([
                    'nombre_usuario' => $data['nombre_usuario'],
                    'nombre_mascota' => $data['nombre_mascota'],
                ]),
                'enviar_en' => $inicio->copy()->addDays($p['dias']),
            ]);
        }


        return redirect()->route('operario_actividades_id', $data['id_compostaje']);
    }

    // public function indexMonitor()
    // {
    //     $monitoreos = Monitoreo::where('id_compostaje', $id_compostaje)->get();
    //     $ultimoNumero = $monitoreos->count();

    //     return view('monitoreo.index', compact('monitoreos', 'ultimoNumero'));
    // }

    public function registro_monitoreo(Request $request)
    {
        $data = $request->all();
        $argsMonitoreo = [
            // 'temperatura' =>  $data['temperatura'],
            'regado' => $data['regado'],
            'id_operario' => $data['id_operario'],
            'id_compostaje' => $data['id_compostaje'],
            'hora' => $data['hora'],
            'fecha' => $data['fecha'],
            'id_mascota' => $data['id_mascota']
        ];

        DB::table('monitoreoOperario')->insert($argsMonitoreo);

        return redirect()->route('operario_actividades_id', $data['id_compostaje']);

    }

    public function subir_foto(Request $request)
    {
        $data = $request->all();
        // var_dump($data);s

        $imagePaths = [];
        foreach ($request->file('archivos') as $image) {
            $imagePath = $image->store('public/product-images');
            DB::table('monitoreoFotografias')->insert([
                'id_operario' => $request->input('id_operario'),
                'id_compostaje' => $request->input('id_compostaje'),
                'id_mascota' => $request->input('id_mascota'),
                'foto_url' => $imagePath
            ]);
            $imagePaths[] = $imagePath;
        }

        return response()->json(['message' => 'Imágenes guardadas correctamente']);


    }


    public function registro_actividad_operario_paso4(Request $request)
    {
        $data = $request->all();
//        @dd($data);
        // var_dump($data);
        // //return dd($data);
        // $password = $data['password'];


        DB::table('compostajes')->where('id_compostaje', $data['id_compostaje'])->update([
            'peso_cosecha' => $data['peso_cosecha'],
//            'peso_restos' => $data['peso_restos'],
//            'fin_hora' => $data['fin_hora'],
            'fin_fecha' => $data['fin_fecha'],
            'estado_etapa' => $data['estado_etapa'],

        ]);

        return redirect()->route('operario_actividades_id', $data['id_compostaje']);
    }

    // public function registro_actividad_operario_paso5(Request $request)
    // {
    //     $data = $request->all();
    //     // var_dump($data);
    //     // //return dd($data);
    //     // $password = $data['password'];
    //     DB::table('compostajes')->where('id_compostaje', $data['id_compostaje'])->update([
    //         'estado_etapa' => $data['estado_etapa'],
    //         'estado' => 3,
    //     ]);

    //     $argsMonitoreo = [
    //         'fecha_recojo' =>  $data['fecha_recojo'],
    //         'id_horario' =>  $data['id_horario'],
    //         'id_distrito' =>  $data['id_distrito'],
    //         'direccion_recojo' =>  $data['direccion_recojo'],
    //         'id_usuario' =>  $data['id_usuario'],
    //         'id_mascota' =>  $data['id_mascota'],
    //         'estado' =>  1,
    //         'etapa' =>  2,
    //         'estado_etapa' =>  2,
    //     ];


    //     DB::table('recojos')->insert($argsMonitoreo);

    //     $recojos = DB::table('recojos')->where('id_mascota', $data['id_mascota'])->where('etapa', 2)->first();

    //     DB::table('pedidos')->where('id_pedido', $data['id_pedido'])->update([
    //         'id_recojo_vuelta' => $recojos->id_recojo,
    //     ]);

    //     return redirect()->route('operario_actividades_id', $data['id_compostaje']);
    // }


    public function getMonitoreoForm(Request $request)
    {
        $count = $request->input('count');
        $compostaje = $request->id_compostaje;
        $operario = $request->id_operario;
        $mascota = $request->id_mascota;

        // var_dump($count);

        return view('components.monitoreo-form', compact('count', 'compostaje', 'operario', 'mascota'));
    }

}

