<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Jobs\ProcesarPagoMercadoPago;

class MercadoPagoWebhookController extends Controller
{
    public function handle(Request $request)
    {
        $paymentId = $request->input('data.id');

        if (!$paymentId) {
            return response()->json(['ignored' => true]);
        }

        // Enviar el pago a la cola
        ProcesarPagoMercadoPago::dispatch($paymentId);

        return response()->json(['ok' => true]);
    }
}
