<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Http;
use Session;
use Illuminate\Support\Facades\Mail;
use App\Mail\RegistroUsuario;

class AjaxController extends Controller
{
    //

    public function registro_usuario_admin(Request $request)
    {

        $data = $request->all();

        // print_r($data);

        $argsUsuario = [
            'nombres' => $data['nombres'],
            'email' => $data['email'],
            'contrasena' => sha1($data['password'])
        ];

        if ($data['rol'] == 1) {
            DB::table('administradores')->insert($argsUsuario);
        } else if ($data['rol'] == 2) {
            DB::table('operarios')->insert($argsUsuario);
        } else if ($data['rol'] == 3) {
            DB::table('conductores')->insert($argsUsuario);
        }

        $res = [
            'success' => true,
            'message' => 'Registro exitoso',
            'data' => $data,
        ];

        echo json_encode($res);

    }

    public function registro_usuario(Request $request)
    {

        $data = $request->all();

        // print_r($data);

        $argsUsuario = [
            'nombres' => $data['nombres'],
            'apellidos' => $data['apellidos'],
            'edad' => $data['edad'],
            'celular' => $data['celular'],
            'email' => $data['email'],
            // 'contrasena' => $data['contrasena'],
            'contrasena' => sha1($data['contrasena']),
            'estado' => 1,
            'fecha_creacion' => date('Y-m-d H:i:s')
        ];

        // Session::put('argsUsuario', $argsUsuario);
        // session(['key' => 'value']);
        session(['argsUsuario' => $argsUsuario]);
        // $request->session()->put('argsUsuario', $argsUsuario);


        $res = [
            'success' => true,
            'message' => 'Registro exitoso',
            'data' => $data,
        ];

        echo json_encode($res);

    }

    public function registro_mascota(Request $request)
    {

        $data = $request->all();

        // print_r($data);

        // `nombre_mascota`
        // `edad_mascota`
        // `peso_mascota`
        // `sexo_mascota`
        // `fecha_recojo`

        $argsMacota = [
            'nombre_mascota' => $data['nombre_mascota'],
            'edad_mascota' => $data['edad_mascota'],
            'tipo_mascota' => $data['tipo_mascota'],
            'peso_mascota' => $data['peso_mascota'],
            'sexo_mascota' => $data['sexo_mascota'],
            'fecha_recojo' => $data['fecha_recojo'],
        ];


        // Session::put('argsMacota', $argsMacota);
        // session(['key' => 'value']);
        session(['argsMacota' => $argsMacota]);
        // $request->session()->put('argsMacota', $argsMacota);


        $res = [
            'success' => true,
            'message' => 'Registro exitoso',
            'data' => $data,
        ];

        echo json_encode($res);

    }

    public function registro_recojo(Request $request)
    {

        $data = $request->all();

        $argsRecojo = [
            'fecha_recojo' => $data['fecha_recojo'],
            'id_horario' => $data['hora_recojo'],
            'id_distrito' => $data['distrito_recojo'],
            'direccion_recojo' => $data['direccion_recojo'],
            'etapa' => 1,
        ];

        $fecha_recojo = DB::table('dias')->where('fecha_recojo', $data['fecha_recojo'])->first();
        $costo_dia = $fecha_recojo->costo;

        $hora_recojo = DB::table('horarios')->where('id_horario', $data['hora_recojo'])->first();
        $costo_hora = $hora_recojo->costo;

        $distrito_recojo = DB::table('distritos')->where('id_distrito', $data['distrito_recojo'])->first();
        $costo_distrito = $distrito_recojo->costo;


        $argsCostoRecojo = $costo_dia + $costo_hora + $costo_distrito;

        // Session::put('argsRecojo', $argsRecojo);
        // session(['key' => 'value']);
        session(['argsCostoRecojo' => $argsCostoRecojo]);
        session(['argsRecojo' => $argsRecojo]);


        $res = [
            'success' => true,
            'message' => 'Registro exitoso',
            'data' => $data,
        ];

        echo json_encode($res);

    }

    public function confirmacion_datos(Request $request)
    {

        $data = $request->all();

        // 'bolsa_compost'
        // 'nueva_direccion'

        $argsBolsa = [
            'bolsa_compost' => $data['bolsa_compost'],
            // 'contrasena' => sha1($data['contrasena']),
            // 'estado' => 1,
            // 'fecha_creacion' => date('Y-m-d H:i:s')
        ];

        session(['argsBolsa' => $argsBolsa]);
        // $request->session()->put('argsUsuario', $argsUsuario);


        $res = [
            'success' => true,
            'message' => 'Registro exitoso',
            'data' => $data,
        ];

        echo json_encode($res);

        // return redirect()->route('extras');

    }

    public function agregar_carrito(Request $request)
    {

        // Recibir el array de objetos enviado por AJAX
        $objetos = $request->input('objetos');
        $monto_final = $request->input('monto_final');

        // Definir un array en el que almacenar los datos recibidos
        $datosAlmacenados = [];

        // Iterar sobre cada objeto en el array
        foreach ($objetos as $objeto) {
            // Acceder a los datos del objeto
            $id_producto = $objeto['id_producto'];
            $cantidad_producto = $objeto['cantidad_producto'];
            $precio = $objeto['precio'];

            $datosAlmacenados[] = [
                'id_producto' => $id_producto,
                'cantidad_producto' => $cantidad_producto,
                'precio' => $precio,
            ];
        }


        session(['argsCarrito' => $datosAlmacenados]);
        // // $request->session()->put('argsCarrito', $argsCarrito);


        // Función para sumar una clave específica de varios objetos dentro de un array en PHP
        function obtenerResultadoFinal($array, $clave)
        {
            $sum = 0;
            foreach ($array as $obj) {
                if (array_key_exists($clave, $obj)) {
                    $sum += $obj[$clave];
                }
            }
            return $sum;
        }

        // Clave específica que quieres sumar
        $claveEspecifica = "precio";

        // Calcular la suma y devolver el resultado
        $precioExtras = obtenerResultadoFinal($datosAlmacenados, $claveEspecifica);


        session(['precioExtras' => $precioExtras]);


        $res = [
            'success' => true,
            'message' => 'Registro exitoso',
            'data' => $datosAlmacenados,
            'precio_total' => $precioExtras
        ];

        echo json_encode($res);

    }

    public function pagar(Request $request)
    {

        $argsUsuario = $request->session()->get('argsUsuario');
        $argsMacota = $request->session()->get('argsMacota');
        $argsRecojo = $request->session()->get('argsRecojo');
        $precioTotal = $request->session()->get('precioTotal');
        $precioRecojo = $request->session()->get('argsCostoRecojo');
        $argsBolsa = $request->session()->get('argsBolsa');

        DB::table('usuarios')->insert($argsUsuario);

        $finduser = DB::table('usuarios')->where('email', $argsUsuario['email'])->first();

        $user_id = $finduser->id_usuario;

        session(['user_id' => $user_id]);

        $argsMacota["id_usuario"] = $user_id;

        DB::table('mascotas')->insert($argsMacota);

        $user_id_mascota = DB::table('mascotas')->where('nombre_mascota', $argsMacota['nombre_mascota'])->first();

        $argsRecojo["id_usuario"] = $user_id;
        $argsRecojo["id_mascota"] = $user_id_mascota->id_mascota;

        $argsCompostaje = [
            'estado' => 1
        ];

        $user_id_recojo_ida = DB::table('recojos')->insertGetId($argsRecojo);
        $argsRecojo["etapa"] = 2;
        $user_id_recojo_vuelta = DB::table('recojos')->insertGetId($argsRecojo);
        $user_id_compostaje = DB::table('compostajes')->insertGetId($argsCompostaje);
        // DB::table('compostajes')->insert($argsRecojo);

        // var_dump($user_id_compostaje);

        // $user_id_recojo = DB::table('recojos')->where('id_distrito', $argsRecojo['id_distrito'])->first();

        $argsPedido = [
            'estado' => 1,
            'costo_envio' => $precioRecojo,
            'igv' => $precioRecojo * 0.18 / 100,
            'total' => $precioTotal,
            'bolsa' => $argsBolsa["bolsa_compost"],
            'id_producto_seleccionado' => 1,
            'id_servicio' => 1,
            'id_usuario' => $user_id,
            'id_compostaje' => $user_id_compostaje,
            'id_mascota' => $user_id_mascota->id_mascota,
            'id_recojo_ida' => $user_id_recojo_ida,
            'id_recojo_vuelta' => $user_id_recojo_vuelta
            // 'fecha_recojo' => $argsRecojo['fecha_recojo'],
            // 'id_horario' => $argsRecojo['hora_recojo'],
            // 'id_distrito' => $argsRecojo['distrito_recojo'],
            // 'direccion_recojo' => $argsRecojo['direccion_recojo']
        ];

        // print_r($argsPedido);

        // @die;


        DB::table('pedidos')->insert($argsPedido);

        // $argsMacota = [
        //     'nombre_mascota' => $data['nombre_mascota'],
        //     'edad_mascota' => $data['edad_mascota'],
        //     'tipo_mascota' => $data['tipo_mascota'],
        //     'peso_mascota' => $data['peso_mascota'],
        //     'sexo_mascota' => $data['sexo_mascota'],
        //     'fecha_recojo' => $data['fecha_recojo'],
        // ];
        // $argsUsuario = [
        //     'nombres' => $data['nombres'],
        //     'apellidos' => $data['apellidos'],
        //     'edad' => $data['edad'],
        //     'celular' => $data['celular'],
        //     'email' => $data['email'],
        //     // 'contrasena' => $data['contrasena'],
        //     'contrasena' => sha1($data['contrasena']),
        //     'estado' => 1,
        //     'fecha_creacion' => date('Y-m-d H:i:s')
        // ];


        $argsMail = [
            'nombre_usuario' => $argsUsuario['nombres'] . ' ' . $argsUsuario['apellidos'],
            'nombre_mascota' => $argsMacota['nombre_mascota']
        ];

//        Mail::to(config('mail.admin_address'))->send(new RegistroUsuario($argsMail));
//         Mail::to(config('mail.admin_address'))->send(new RegistroUsuarioNuevo($args));


        // Session::put('user_id', $finduser->idusuario);
        $res = [
            'success' => true,
            'message' => 'Registro exitoso',
        ];

        echo json_encode($res);

        return redirect()->route('iniciar_sesion');


    }

    function validar_email()
    {
        $email = $_GET['email'];
        $user = DB::table('usuarios')->where('email', $email)->first();
        if ($user) {
            echo json_encode(['success' => false, 'message' => 'El email ya se encuentra registrado. ' .
                '<a href="' . route('iniciar_sesion') . '?redirect=registro-paso-2">Puedes iniciar sesión</a>']);
        } else {
            echo json_encode(['success' => true, 'message' => 'Email disponible']);
        }
    }
}
