<?php

namespace App\Http\Controllers;

use App\Mail\RegistroUsuario;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;
use DB;
use Carbon\Carbon;
use Session;
use App\Mail\EntregarBoleta;


class AdminController extends Controller
{
    //

    public function iniciar_sesion(Request $request)
    {
        return view('front.admin.iniciar_sesion');
    }

    public function loginaction(Request $request)
    {
        $data = $request->all();
        //return dd($data);
        $password = $data['password'];
        $usuario = DB::table('administradores')->where('email', $data['email'])
            ->where(function ($query) use ($password) {
                $query->where('contrasena', $password)
                    ->orWhere('contrasena', sha1($password));
            })->first();
        if ($usuario) {
            Session::put('user_id', $usuario->id_administrador);
            // return redirect()->route('operario_inicio');
            return response()->json(['message' => 'Usuario registrado correctamente']);

        } else {
            return response()->json(['message' => 'No se encontró el usuario y/o contraseña']);
        }
    }

    public function inicio(Request $request)
    {


        $administrador_id = $request->session()->get('user_id');

        $administrador = DB::table('administradores')->where('id_administrador', $administrador_id)->first();
        if (!$administrador) {
            return redirect()->route('admin_iniciar_sesion');
        } else {
            $administrador_id = session()->get('user_id');
        }

        $usuario = DB::table('administradores')->where('id_administrador', $administrador_id)->first();
        // $compostajes = DB::table('compostajes')->where('id_administrador', $administrador_id)->get();

        // Total Servicios en proceso
        $totalServiciosEnProceso = DB::table('pedidos')->where('pedidos.estado_pedido', '=', 1)->count();

        // Total Servicios completos
        $totalServiciosCompletos = DB::table('pedidos')->where('pedidos.estado_pedido', '=', 2)->count();

        // Total Servicios vuelve a casa
        $totalServiciosVuelveCasa = DB::table('pedidos')->where('pedidos.id_servicio', '=', 1)->count();
        $totalServiciosSiempreJuntos = DB::table('pedidos')->where('pedidos.id_servicio', '=', 2)->count();
        $totalServiciosVuelveCeniza = DB::table('pedidos')->where('pedidos.id_servicio', '=', 3)->count();

        // Total Servicios Vets
        $totalServiciosVets = DB::table('pedidos')->where('pedidos.id_servicio', '=', 5)->count();

        // Total Servicios Vets

        $ClientesVuelveaCasa = DB::table('pedidos')->where('pedidos.id_servicio', '=', 1)->join('usuarios', 'pedidos.id_usuario', '=', 'usuarios.id')->count();
        $ClientesSiempreJuntos = DB::table('pedidos')->where('pedidos.id_servicio', '=', 2)->join('usuarios', 'pedidos.id_usuario', '=', 'usuarios.id')->count();
        $ClientesVuelveCeniza = DB::table('pedidos')->where('pedidos.id_servicio', '=', 3)->join('usuarios', 'pedidos.id_usuario', '=', 'usuarios.id')->count();

        $inicioSemana = Carbon::now()->startOfWeek(); // Lunes de esta semana
        $finSemana = Carbon::now()->endOfWeek(); // Domingo de esta semana

        $objNuevosClientesEstaSemana = DB::table('pedidos')
            ->where('pedidos.id_servicio', '=', 1)
            ->whereBetween('pedidos.fecha_creacion', [$inicioSemana, $finSemana])
            ->join('mascotas', 'pedidos.id_mascota', '=', 'mascotas.id_mascota')
            ->join('usuarios', 'pedidos.id_usuario', '=', 'usuarios.id')->get();

        $fechaLimite = Carbon::now()->subDays(15); // Fecha hace 15 días
        $objNuevosClientes15Dias = DB::table('pedidos')
            ->where('pedidos.id_servicio', '=', 1)
            ->whereDate('pedidos.fecha_creacion', '>=', $fechaLimite)
            ->join('mascotas', 'pedidos.id_mascota', '=', 'mascotas.id_mascota')
            ->join('usuarios', 'pedidos.id_usuario', '=', 'usuarios.id')->get();

        $mesActual = Carbon::now()->month;
        $objNuevosClientes1mes = DB::table('pedidos')
            ->where('pedidos.id_servicio', '=', 1)
            ->whereMonth('pedidos.fecha_creacion', $mesActual)
            ->join('mascotas', 'pedidos.id_mascota', '=', 'mascotas.id_mascota')
            ->join('usuarios', 'pedidos.id_usuario', '=', 'usuarios.id')->get();

        // @dd($objNuevosClientes);

        // Total Mascotas
        $objMascotas = DB::table('pedidos')
            ->where('pedidos.id_servicio', '=', 1)
            ->join('mascotas', 'pedidos.id_mascota', '=', 'mascotas.id_mascota')
            ->orderBy('id_mascota', 'desc')->count();

        $startOfWeek = Carbon::now()->startOfWeek()->toDateString();
        $endOfWeek = Carbon::now()->endOfWeek()->toDateString();

        $objRecordatoriosCosechas = DB::table('pedidos')
            ->where('pedidos.id_servicio', '=', 1)
            ->join('compostajes', 'pedidos.id_compostaje', '=', 'compostajes.id_compostaje')
            ->join('mascotas', 'pedidos.id_mascota', '=', 'mascotas.id_mascota')
            ->whereBetween('compostajes.inicio_fecha', [$startOfWeek, $endOfWeek])
            ->get();

        $objRecordatoriosEntregas = DB::table('pedidos')
            ->where('pedidos.id_servicio', '=', 1)
            ->join('recojos', 'pedidos.id_recojo_vuelta', '=', 'recojos.id_recojo')
            ->whereBetween('recojos.fecha_recojo', [$startOfWeek, $endOfWeek])
            ->get();

        $mesActual = Carbon::now()->month;
        $anioActual = Carbon::now()->year;

        $objCompostajesMes = DB::table('compostajes')
            ->whereMonth('fin_fecha', $mesActual) // Filtra por el mes actual
            ->whereYear('fin_fecha', $anioActual) // Asegura que sea del año actual
            ->get();

        // @dd($objCompostajesMes);

        $totalCO2Ahorrado = 400 * $objCompostajesMes->sum('peso_cosecha') / 80;

        // $totalCantidadDistritos = DB::table('pedidos')
        //     ->leftJoin('recojos','pedidos.id_recojo_ida','=','recojos.id_recojo')
        //     ->leftJoin('distritos', 'distritos.id_distrito', '=', 'recojos.id_distrito')
        //     ->get();

        $totalCantidadDistritos = DB::table('distritos')
            ->leftJoin('recojos', 'distritos.id_distrito', '=', 'recojos.id_distrito')
            ->leftJoin('pedidos', 'recojos.id_recojo', '=', 'pedidos.id_recojo_ida')
            ->select('distritos.distrito', DB::raw('COUNT(pedidos.id_pedido) as cantidad_pedidos'))
            ->groupBy('distritos.id_distrito', 'distritos.distrito')
            ->orderBy('cantidad_pedidos', 'desc')
            ->limit(5)
            ->get();


        $años = [2023, 2024, 2025]; // Años que quieres mostrar
        $meses = range(1, 12);      // Meses del 1 al 12

        // Resultados reales desde la DB
        $serviciosMes = DB::table('pedidos')
            ->selectRaw('YEAR(fecha_creacion) as anio, MONTH(fecha_creacion) as mes, COUNT(*) as total')
            ->where('id_servicio', 1)
            ->whereIn(DB::raw('YEAR(fecha_creacion)'), $años)
            ->groupBy('anio', 'mes')
            ->get();

        // Combina los años y meses, asignando total 0 si no hay resultado
        $totalServiciosMes = collect();

        foreach ($años as $anio) {
            foreach ($meses as $mes) {

                $existente = $serviciosMes->filter(function ($r) use ($anio, $mes) {
                    return $r->anio == $anio && $r->mes == $mes;
                })->first();

                $totalServiciosMes->push((object)[
                    'anio' => $anio,
                    'mes' => $mes,
                    'total' => $existente->total ?? 0
                ]);
            }
        }

        $sumaTotalServiciosMes = $totalServiciosMes
            ->groupBy('mes')
            ->map(function ($items, $mes) {
                return (object)[
                    'mes' => $mes,
                    'total' => $items->sum('total')
                ];
            })->values();

        // @dd($totalServiciosMes);

        $servicios = [1, 2, 4];     // ID de servicios a considerar

        // Consulta agrupando por año e id_servicio
        $serviciosPorAño = DB::table('pedidos')
            ->selectRaw('YEAR(fecha_creacion) as anio, id_servicio, COUNT(*) as total')
            ->whereIn(DB::raw('YEAR(fecha_creacion)'), $años)
            ->whereIn('id_servicio', $servicios)
            ->groupBy('anio', 'id_servicio')
            ->get();

        // Crear colección final con todos los años y servicios (incluso si no hay datos)
        $totalServiciosAnio = collect();

        foreach ($años as $anio) {
            foreach ($servicios as $servicioId) {
                $existente = $serviciosPorAño->first(function ($item) use ($anio, $servicioId) {
                    return $item->anio == $anio && $item->id_servicio == $servicioId;
                });

                $totalServiciosAnio->push((object)[
                    'anio' => $anio,
                    'id_servicio' => $servicioId,
                    'total' => $existente->total ?? 0
                ]);
            }
        }

        // 1. Suma total de cada servicio en los 3 años
        $totalServiciosAnioPorServicio = $totalServiciosAnio
            ->groupBy('id_servicio')
            ->map(function ($items, $id_servicio) {
                return (object)[
                    'id_servicio' => $id_servicio,
                    'total' => $items->sum('total')
                ];
            })->values(); // Opcional: para reiniciar los índices

        // 2. Suma total por año de todos los servicios
        $totalServiciosAnioPorAnio = $totalServiciosAnio
            ->groupBy('anio')
            ->map(function ($items, $anio) {
                return (object)[
                    'anio' => $anio,
                    'total' => $items->sum('total')
                ];
            })->values(); // Opcional: para reiniciar los índices

        // @dd($totalServiciosAnioPorAnio);


        $montosPorServicioReal = DB::table('pagos')
            ->join('pedidos', 'pagos.id_pedido_pago', '=', 'pedidos.id_pedido')
            ->selectRaw('YEAR(pedidos.fecha_creacion) as anio, pedidos.id_servicio, SUM(pagos.total_pagar) as total_monto')
            ->whereIn(DB::raw('YEAR(pedidos.fecha_creacion)'), $años)
            ->whereIn('pedidos.id_servicio', $servicios)
            ->groupBy(DB::raw('YEAR(pedidos.fecha_creacion)'), 'pedidos.id_servicio')
            ->get();

        $montosPorServicio = collect();

        foreach ($años as $anio) {
            foreach ($servicios as $servicioId) {
                $existente = $montosPorServicioReal->first(function ($item) use ($anio, $servicioId) {
                    return $item->anio == $anio && $item->id_servicio == $servicioId;
                });

                $montosPorServicio->push((object)[
                    'anio' => $anio,
                    'id_servicio' => $servicioId,
                    'total_monto' => $existente->total_monto ?? 0
                ]);
            }
        }

        $totalMontoPorServicio = $montosPorServicio
            ->groupBy('id_servicio')
            ->map(function ($items, $id_servicio) {
                return (object)[
                    'id_servicio' => $id_servicio,
                    'total_monto' => $items->sum('total_monto')
                ];
            })->values();

        $totalMontoPorAnio = $montosPorServicio
            ->groupBy('anio')
            ->map(function ($items, $anio) {
                return (object)[
                    'anio' => $anio,
                    'total_monto' => $items->sum('total_monto')
                ];
            })->values();
        // @dd($montosPorServicio);


        $montosPorMesReal = DB::table('pagos')
            ->join('pedidos', 'pagos.id_pedido_pago', '=', 'pedidos.id_pedido')
            ->selectRaw('YEAR(pedidos.fecha_creacion) as anio, MONTH(pedidos.fecha_creacion) as mes, pedidos.id_servicio, SUM(pagos.total_pagar) as total_monto')
            ->whereIn(DB::raw('YEAR(pedidos.fecha_creacion)'), $años)
            ->whereIn('pedidos.id_servicio', $servicios)
            ->groupBy(DB::raw('YEAR(pedidos.fecha_creacion)'), DB::raw('MONTH(pedidos.fecha_creacion)'), 'pedidos.id_servicio')
            ->get();


        $montosPorMes = collect();

        foreach ($años as $anio) {
            foreach ($meses as $mes) {
                foreach ($servicios as $servicioId) {
                    $existente = $montosPorMesReal->first(function ($item) use ($anio, $mes, $servicioId) {
                        return $item->anio == $anio && $item->mes == $mes && $item->id_servicio == $servicioId;
                    });

                    $montosPorMes->push((object)[
                        'anio' => $anio,
                        'mes' => $mes,
                        'id_servicio' => $servicioId,
                        'total_monto' => $existente->total_monto ?? 0
                    ]);
                }
            }
        }

        // @dd($montosPorMes);


        $montosPorMes = collect();

        foreach ($años as $anio) {
            foreach ($meses as $mes) {
                foreach ($servicios as $servicioId) {
                    $existente = $montosPorMesReal->first(function ($item) use ($anio, $mes, $servicioId) {
                        return $item->anio == $anio && $item->mes == $mes && $item->id_servicio == $servicioId;
                    });

                    $montosPorMes->push((object)[
                        'anio' => $anio,
                        'mes' => $mes,
                        'id_servicio' => $servicioId,
                        'total_monto' => $existente->total_monto ?? 0
                    ]);
                }
            }
        }

        $montosPorMesMontosMensuales = $montosPorMes
            ->groupBy(function ($item) {
                return $item->anio . '-' . str_pad($item->mes, 2, '0', STR_PAD_LEFT);
            })
            ->map(function ($items) {
                $first = $items->first();
                return (object)[
                    'anio' => $first->anio,
                    'mes' => $first->mes,
                    'total_monto' => $items->sum('total_monto')
                ];
            })
            ->sortBy(fn($item) => $item->anio * 100 + $item->mes)
            ->values();

        // @dd($montosPorMesMontosMensuales);

        $montosTotalesPorMesGlobal = $montosPorMes
            ->groupBy('mes')
            ->map(function ($items, $mes) {
                return (object)[
                    'mes' => $mes,
                    'total_monto' => $items->sum('total_monto')
                ];
            })
            ->sortBy('mes')
            ->values();

        $montosTotalesPorAnio = $montosPorMes
            ->filter(function ($item) {
                return $item->anio == 2025;
            })
            ->groupBy(function ($item) {
                return $item->mes . '-' . $item->id_servicio;
            })
            ->map(function ($items) {
                $first = $items->first();
                return (object)[
                    'anio' => $first->anio,
                    'mes' => $first->mes,
                    'id_servicio' => $first->id_servicio,
                    'total_monto' => $items->sum('total_monto')
                ];
            })
            ->sortBy(fn($item) => $item->mes)
            ->values();

        // @dd($montosTotalesPorAnio);

        $cantidadTipoServicio = DB::table('pedidos')
            ->join('mascotas', 'pedidos.id_mascota', '=', 'mascotas.id_mascota')
            ->selectRaw("
                CASE
                    WHEN mascotas.peso_mascota BETWEEN 0 AND 1 THEN '0-1 kg'
                    WHEN mascotas.peso_mascota > 1 AND mascotas.peso_mascota <= 11 THEN '1-11 kg'
                    WHEN mascotas.peso_mascota > 11 AND mascotas.peso_mascota <= 25 THEN '11-25 kg'
                    ELSE '25+ kg'
                END as rango_peso,
                COUNT(*) as total
            ")
            ->groupBy('rango_peso')
            ->orderByRaw("MIN(mascotas.peso_mascota)") // opcional para ordenar los rangos
            ->get();

        // @dd($cantidadTipoServicio);

        $timelineConductor = DB::table('recojos')
            ->join('mascotas', 'recojos.id_mascota', '=', 'mascotas.id_mascota')
            ->whereDate('fecha_recojo', Carbon::today())
            ->where('etapa', 1)
            ->select('mascotas.nombre_mascota', 'recojos.estado_etapa')
            ->get();

        $timelineCompostajeIniciado = DB::table('compostajes')
            ->join('mascotas', 'compostajes.id_mascota', '=', 'mascotas.id_mascota')
            ->whereDate('fecha_recepcion', Carbon::today())
            ->select('mascotas.nombre_mascota')
            ->get();

        $timelineCompostajeFinalizado = DB::table('compostajes')
            ->join('mascotas', 'compostajes.id_mascota', '=', 'mascotas.id_mascota')
            ->whereDate('inicio_fecha', Carbon::today())
            ->select('mascotas.nombre_mascota')
            ->get();


        // @dd($timelineCompostajeIniciado);

        $promedioDiasInicioFin = DB::table('compostajes')
            ->whereNotNull('inicio_fecha')
            ->whereNotNull('fin_fecha')
            ->selectRaw('AVG(DATEDIFF(fin_fecha, inicio_fecha)) as promedio_dias')
            ->value('promedio_dias');

        $promedioDiasFinRecojosFin = DB::table('compostajes')
            ->join('recojos', 'compostajes.id_mascota', '=', 'recojos.id_mascota')
            ->whereNotNull('compostajes.fin_fecha')
            ->whereNotNull('recojos.fecha_recojo')
            ->where('recojos.etapa', 2)
            ->selectRaw('AVG(DATEDIFF(compostajes.fin_fecha, recojos.fecha_recojo)) as promedio_dias')
            ->value('promedio_dias');

        $promedioDiasInicioFinRecojos = DB::table('compostajes')
            ->join('recojos', 'compostajes.id_mascota', '=', 'recojos.id_mascota')
            ->whereNotNull('compostajes.inicio_fecha')
            ->whereNotNull('recojos.fecha_recojo')
            ->where('recojos.etapa', 2)
            ->selectRaw('AVG(DATEDIFF(compostajes.fin_fecha, recojos.fecha_recojo)) as promedio_dias')
            ->value('promedio_dias');

        // @dd($promedioDiasFinRecojosFin);


        return view('front.admin.inicio', [
            'objMascotas' => $objMascotas,
            'usuario' => $usuario,
            'totalServiciosEnProceso' => $totalServiciosEnProceso,
            'totalServiciosVuelveCasa' => $totalServiciosVuelveCasa,
            'totalServiciosVets' => $totalServiciosVets,
            'totalServiciosSiempreJuntos' => $totalServiciosSiempreJuntos,
            'ClientesVuelveaCasa' => $ClientesVuelveaCasa,
            'ClientesSiempreJuntos' => $ClientesSiempreJuntos,
            'totalServiciosCompletos' => $totalServiciosCompletos,
            'objNuevosClientesEstaSemana' => $objNuevosClientesEstaSemana,
            'objNuevosClientes15Dias' => $objNuevosClientes15Dias,
            'objNuevosClientes1mes' => $objNuevosClientes1mes,
            'objRecordatoriosCosechas' => $objRecordatoriosCosechas,
            'objRecordatoriosEntregas' => $objRecordatoriosEntregas,
            'objCompostajesMes' => $objCompostajesMes,
            'totalCO2Ahorrado' => $totalCO2Ahorrado,
            'totalCantidadDistritos' => $totalCantidadDistritos,
            'totalServiciosMes' => $totalServiciosMes,
            'sumaTotalServiciosMes' => $sumaTotalServiciosMes,
            'totalServiciosAnio' => $totalServiciosAnio,
            'totalServiciosAnioPorServicio' => $totalServiciosAnioPorServicio,
            'totalServiciosAnioPorAnio' => $totalServiciosAnioPorAnio,
            'montosPorServicio' => $montosPorServicio,
            'totalMontoPorServicio' => $totalMontoPorServicio,
            'totalMontoPorAnio' => $totalMontoPorAnio,
            'montosPorMesMontosMensuales' => $montosPorMesMontosMensuales,
            'montosTotalesPorMesGlobal' => $montosTotalesPorMesGlobal,
            'montosTotalesPorAnio' => $montosTotalesPorAnio,
            'cantidadTipoServicio' => $cantidadTipoServicio,
            'timelineConductor' => $timelineConductor,
            'timelineCompostajeIniciado' => $timelineCompostajeIniciado,
            'timelineCompostajeFinalizado' => $timelineCompostajeFinalizado,
            'promedioDiasInicioFin' => $promedioDiasInicioFin,
            'promedioDiasFinRecojosFin' => $promedioDiasFinRecojosFin,
            'promedioDiasInicioFinRecojos' => $promedioDiasInicioFinRecojos,

        ]);
    }

    public function cerrar_sesion_administrador(Request $request)
    {
        $request->session()->flush();
        // return redirect()->route('landing');
        return redirect()->route('admin_iniciar_sesion');
    }

    public function usuarios(Request $request)
    {
        $administrador_id = $request->session()->get('user_id');

        $administrador = DB::table('administradores')->where('id_administrador', $administrador_id)->first();
        if (!$administrador) {
            return redirect()->route('admin_iniciar_sesion');
        } else {
            $administrador_id = session()->get('user_id');
        }

        $usuario = DB::table('administradores')->where('id_administrador', $administrador_id)->first();
        $administradores = DB::table('administradores')->get();
        $operarios = DB::table('operarios')->get();
        $conductores = DB::table('conductores')->get();


        return view('front.admin.usuarios', compact('usuario', 'administradores', 'operarios', 'conductores'));
    }

    public function productos(Request $request)
    {
        $administrador_id = $request->session()->get('user_id');

        $administrador = DB::table('administradores')->where('id_administrador', $administrador_id)->first();
        if (!$administrador) {
            return redirect()->route('admin_iniciar_sesion');
        } else {
            $administrador_id = session()->get('user_id');
        }

        $usuario = DB::table('administradores')->where('id_administrador', $administrador_id)->first();
        $administradores = DB::table('administradores')->get();
        // $operarios = DB::table('operarios')->get();
        // $conductores = DB::table('conductores')->get();
        // $productos = DB::table('productos')->get();
        // $productos_maceta = DB::table('maceta_modelo')->get();
        if ($_POST) {
            $data = $request->all();
            // @dd($data);

            if ($data['tipo'] == 'producto') {

                $actualizarPrecio = $data['stock'];

                DB::table('productos')->where('id_producto', $data['id_producto'])->update([
                    'precio' => $actualizarPrecio,
                ]);
            }

            if ($data['tipo'] == 'maceta') {

                $actualizarAlmacen = $data['stock'] + $data['almacen'];

                DB::table('maceta_modelo')->where('id_maceta', $data['id_producto'])->update([
                    'stock' => $actualizarAlmacen,
                ]);
            }


            return redirect()->back()->with('exito', 'Se ha guardado la información correctamente');
        }

        $productos = DB::table('productos')
            // ->leftJoin('pedidos_servicios', 'productos.id_producto', '=', 'pedidos_servicios.producto_id')
            // ->leftJoin('pedidos_productos', 'productos.id_producto', '=', 'pedidos_productos.producto_id') // Nuevo JOIN
            ->leftJoin(DB::raw("(SELECT producto_id, COALESCE(SUM(cantidad), 0) as total_vendido FROM pedidos_servicios GROUP BY producto_id) as ps"), 'productos.id_producto', '=', 'ps.producto_id')
            ->leftJoin(DB::raw("(SELECT producto_id, COALESCE(SUM(cantidad), 0) as total_vendido FROM pedidos_productos GROUP BY producto_id) as pe"), 'productos.id_producto', '=', 'pe.producto_id')
            ->select(
                'productos.id_producto',
                'productos.nombre_producto',
                'productos.imagen',
                'productos.precio',
                'productos.stock',
                // DB::raw('SUM(pedidos_servicios.cantidad) AS total_vendido')
                // DB::raw('COALESCE(SUM(pedidos_productos.cantidad), 0) AS total_vendido') // Sumar la cantidad real vendida
                // DB::raw('COALESCE(SUM(pedidos_servicios.cantidad), 0) AS total_vendidos'), // Suma ambas cantidades
                // DB::raw('COALESCE(SUM(pedidos_productos.cantidad), 0)  AS total_vendidoe') // Suma ambas cantidades
                DB::raw('COALESCE(ps.total_vendido, 0) + COALESCE(pe.total_vendido, 0) AS total_vendido')
            )
            ->groupBy('productos.id_producto', 'productos.nombre_producto', 'productos.precio', 'productos.stock')
            ->get();

        $productos_maceta = DB::table('maceta_modelo')
            ->leftJoin(DB::raw("(SELECT modelo, COUNT(*) as total_servicios FROM pedidos_servicios WHERE producto_id = 1 GROUP BY modelo) as ps"), 'maceta_modelo.id_maceta', '=', 'ps.modelo')
            ->leftJoin(DB::raw("(SELECT modelo, COUNT(*) as total_extras FROM pedidos_productos WHERE producto_id = 1 GROUP BY modelo) as pe"), 'maceta_modelo.id_maceta', '=', 'pe.modelo')
            ->select(
                'maceta_modelo.id_maceta',
                'maceta_modelo.nombre',
                'maceta_modelo.modelo',
                'maceta_modelo.altura',
                'maceta_modelo.diametro',
                'maceta_modelo.stock',
                DB::raw('COALESCE(ps.total_servicios, 0) + COALESCE(pe.total_extras, 0) AS total_registradas')
            // DB::raw('COALESCE(ps.total_servicios, 0) + COALESCE(pe.total_extras, 0) AS total_registradas')
            // DB::raw('COALESCE(ps.total_servicios, 0)  AS total_registradas')
            // DB::raw('COALESCE(pe.total_extras, 0)  AS total_registradas')
            )
            ->get();


        // dd($productos_maceta);


        return view('front.admin.productos', compact('usuario', 'administradores', 'productos_maceta', 'productos'));
    }

    public function admin_usuarios_id($id)
    {
        // var_dump($id);
        $administrador_id = session()->get('user_id');

        $administrador = DB::table('administradores')->where('id_administrador', $administrador_id)->first();
        if (!$administrador) {
            return redirect()->route('admin_iniciar_sesion');
        } else {
            $administrador_id = session()->get('user_id');
        }

        $usuario = DB::table('administradores')->where('id_administrador', $id)->first();

        return view('front.admin.editar-perfil', compact('usuario'));
    }

    public function operario_usuarios_id($id)
    {
        // var_dump($id);
        $administrador_id = session()->get('user_id');

        $administrador = DB::table('administradores')->where('id_administrador', $administrador_id)->first();
        if (!$administrador) {
            return redirect()->route('admin_iniciar_sesion');
        } else {
            $administrador_id = session()->get('user_id');
        }

        $usuario = DB::table('operarios')->where('id_operario', $id)->first();

        return view('front.admin.editar-perfil', compact('usuario'));
    }

    public function conductor_usuarios_id($id)
    {
        // var_dump($id);
        $administrador_id = session()->get('user_id');

        $administrador = DB::table('administradores')->where('id_administrador', $administrador_id)->first();
        if (!$administrador) {
            return redirect()->route('admin_iniciar_sesion');
        } else {
            $administrador_id = session()->get('user_id');
        }

        $usuario = DB::table('administrador')->where('id_conductor', $id)->first();

        return view('front.admin.editar-perfil', compact('usuario'));
    }

    public function bd_vuelve_a_casa(Request $request)
    {
        $administrador_id = $request->session()->get('user_id');

        if ($_POST) {
            $data = $request->all();
            // @dd($data);die;


            if ($data['action'] == 'eliminar') {


                // Eliminamos relaciones en orden de dependencias
                DB::table('encuestas')->where('id_usuario', $data['id_usuario'])->delete();
                DB::table('mascotas')->where('id_usuario', $data['id_usuario'])->delete();
                DB::table('productos_seleccionado')->where('id_usuario', $data['id_usuario'])->delete();
                DB::table('recojos')->where('id_usuario', $data['id_usuario'])->delete();
                DB::table('visitas')->where('id_usuario', $data['id_usuario'])->delete();


                // Finalmente eliminamos el pedido
                DB::table('pedidos')->where('id_usuario', $data['id_usuario'])->delete();
                DB::table('usuarios')->where('id', $data['id_usuario'])->delete();

                return redirect()->back()->with('exito', 'Se ha eliminado la información correctamente');
            } else {
                DB::table('pedidos')->where('pedidos.id_pedido', '=', $data['id_pedido'])->update([
                    'comentario_pedido' => $data['comentario'],
                ]);
                return redirect()->back()->with('exito', 'Se ha guardado la información correctamente');
            }

        }


        $administrador = DB::table('administradores')->where('id_administrador', $administrador_id)->first();
        if (!$administrador) {
            return redirect()->route('admin_iniciar_sesion');
        } else {
            $administrador_id = session()->get('user_id');
        }

        $usuario = DB::table('administradores')->where('id_administrador', $administrador_id)->first();
        // $compostajes = DB::table('compostajes')->where('id_administrador', $administrador_id)->get();


        $objUsers = DB::table('pedidos')
            ->where('pedidos.id_servicio', '=', 1)
            // ->where('pedidos.id_pedido', '=', 13)
            ->leftJoin('usuarios', 'pedidos.id_usuario', '=', 'usuarios.id')
            ->leftJoin('edades', 'usuarios.edad', '=', 'edades.id_edad')
            ->leftJoin('mascotas', 'pedidos.id_mascota', '=', 'mascotas.id_mascota')
            ->leftJoin('compostajes', 'pedidos.id_compostaje', '=', 'compostajes.id_compostaje')
            ->leftJoin('recojos as recojo_ida', 'pedidos.id_recojo_ida', '=', 'recojo_ida.id_recojo')
            ->leftJoin('recojos as recojo_vuelta', 'pedidos.id_recojo_vuelta', '=', 'recojo_vuelta.id_recojo')
            ->leftJoin('distritos as distrito_ida', 'recojo_ida.id_distrito', '=', 'distrito_ida.id_distrito')
            ->leftJoin('distritos as distrito_vuelta', 'recojo_vuelta.id_distrito', '=', 'distrito_vuelta.id_distrito')
            ->leftJoin('horarios as horario_ida', 'recojo_ida.id_horario', '=', 'horario_ida.id_horario')
            ->leftJoin('horarios as horario_vuelta', 'recojo_vuelta.id_horario', '=', 'horario_vuelta.id_horario')
            ->leftJoin('conductores as conductor_ida', 'recojo_ida.id_conductor', '=', 'conductor_ida.id_conductor')
            ->leftJoin('conductores as conductor_vuelta', 'recojo_vuelta.id_conductor', '=', 'conductor_vuelta.id_conductor')
            ->leftJoin('encuestas', 'pedidos.id_usuario', '=', 'encuestas.id_usuario')
            // ->leftJoin('pagos', 'pedidos.id_pedido', '=', 'pagos.id_pedido_pago')
            ->select(
                'pedidos.*',
                'usuarios.*',
                'edades.*',
                'mascotas.*',
                'compostajes.*',
                // 'encuestas.*',
                'encuestas.opcion as encuesta_opcion',
                'encuestas.otro as encuesta_otro',
                // 'pagos.*',
                // 'pedidos_productos.*',
                // Campos de recojo_ida
                DB::raw('(select COUNT(*) from pedidos_productos where pedido_id = pedidos.id_pedido and producto_id = 1) as total_producto_1'),
                DB::raw('(select COUNT(*) from pedidos_productos where pedido_id = pedidos.id_pedido and producto_id = 2) as total_producto_2'),
                DB::raw('(select COUNT(*) from pedidos_productos where pedido_id = pedidos.id_pedido and producto_id = 3) as total_producto_3'),
                DB::raw('(select COUNT(*) from pedidos_productos where pedido_id = pedidos.id_pedido and producto_id = 4) as total_producto_4'),
                DB::raw('(select COUNT(*) from pedidos_productos where pedido_id = pedidos.id_pedido and producto_id = 5) as total_producto_5'),
                DB::raw('(select COUNT(*) from pedidos_productos where pedido_id = pedidos.id_pedido and producto_id = 6) as total_producto_6'),
                'recojo_ida.fecha_recojo as ida_fecha',
                'horario_ida.horario as ida_hora',
                'recojo_ida.direccion_recojo as ida_direccion',
                'distrito_ida.distrito as ida_distrito',
                'conductor_ida.nombre_conductor as ida_condutor',
                // Campos de recojo_vuelta
                'recojo_vuelta.fecha_recojo as vuelta_fecha',
                'horario_vuelta.horario as vuelta_hora',
                'recojo_vuelta.direccion_recojo as vuelta_direccion',
                'distrito_vuelta.distrito as vuelta_distrito',
                'conductor_vuelta.nombre_conductor as vuelta_condutor',
            )
            ->orderBy('id_pedido', 'desc')
            ->get();

        // @dd($objUsers);

        // // 2. Consulta todos los extras agrupados por pedido_id
        // $pedidosExtras = DB::table('pedidos_productos')->get()->groupBy('pedido_id');

        // // @dd($pedidosExtras);

        // // 3. Asignar a cada pedido sus extras correspondientes
        // foreach ($objUsers as $pedido) {
        //     $pedido->extras = $pedidosExtras[$pedido->id_pedido] ?? collect();
        // }

        // @dd($objUsers);

        $objMascotas = DB::table('pedidos')->where('pedidos.id_servicio', '=', 1)
            ->join('mascotas', 'pedidos.id_mascota', '=', 'mascotas.id_mascota')
            ->join('compostajes', 'pedidos.id_compostaje', '=', 'compostajes.id_compostaje')
            // ->join('mascotas','pedidos.id_mascota','=','mascotas.id_mascota')
            ->get();

        // @dd($objMascotas);

        $objDireccionRecojosIda = DB::table('pedidos')->where('pedidos.id_servicio', '=', 1)
            ->join('usuarios', 'pedidos.id_usuario', '=', 'usuarios.id')
            ->join('mascotas', 'pedidos.id_mascota', '=', 'mascotas.id_mascota')
            ->join('recojos', 'pedidos.id_recojo_ida', '=', 'recojos.id_recojo')
            ->join('distritos', 'recojos.id_distrito', '=', 'distritos.id_distrito')
            ->join('horarios', 'recojos.id_horario', '=', 'horarios.id_horario')
            ->get();

        // @dd($objDireccionRecojosIda);

        $objDireccionRecojosVuelta = DB::table('pedidos')->where('pedidos.id_servicio', '=', 1)
            ->join('usuarios', 'pedidos.id_usuario', '=', 'usuarios.id')
            ->join('mascotas', 'pedidos.id_mascota', '=', 'mascotas.id_mascota')
            ->join('recojos', 'pedidos.id_recojo_vuelta', '=', 'recojos.id_recojo')
            ->join('distritos', 'recojos.id_distrito', '=', 'distritos.id_distrito')
            ->join('horarios', 'recojos.id_horario', '=', 'horarios.id_horario')
            ->get();

        $objPedidoExtras = DB::table('pedidos_productos')
            ->join('pedidos', 'pedidos.id_pedido', '=', 'pedidos_productos.id')
            ->join('usuarios', 'pedidos.id_usuario', '=', 'usuarios.id')
            ->join('mascotas', 'pedidos.id_mascota', '=', 'mascotas.id_mascota')
            ->get();

        // @dd($objPedidoExtras);

        $objPagos = DB::table('pagos')
            // ->join('pedidos','pedidos.id_pedido','=','pagos.id_pago')
            // ->join('usuarios','pedidos.id_usuario','=','usuarios.id')
            // ->join('mascotas','pedidos.id_mascota','=','mascotas.id_mascota')
            ->get();
//        @dd($objPagos);

        return view('front.admin.bd_vuelve_a_casa', [
            'objUsers' => $objUsers,
            'objMascotas' => $objMascotas,
            'usuario' => $usuario,
            'objDireccionRecojosIda' => $objDireccionRecojosIda,
            'objDireccionRecojosVuelta' => $objDireccionRecojosVuelta,
            'objPedidoExtras' => $objPedidoExtras,
            'objPagos' => $objPagos
        ]);
    }

    public function bd_vuelve_ceniza(Request $request)
    {
        $administrador_id = $request->session()->get('user_id');

        $administrador = DB::table('administradores')->where('id_administrador', $administrador_id)->first();
        if (!$administrador) {
            return redirect()->route('admin_iniciar_sesion');
        } else {
            $administrador_id = session()->get('user_id');
        }

        $usuario = DB::table('administradores')->where('id_administrador', $administrador_id)->first();
        // $compostajes = DB::table('compostajes')->where('id_administrador', $administrador_id)->get();

        $objUsers = DB::table('pedidos')
            ->where('pedidos.id_servicio', '=', 1)
            ->join('usuarios', 'pedidos.id_usuario', '=', 'usuarios.id')
            ->select('usuarios.id', 'usuarios.nombres', 'usuarios.apellidos', 'usuarios.fecha_creacion', 'usuarios.email', 'usuarios.celular', 'usuarios.edad')
            ->orderBy('id_usuario', 'desc')->get();

        $objMascotas = DB::table('pedidos')
            ->where('pedidos.id_servicio', '=', 1)
            ->join('mascotas', 'pedidos.id_mascota', '=', 'mascotas.id_mascota')
            ->select('mascotas.id_mascota', 'mascotas.nombre_mascota', 'mascotas.edad_mascota', 'mascotas.peso_mascota', 'mascotas.sexo_mascota', 'mascotas.fecha_recojo', 'mascotas.tipo_mascota')
            ->orderBy('id_mascota', 'desc')->get();

        $objDirecciones = DB::table('pedidos')
            ->where('pedidos.id_servicio', '=', 1)
            ->join('recojos', 'pedidos.id_recojo_ida', '=', 'recojos.id_recojo')
            ->select('recojos.id_mascota', 'recojos.direccion_recojo', 'recojos.estado', 'recojos.fecha_recojo', 'recojos.id_distrito', 'recojos.id_horario', 'recojos.etapa')
            ->orderBy('id_recojo', 'desc')->get();


        // var_dump($objUsers);

        return view('front.admin.bd_vuelve_ceniza', [
            'objUsers' => $objUsers, 'objMascotas' => $objMascotas, 'objDirecciones' => $objDirecciones, 'usuario' => $usuario
        ]);
    }

    public function bd_vuelve_solidario(Request $request)
    {
        $administrador_id = $request->session()->get('user_id');

        $administrador = DB::table('administradores')->where('id_administrador', $administrador_id)->first();
        if (!$administrador) {
            return redirect()->route('admin_iniciar_sesion');
        } else {
            $administrador_id = session()->get('user_id');
        }

        $usuario = DB::table('administradores')->where('id_administrador', $administrador_id)->first();
        // $compostajes = DB::table('compostajes')->where('id_administrador', $administrador_id)->get();

        $objUsers = DB::table('pedidos')
            ->where('pedidos.id_servicio', '=', 4)
            ->join('usuarios', 'pedidos.id_usuario', '=', 'usuarios.id')
            ->select('usuarios.id', 'usuarios.nombres', 'usuarios.apellidos', 'usuarios.fecha_creacion', 'usuarios.email', 'usuarios.celular', 'usuarios.edad')
            ->orderBy('id_usuario', 'desc')->get();

        // var_dump($objUsers);

        $objMascotas = DB::table('pedidos')
            ->where('pedidos.id_servicio', '=', 4)
            ->join('mascotas', 'pedidos.id_mascota', '=', 'mascotas.id_mascota')
            ->select('mascotas.id_mascota', 'mascotas.nombre_mascota', 'mascotas.edad_mascota', 'mascotas.peso_mascota', 'mascotas.sexo_mascota', 'mascotas.fecha_recojo', 'mascotas.tipo_mascota')
            ->orderBy('id_mascota', 'desc')->get();

        $objDirecciones = DB::table('pedidos')
            ->where('pedidos.id_servicio', '=', 4)
            ->join('recojos', 'pedidos.id_recojo_ida', '=', 'recojos.id_recojo')
            ->select('recojos.id_mascota', 'recojos.direccion_recojo', 'recojos.estado', 'recojos.fecha_recojo', 'recojos.id_distrito', 'recojos.id_horario', 'recojos.etapa')
            ->orderBy('id_recojo', 'desc')->get();


        return view('front.admin.bd_vuelve_solidario', [
            'objUsers' => $objUsers, 'objMascotas' => $objMascotas, 'objDirecciones' => $objDirecciones, 'usuario' => $usuario
        ]);
    }

    public function bd_plan_siempre_juntos(Request $request)
    {
        $administrador_id = $request->session()->get('user_id');

        $administrador = DB::table('administradores')->where('id_administrador', $administrador_id)->first();
        if (!$administrador) {
            return redirect()->route('admin_iniciar_sesion');
        } else {
            $administrador_id = session()->get('user_id');
        }

        $usuario = DB::table('administradores')->where('id_administrador', $administrador_id)->first();
        // $compostajes = DB::table('compostajes')->where('id_administrador', $administrador_id)->get();

        $objUsers = DB::table('pedidos')->where('pedidos.id_servicio', '=', 2)
            ->join('usuarios', 'pedidos.id_usuario', '=', 'usuarios.id')
            ->leftJoin('edades', 'usuarios.edad', '=', 'edades.id_edad')
            ->join('encuestas', 'pedidos.id_usuario', '=', 'encuestas.id_usuario')
            ->get();
        // @dd($objUsers);

        $objMascotas = DB::table('pedidos')->where('pedidos.id_servicio', '=', 2)
            ->join('mascotas', 'pedidos.id_mascota', '=', 'mascotas.id_mascota')
            ->join('compostajes', 'pedidos.id_compostaje', '=', 'compostajes.id_compostaje')
            // ->join('mascotas','pedidos.id_mascota','=','mascotas.id_mascota')
            ->get();

        // @dd($objMascotas);

        $objDireccionRecojosIda = DB::table('pedidos')->where('pedidos.id_servicio', '=', 2)
            ->join('usuarios', 'pedidos.id_usuario', '=', 'usuarios.id')
            ->join('mascotas', 'pedidos.id_mascota', '=', 'mascotas.id_mascota')
            ->join('recojos', 'pedidos.id_recojo_ida', '=', 'recojos.id_recojo')
            ->join('distritos', 'recojos.id_distrito', '=', 'distritos.id_distrito')
            ->join('horarios', 'recojos.id_horario', '=', 'horarios.id_horario')
            ->get();

        // @dd($objDireccionRecojosIda);

        $objDireccionRecojosVuelta = DB::table('pedidos')->where('pedidos.id_servicio', '=', 2)
            ->join('usuarios', 'pedidos.id_usuario', '=', 'usuarios.id')
            ->join('mascotas', 'pedidos.id_mascota', '=', 'mascotas.id_mascota')
            ->join('recojos', 'pedidos.id_recojo_vuelta', '=', 'recojos.id_recojo')
            ->join('distritos', 'recojos.id_distrito', '=', 'distritos.id_distrito')
            ->join('horarios', 'recojos.id_horario', '=', 'horarios.id_horario')
            ->get();

        $objPedidoExtras = DB::table('pedidos_productos')
            ->join('pedidos', 'pedidos.id_pedido', '=', 'pedidos_productos.id')
            ->join('usuarios', 'pedidos.id_usuario', '=', 'usuarios.id')
            ->join('mascotas', 'pedidos.id_mascota', '=', 'mascotas.id_mascota')
            ->where('pedidos.id_servicio', '=', 2)
            ->get();

        // @dd($objPedidoExtras);

        $objPagos = DB::table('pagos')
            ->join('pedidos', 'pedidos.id_pedido', '=', 'pagos.id_pago')
            ->join('usuarios', 'pedidos.id_usuario', '=', 'usuarios.id')
            ->join('mascotas', 'pedidos.id_mascota', '=', 'mascotas.id_mascota')
            ->where('pedidos.id_servicio', '=', 2)
            ->get();
        // @dd($objPagos);

        return view('front.admin.bd_plan_siempre_juntos', [
            'objUsers' => $objUsers,
            'objMascotas' => $objMascotas,
            'usuario' => $usuario,
            'objDireccionRecojosIda' => $objDireccionRecojosIda,
            'objDireccionRecojosVuelta' => $objDireccionRecojosVuelta,
            'objPedidoExtras' => $objPedidoExtras,
            'objPagos' => $objPagos
        ]);
    }

    public function pedido(Request $request)
    {
        $administrador_id = $request->session()->get('user_id');

        $administrador = DB::table('administradores')->where('id_administrador', $administrador_id)->first();
        if (!$administrador) {
            return redirect()->route('admin_iniciar_sesion');
        } else {
            $administrador_id = session()->get('user_id');
        }

        $usuario = DB::table('administradores')->where('id_administrador', $administrador_id)->first();

        // 1 Pedido Nuevo
        // 2 En Recojo Ida
        // 3 En Compostario
        // 4 En Cosecha
        // 5 En Recojo Vuelta$objPedidosPendientes
        // 6 Finalizado

        // $objPedidos = DB::table('pedidos')->where('pedidos.id_servicio','=', 1)->join('mascotas','pedidos.id_mascota','=','mascotas.id_mascota')->get();

        $objPedidosPendientes = DB::table('pedidos')->whereIn('pedidos.pedido_activo', [0, 2])->join('mascotas', 'pedidos.id_mascota', '=', 'mascotas.id_mascota')->get();
        $objPedidosPorProgramar = DB::table('pedidos')
            ->where('pedidos.pedido_activo', 1)
            ->where('pedidos.estado_pedido', 0)
            ->join('mascotas', 'pedidos.id_mascota', '=', 'mascotas.id_mascota')
            ->get();
        $objPedidosEnRecojo = DB::table('pedidos')->where('pedidos.estado_pedido', '=', 1)->join('mascotas', 'pedidos.id_mascota', '=', 'mascotas.id_mascota')->get();
        $objPedidosEnCompostario = DB::table('pedidos')->where('pedidos.estado_pedido', '=', 2)->join('mascotas', 'pedidos.id_mascota', '=', 'mascotas.id_mascota')->get();
        $objPedidosEnLogistica = DB::table('pedidos')->where('pedidos.estado_pedido', '=', 3)->join('mascotas', 'pedidos.id_mascota', '=', 'mascotas.id_mascota')->get();
        $objPedidosEnEntregaDeMaceta = DB::table('pedidos')->where('pedidos.estado_pedido', '=', 4)->join('mascotas', 'pedidos.id_mascota', '=', 'mascotas.id_mascota')->get();
        $objPedidosFinalizados = DB::table('pedidos')->where('pedidos.estado_pedido', '=', 5)->join('mascotas', 'pedidos.id_mascota', '=', 'mascotas.id_mascota')->get();

//        @dd($objPedidosPendientes);


        // var_dump($objPedidos);

        // 1	Vuelve Cenizas
        // 2	Plan Siempre Juntos
        // 3	Vuelve a Casa
        // 4	Vuelve Solidarios
        // 5	Servicios Vets

        $objServicioVuelveACasa = DB::table('pedidos')->where('pedidos.id_servicio', '=', 1)->where('pedidos.estado_pedido', '=', 5)->join('mascotas', 'pedidos.id_mascota', '=', 'mascotas.id_mascota')->get();
        $objServicioPlanSiempreJuntos = DB::table('pedidos')->where('pedidos.id_servicio', '=', 2)->where('pedidos.estado_pedido', '=', 5)->join('mascotas', 'pedidos.id_mascota', '=', 'mascotas.id_mascota')->get();
        $objServicioVuelveCenizas = DB::table('pedidos')->where('pedidos.id_servicio', '=', 3)->where('pedidos.estado_pedido', '=', 5)->join('mascotas', 'pedidos.id_mascota', '=', 'mascotas.id_mascota')->get();
        $objServicioVuelveSolidarios = DB::table('pedidos')->where('pedidos.id_servicio', '=', 4)->where('pedidos.estado_pedido', '=', 5)->join('mascotas', 'pedidos.id_mascota', '=', 'mascotas.id_mascota')->get();
        $objServicioVets = DB::table('pedidos')->where('pedidos.id_servicio', '=', 5)->where('pedidos.estado_pedido', '=', 5)->join('mascotas', 'pedidos.id_mascota', '=', 'mascotas.id_mascota')->get();

        return view('front.admin.compostario', [
            'usuario' => $usuario,
            'objPedidosPendientes' => $objPedidosPendientes,
            'objPedidosPorProgramar' => $objPedidosPorProgramar,
            'objPedidosEnRecojo' => $objPedidosEnRecojo,
            'objPedidosEnCompostario' => $objPedidosEnCompostario,
            'objPedidosEnLogistica' => $objPedidosEnLogistica,
            'objPedidosEnEntregaDeMaceta' => $objPedidosEnEntregaDeMaceta,
            'objPedidosFinalizados' => $objPedidosFinalizados,
            'objServicioVuelveCenizas' => $objServicioVuelveCenizas,
            'objServicioPlanSiempreJuntos' => $objServicioPlanSiempreJuntos,
            'objServicioVuelveACasa' => $objServicioVuelveACasa,
            'objServicioVuelveSolidarios' => $objServicioVuelveSolidarios,
            'objServicioVets' => $objServicioVets

        ]);
    }

    public function pedido_id($id, Request $request)
    {
        $administrador_id = $request->session()->get('user_id');

        $data = $request->all();

//        @dd($$request);


        $administrador = DB::table('administradores')->where('id_administrador', $administrador_id)->first();
        if (!$administrador) {
            return redirect()->route('admin_iniciar_sesion');
        } else {
            $administrador_id = session()->get('user_id');
        }

        if ($_POST) {


            $data = $request->all();
//            @dd($data);

            if (isset($data['action']) && $data['action'] == 'restablecer-contrasenia') {

                // if (!$user_id) {
//                @dd($data);

                $usuario = DB::table('usuarios')->where('id', $data['id_usuario'])->first();
                $pedido = DB::table('pedidos')->where('id_pedido', $data['id_pedido'])->first();
                $argsMascota = DB::table('mascotas')->where('id_mascota', $pedido->id_mascota)->first();

                $argsMail = [
                    'nombre_usuario' => $usuario->nombres . ' ' . $usuario->apellidos,
                    'nombre_mascota' => $argsMascota->nombre_mascota,
                    'acompaniar_mascota' => $pedido->acompaniar_mascota,
                    'token_reset' => $usuario->token_reset

                ];

                Mail::to($usuario->email)->send(new RegistroUsuario($argsMail));
                
                return redirect()->back()->with('exito', 'Se ha enviado el correo al cliente correctamente');
            }

            if (isset($data['action']) && $data['action'] == 'eliminar') {


                // Eliminamos relaciones en orden de dependencias
                DB::table('encuestas')->where('id_usuario', $data['id_usuario'])->delete();
                DB::table('mascotas')->where('id_usuario', $data['id_usuario'])->delete();
                DB::table('productos_seleccionado')->where('id_usuario', $data['id_usuario'])->delete();
                DB::table('recojos')->where('id_usuario', $data['id_usuario'])->delete();
                DB::table('visitas')->where('id_usuario', $data['id_usuario'])->delete();


                // Finalmente eliminamos el pedido
                DB::table('pedidos')->where('id_usuario', $data['id_usuario'])->delete();
                DB::table('usuarios')->where('id', $data['id_usuario'])->delete();

                return redirect()->route('admin_pedido')->with('exito', 'Se ha eliminado la información correctamente');
            }

            if (isset($data['servicio']) && $data['servicio'] == 'siempre-juntos') {

                // use Carbon\Carbon;
                $fechaBase = Carbon::parse($data['fecha_recojo']) ?? Carbon::parse(date('Y-m-d'));

                $fechaNueva = $fechaBase->copy()->addWeeks(6); // Sumar 6 semanas
                $fechaFormateada = $fechaNueva->format('Y-m-d'); // Formato YYYY-MM-DD

                // echo $fechaFormateada;

                $argsCompostaje = [
                    'id_mascota' => $data['id_mascota'],
                    'estado' => 1,
                    'id_operario' => 1,
                    'operario_confirmado' => 1,
                    'fin_tentativo' => $fechaFormateada
                ];

                $compostaje_id = DB::table('compostajes')->insertGetId($argsCompostaje);


                DB::table('pedidos')->where('id_pedido', $data['id_pedido'])->update([
                    'pedido_activo' => 1,
                    'id_compostaje' => $compostaje_id,
                    'acompaniar_mascota' => false,
                    'traslado_mascota' => 'propio',
                ]);

                DB::table('recojos')->where('id_recojo', $data['id_recojo_ida'])->update([
                    'fecha_recojo' => $fechaBase,
                    'id_horario' => $data['hora_recojo'] ?? 7,
                    'etapa' => 1,
                    'estado' => 1,
                    'id_conductor' => 3,
                    'conductor_confirmado' => 1
                ]);

            }

            if (isset($data['servicio']) && $data['servicio'] == 'vuelve-a-casa') {

                $usuario = DB::table('usuarios')->where('id', $data['id_usuario'])->first();

                DB::table('pedidos')->where('id_pedido', $data['id_pedido'])->update([
                    'pedido_activo' => 1
                ]);
            }

            return redirect()->back()->with('exito', 'Se ha activado al cliente correctamente');
        }

        // $conductor = DB::table('conductores')->where('id_conductor', $conductor_id)->first();

        $hora_actual = Carbon::now()->addHour()->format('H:i'); // Formato 24h (Ejemplo: "11:00")
        $hora_limite = "23:00"; // 10:00 PM en formato 24h

        $horarios = \Illuminate\Support\Facades\DB::table('horarios')->select('horario', 'id_horario', 'costo')->get()->filter(function ($horario) use ($hora_actual, $hora_limite) {
            $hora_inicio = Carbon::parse(trim(explode('-', $horario->horario)[0]));
            return $hora_inicio->between($hora_actual, $hora_limite);
        });

        $objPedidos = DB::table('pedidos')
            ->where('pedidos.id_pedido', '=', $id)
            ->join('usuarios', 'pedidos.id_usuario', '=', 'usuarios.id')
            ->first();

//        @dd($objPedidos);


        $conductores = DB::table('conductores')->get();

        // var_dump($recojo);

        $recojo_ida = DB::table('recojos')
            ->where('id_recojo', $objPedidos->id_recojo_ida)
            ->leftJoin('conductores', 'recojos.id_conductor', '=', 'conductores.id_conductor')
            ->leftJoin('horarios', 'recojos.id_horario', '=', 'horarios.id_horario')
            ->first();

        // var_dump($recojo_ida);

        $recojo_vuelta = DB::table('recojos')
            ->where('id_recojo', $objPedidos->id_recojo_vuelta)
            ->leftJoin('conductores', 'recojos.id_conductor', '=', 'conductores.id_conductor')
            ->leftJoin('horarios', 'recojos.id_horario', '=', 'horarios.id_horario')
            ->first();

        $usuario = DB::table('usuarios')->where('id', $objPedidos->id_usuario)->first();
        $mascota = DB::table('mascotas')->where('id_mascota', $objPedidos->id_mascota)->first();


        $objCompostajes =
            DB::table('compostajes')
                ->where('id_compostaje', $objPedidos->id_compostaje)
                ->leftJoin('operarios', 'compostajes.id_operario', '=', 'operarios.id_operario')
                ->first();

        // dd($objCompostajes);

        $monitoreos = DB::table('monitoreoOperario')->where('id_compostaje', $objPedidos->id_compostaje)->get();
        // DB::table('compostajes')->where('id_compostaje', $id)->first();
        $ultimoNumero = $monitoreos->count();


        $operarios = DB::table('operarios')->get();

//        @dd($objPedidos);

        $objConstancias = DB::table('pagos_constancias')
            ->where('pagos_constancias.id_pedido', '=', $objPedidos->id_pedido)
            // ->join('usuarios','pedidos.id_usuario','=','usuarios.id')
            ->get();

//        $objPagosRaw = DB::table('pagos')
//            ->where('pagos.id_pedido_pago', $objPedidos->id_pedido)
////            ->leftJoin('pagos_cuotas', 'pagos.id', '=', 'pagos_cuotas.id_pago')
//            ->get();
        $objPagosRaw = DB::table('pagos')
            ->where('pagos.id_pedido_pago', $objPedidos->id_pedido)
            ->leftJoin('pagos_cuotas', 'pagos.id_cuota_pago', '=', 'pagos_cuotas.id_pago')
            ->leftJoin('pedidos', 'pedidos.id_pedido', '=', 'pagos.id_pedido_pago')
            ->leftJoin('servicios', 'servicios.id_servicio', '=', 'pedidos.id_servicio')
            ->select(
                'pagos.id as pago_id',
                'pagos.user_id',
                'pagos.id_pedido_pago',
                'pagos.id_cuota_pago',
                'pagos.tipo_pago',
                'pagos.cantidad_cuotas',
                'pagos.monto_servicio',
                'pagos.fee_adicional',
                'pagos.igv',
                'pagos.total_pagar',
                'pagos.costo_envio',
                'pagos.pago_extra',
                'pagos.metodo_pago',
                'pagos.forma_pago',
                'pagos.estado',
                'pagos.created_at',
                'pagos.updated_at',
                'pagos_cuotas.id as cuota_id',
                'pagos_cuotas.numero_cuota',
                'pagos_cuotas.fecha_programada',
                'pagos_cuotas.id_pago',
                'pagos_cuotas.fecha_pagada',
                'pagos_cuotas.monto as cuota_monto',
                'pagos_cuotas.boleta',
                'servicios.nombre_servicio'
            )
            ->get();

        $pagosAgrupados = [];

//        dd($objPagosRaw);

        foreach ($objPagosRaw as $row) {
            $idPago = $row->pago_id;

            if (!isset($pagosAgrupados[$idPago])) {
                $pagosAgrupados[$idPago] = [
                    'id' => $row->pago_id,
                    'user_id' => $row->user_id,
                    'id_pedido_pago' => $row->id_pedido_pago,
                    'tipo_pago' => $row->tipo_pago,
                    'cantidad_cuotas' => $row->cantidad_cuotas,
                    'monto_servicio' => $row->monto_servicio,
                    'fee_adicional' => $row->fee_adicional,
                    'id_cuota_pago' => $row->id_cuota_pago,
                    'igv' => $row->igv,
                    'total_pagar' => $row->total_pagar,
                    'costo_envio' => $row->costo_envio,
                    'pago_extra' => $row->pago_extra,
                    'metodo_pago' => $row->metodo_pago,
                    'forma_pago' => $row->forma_pago,
                    'nombre_servicio' => $row->nombre_servicio,
                    'estado' => $row->estado,
                    'created_at' => $row->created_at,
                    'updated_at' => $row->updated_at,
                    'cuotas' => [],
                ];
            }

            if ($row->id_cuota_pago !== null) {
                $pagosAgrupados[$idPago]['cuotas'][] = [
                    'id' => $row->cuota_id,
                    'id_pago' => $row->id_pago,
                    'numero_cuota' => $row->numero_cuota,
                    'fecha_programada' => $row->fecha_programada,
                    'fecha_pagada' => $row->fecha_pagada,
                    'monto' => $row->cuota_monto,
                    'boleta' => $row->boleta,
                ];
            }
        }


// Si prefieres un array numérico
        $pagosFinal = array_values($pagosAgrupados);

//        @dd($pagosFinal);

        return view('front.admin.compostario_id', [
            'usuario' => $usuario,
            'mascota' => $mascota,
            'objPedidos' => $objPedidos,
            // 'recojo' => $recojo,
            'conductores' => $conductores,
            'recojo_ida' => $recojo_ida,
            'recojo_vuelta' => $recojo_vuelta,
            'operarios' => $operarios,
            'objCompostajes' => $objCompostajes,
            'monitoreos' => $monitoreos,
            'ultimoNumero' => $ultimoNumero,
            'objConstancias' => $objConstancias,
            'pagosFinal' => $pagosFinal,
            'horarios' => $horarios


        ]);


    }

    public function subir_boleta(Request $request)
    {
        $data = $request->all();

//        @dd($data);

        $usuario = DB::table('usuarios')->where('id', $data['id_user'])->first();


        $file_boleta = $request->file('boleta_pdf');

//        @dd($file_boleta);

        if ($file_boleta) {

            $originalFileName = $file_boleta->getClientOriginalName();
            $path = $file_boleta->storeAs('boletas', $originalFileName, 'public'); // Guarda en storage/app/public/

            $boletaPath = storage_path("app/public/" . $path);

            // @dd($boletaPath);

            $argsMail = [
                'nombre_persona' => $usuario->nombres . ' ' . $usuario->apellidos
            ];

//            @dd($argsMail);

            DB::table('pagos_cuotas')->where('id', $data['id_cuota'])->update([
                'boleta' => $path,
            ]);

            Mail::to($usuario->email)->send(new EntregarBoleta($argsMail, $boletaPath));

            return redirect()->route('admin_pedido_id', $data['id_pedido'])->with('exito', 'Se ha guardado la información correctamente');
        }


    }

    public function registro_actividadlogistica(Request $request)
    {
        $data = $request->all();
        // @dd($data);
        // var_dump($data);
        // //return dd($data);
        // $password = $data['password'];
        DB::table('pedidos')->where('id_pedido', $data['id_pedido'])->update([
            'estado_logistica' => $data['estado_logistica'],
        ]);

        if (isset($data['inicio_logistica'])) {
            DB::table('pedidos')->where('id_pedido', $data['id_pedido'])->update([
                'estado_pedido' => 3,
            ]);
        }

        if ($data['estado_logistica'] == 5) {
            $argsRecojo = [
                'id_usuario' => $data['id_usuario'],
//                'fecha_recojo' => date('Y-m-d'),
                'etapa' => 2,
                'id_conductor' => 3,
                'conductor_confirmado' => 1
            ];

            $recojo_vuelta = DB::table('recojos')->insertGetId($argsRecojo);

            DB::table('pedidos')->where('id_pedido', $data['id_pedido'])->update([
                'id_recojo_vuelta' => $recojo_vuelta,
            ]);

            $plantillas = [
                ['tipo' => 'seguimiento_6', 'dias' => 0],
            ];

            foreach ($plantillas as $p) {
                DB::table('emails_programados')->insert([
                    'user_id' => $data['id_usuario'],
                    'email' => $data['email'],
                    'pedido_id' => $data['id_pedido'],
                    'tipo' => $p['tipo'],
                    'data' => json_encode([
                        'nombre_usuario' => $data['nombre_usuario'],
                        'nombre_mascota' => $data['nombre_mascota'],
                    ]),
                    'enviar_en' => now()->addDays($p['dias']),
                ]);
            }


        }


        return redirect()->route('admin_pedido_id', $data['id_pedido'])->with('exito', 'Se ha guardado la información correctamente');
    }


    public function enviar_constancia(Request $request)
    {

        $data = $request->all();

        $administrador_id = session()->get('user_id');

        $administrador = DB::table('administradores')->where('id_administrador', $administrador_id)->first();
        if (!$administrador) {
            return redirect()->route('admin_iniciar_sesion');
        } else {
            $administrador_id = session()->get('user_id');
        }

        // $request->validate([
        //     'foto_constancia' => 'required|image|mimes:jpeg,png,jpg,gif|max:2048'
        // ]);


        if ($request->hasFile('foto_constancia')) {

            // $file      = $request->file('foto_constancia');
            // $imageName =  $file->getClientOriginalName();

            // $destinationPath = 'public/images';
            // $file->move($destinationPath,$file->getClientOriginalName());

            // // Insertar directamente en la base de datos sin usar un modelo
            // DB::table('pedidos')->where('id_compostaje', $data['id_compostaje'])->update([
            //     'foto_constancia' => $imageName,

            // ]);

            $data = $request->all();
            // var_dump($data);s

            $imagePaths = [];
            foreach ($request->file('archivos') as $image) {

                $imagePath = $image->store('public/product-images');

                DB::table('monitoreoFotografias')->insert([
                    'id_operario' => $request->input('id_operario'),
                    'id_compostaje' => $request->input('id_compostaje'),
                    'id_mascota' => $request->input('id_mascota'),
                    'foto_url' => $imagePath
                ]);

                $imagePaths[] = $imagePath;

            }

            DB::table('pedidos_constancia')->where('id_compostaje', $data['id_compostaje'])->update([
                'foto_constancia' => 1,
            ]);

            return response()->json(['message' => 'Foto subida exitosamente'], 200);
        }

        return response()->json(['message' => 'No se pudo subir la foto'], 400);
    }

    public function eliminar_pedido(Request $request)
    {
        $data = $request->all();

        @dd($data);

        try {

            // Verificamos si el pedido existe
            $usuario = DB::table('usuarios')->where('id')->first();

            if (!$pedido) {
                return response()->json(['error' => 'Pedido no encontrado.'], 404);
            }

            // Eliminamos relaciones en orden de dependencias
            DB::table('mascotas')->where('pedido_id', $usuario)->delete();
            DB::table('pagos')->where('pedido_id', $pedido_id)->delete();
            DB::table('pedidos_productos')->where('pedido_id', $pedido_id)->delete();
            DB::table('pedidos_servicios')->where('pedido_id', $pedido_id)->delete();
            DB::table('recojos')->where('pedido_id', $pedido_id)->delete();

            // Finalmente eliminamos el pedido
            DB::table('pedidos')->where('id', $pedido_id)->delete();
            DB::table('usuarios')->where('id', $pedido_id)->delete();

            DB::commit();

            return response()->json(['mensaje' => 'Pedido y toda su información relacionada fueron eliminados.'], 200);
        } catch (\Exception $e) {
            DB::rollBack();
            return response()->json(['error' => 'Error al eliminar el pedido: ' . $e->getMessage()], 500);
        }
    }
}
